/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Optional;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.base.FluidStorageSingleTankMethods;
import me.jddev0.ep.block.entity.base.WorkerFluidMachineBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.FluidPumpMenu;
import me.jddev0.ep.util.ByteUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidPumpBlockEntity
extends WorkerFluidMachineBlockEntity<FluidTank, BlockPos> {
    public static final int NEXT_BLOCK_COOLDOWN = ModConfigs.COMMON_FLUID_PUMP_NEXT_BLOCK_COOLDOWN.getValue();
    public static final int EXTRACTION_DURATION = ModConfigs.COMMON_FLUID_PUMP_EXTRACTION_DURATION.getValue();
    public static final int RANGE = ModConfigs.COMMON_FLUID_PUMP_EXTRACTION_RANGE.getValue();
    public static final int DEPTH = ModConfigs.COMMON_FLUID_PUMP_EXTRACTION_DEPTH.getValue();
    private int xOffset = -1;
    private int yOffset = 0;
    private int zOffset = -1;
    private boolean extractingFluid = false;
    private final LazyOptional<IItemHandler> lazyItemHandlerSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> true, i -> false));

    public FluidPumpBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.FLUID_PUMP_ENTITY.get(), blockPos, blockState, "fluid_pump", 1, 1, (int)ModConfigs.COMMON_FLUID_PUMP_CAPACITY.getValue(), ModConfigs.COMMON_FLUID_PUMP_TRANSFER_RATE.getValue(), (int)ModConfigs.COMMON_FLUID_PUMP_CONSUMPTION_PER_TICK.getValue(), FluidStorageSingleTankMethods.INSTANCE, ModConfigs.COMMON_FLUID_PUMP_FLUID_TANK_CAPACITY.getValue() * 1000, UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY, UpgradeModuleModifier.RANGE, UpgradeModuleModifier.EXTRACTION_DEPTH);
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                FluidPumpBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    return stack.m_150930_(Items.f_42594_);
                }
                return super.isItemValid(slot, stack);
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    ItemStack itemStack = this.getStackInSlot(slot);
                    if (!(FluidPumpBlockEntity.this.f_58857_ == null || stack.m_41619_() || itemStack.m_41619_() || ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack))) {
                        FluidPumpBlockEntity.this.resetProgress();
                    }
                }
                super.setStackInSlot(slot, stack);
            }
        };
    }

    @Override
    protected FluidTank initFluidStorage() {
        return new FluidTank(this.baseTankCapacity){

            protected void onContentsChanged() {
                FluidPumpBlockEntity.this.m_6596_();
                FluidPumpBlockEntity.this.syncFluidToPlayers(32);
            }
        };
    }

    @Override
    protected ContainerData initContainerData() {
        return new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(FluidPumpBlockEntity.this.progress, index);
                    case 2, 3 -> ByteUtils.get2Bytes(FluidPumpBlockEntity.this.maxProgress, index - 2);
                    case 4, 5 -> ByteUtils.get2Bytes(FluidPumpBlockEntity.this.energyConsumptionLeft, index - 4);
                    case 6 -> {
                        if (FluidPumpBlockEntity.this.hasEnoughEnergy) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 7 -> FluidPumpBlockEntity.this.redstoneMode.ordinal();
                    case 8 -> FluidPumpBlockEntity.this.comparatorMode.ordinal();
                    case 9, 10 -> ByteUtils.get2Bytes(FluidPumpBlockEntity.this.xOffset, index - 9);
                    case 11, 12 -> ByteUtils.get2Bytes(FluidPumpBlockEntity.this.yOffset, index - 11);
                    case 13, 14 -> ByteUtils.get2Bytes(FluidPumpBlockEntity.this.zOffset, index - 13);
                    case 15 -> {
                        if (FluidPumpBlockEntity.this.extractingFluid) {
                            yield 1;
                        }
                        yield 0;
                    }
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: {
                        FluidPumpBlockEntity.this.progress = ByteUtils.with2Bytes(FluidPumpBlockEntity.this.progress, (short)value, index);
                        break;
                    }
                    case 2: 
                    case 3: {
                        FluidPumpBlockEntity.this.maxProgress = ByteUtils.with2Bytes(FluidPumpBlockEntity.this.maxProgress, (short)value, index - 2);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 7: {
                        FluidPumpBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                        break;
                    }
                    case 8: {
                        FluidPumpBlockEntity.this.comparatorMode = ComparatorMode.fromIndex(value);
                        break;
                    }
                }
            }

            public int m_6499_() {
                return 16;
            }
        };
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        this.syncFluidToPlayer(player);
        return new FluidPumpMenu(id, inventory, this, this.upgradeModuleInventory, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            return this.lazyItemHandlerSided.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.lazyFluidStorage.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("target.xOffset", this.xOffset);
        nbt.m_128405_("target.yOffset", this.yOffset);
        nbt.m_128405_("target.zOffset", this.zOffset);
        nbt.m_128379_("recipe.extractingFluid", this.extractingFluid);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.xOffset = nbt.m_128451_("target.xOffset");
        this.yOffset = nbt.m_128451_("target.yOffset");
        this.zOffset = nbt.m_128451_("target.zOffset");
        this.extractingFluid = nbt.m_128471_("recipe.extractingFluid");
    }

    @Override
    protected void onTickStart() {
        super.onTickStart();
        if (this.yOffset == 0) {
            this.goToNextOffset();
            this.m_6596_();
        }
    }

    @Override
    protected boolean hasWork() {
        return this.yOffset != 0 && this.itemHandler.getStackInSlot(0).m_150930_(Items.f_42594_);
    }

    @Override
    protected Optional<BlockPos> getCurrentWorkData() {
        return Optional.of(this.f_58858_.m_7918_(this.xOffset, this.yOffset, this.zOffset));
    }

    @Override
    protected double getWorkDataDependentWorkDuration(BlockPos targetPos) {
        return this.extractingFluid ? (double)EXTRACTION_DURATION : (double)NEXT_BLOCK_COOLDOWN;
    }

    @Override
    protected void onWorkStarted(BlockPos targetPos) {
        BlockState targetState = this.f_58857_.m_8055_(targetPos);
        if (!(targetState.m_60734_() instanceof BucketPickup)) {
            return;
        }
        FluidState targetFluidState = this.f_58857_.m_6425_(targetPos);
        if (targetFluidState.m_76178_()) {
            return;
        }
        if (((FluidTank)this.fluidStorage).fill(new FluidStack(targetFluidState.m_76152_(), 1000), IFluidHandler.FluidAction.SIMULATE) != 1000) {
            return;
        }
        this.extractingFluid = true;
    }

    @Override
    protected void onWorkCompleted(BlockPos targetPos) {
        BucketPickup targetBlock;
        ItemStack bucketItemStack;
        Block block;
        BlockState targetState = this.f_58857_.m_8055_(targetPos);
        if (this.extractingFluid && (block = targetState.m_60734_()) instanceof BucketPickup && !(bucketItemStack = (targetBlock = (BucketPickup)block).m_142598_((LevelAccessor)this.f_58857_, targetPos, targetState)).m_41619_()) {
            FluidStack fluidStack;
            this.f_58857_.m_142346_(null, GameEvent.f_157816_, targetPos);
            LazyOptional fluidStorageLazyOptional = bucketItemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
            if (!fluidStorageLazyOptional.isPresent()) {
                return;
            }
            IFluidHandlerItem fluidStorage = (IFluidHandlerItem)fluidStorageLazyOptional.orElse(null);
            if (fluidStorage.getTanks() == 1 && !(fluidStack = fluidStorage.getFluidInTank(0)).isEmpty()) {
                ((FluidTank)this.fluidStorage).fill(fluidStack.copy(), IFluidHandler.FluidAction.EXECUTE);
                BlockState newTargetState = this.f_58857_.m_8055_(targetPos);
                if (newTargetState.m_60795_() || newTargetState.m_247087_()) {
                    this.itemHandler.extractItem(0, 1, false);
                    this.f_58857_.m_7731_(targetPos, Blocks.f_50652_.m_49966_(), 3);
                }
            }
        }
        this.resetProgress();
        this.goToNextOffset();
    }

    @Override
    protected void resetProgress() {
        super.resetProgress();
        this.extractingFluid = false;
    }

    @Override
    protected void updateUpgradeModules() {
        this.xOffset = -1;
        this.yOffset = 0;
        this.zOffset = -1;
        super.updateUpgradeModules();
    }

    public void goToNextOffset() {
        int range = (int)Math.ceil((double)RANGE * this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.RANGE));
        int depth = (int)Math.ceil((double)DEPTH * this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.EXTRACTION_DEPTH));
        if (this.yOffset == 0) {
            this.yOffset = -1;
            this.xOffset = range;
            this.zOffset = 0;
        } else if (this.zOffset >= range - Math.abs(this.xOffset)) {
            if (-this.xOffset >= range) {
                --this.yOffset;
                if (-this.yOffset >= depth || this.m_58899_().m_123342_() + this.yOffset < this.f_58857_.m_141937_()) {
                    this.yOffset = -1;
                }
                this.xOffset = range;
                this.zOffset = 0;
                return;
            }
            --this.xOffset;
            this.zOffset = Math.abs(this.xOffset) - range;
        } else {
            ++this.zOffset;
        }
    }
}

