/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.base.FluidStorageMultiTankMethods;
import me.jddev0.ep.block.entity.base.SelectableRecipeFluidMachineBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.fluid.EnergizedPowerFluidStorage;
import me.jddev0.ep.fluid.ModFluids;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.item.ModItems;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.FiltrationPlantRecipe;
import me.jddev0.ep.recipe.ModRecipes;
import me.jddev0.ep.screen.FiltrationPlantMenu;
import me.jddev0.ep.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FiltrationPlantBlockEntity
extends SelectableRecipeFluidMachineBlockEntity<EnergizedPowerFluidStorage, FiltrationPlantRecipe> {
    public static final int TANK_CAPACITY = 1000 * ModConfigs.COMMON_FILTRATION_PLANT_TANK_CAPACITY.getValue();
    public static final int DIRTY_WATER_CONSUMPTION_PER_RECIPE = ModConfigs.COMMON_FILTRATION_PLANT_DIRTY_WATER_USAGE_PER_RECIPE.getValue();
    private final LazyOptional<IItemHandler> lazyItemHandlerSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0 || i == 1, i -> i == 2 || i == 3));

    public FiltrationPlantBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.FILTRATION_PLANT_ENTITY.get(), blockPos, blockState, "filtration_plant", FiltrationPlantMenu::new, 4, (RecipeType)ModRecipes.FILTRATION_PLANT_TYPE.get(), (RecipeSerializer)ModRecipes.FILTRATION_PLANT_SERIALIZER.get(), (int)ModConfigs.COMMON_FILTRATION_PLANT_RECIPE_DURATION.getValue(), ModConfigs.COMMON_FILTRATION_PLANT_CAPACITY.getValue(), (int)ModConfigs.COMMON_FILTRATION_PLANT_TRANSFER_RATE.getValue(), ModConfigs.COMMON_FILTRATION_PLANT_CONSUMPTION_PER_TICK.getValue(), FluidStorageMultiTankMethods.INSTANCE, TANK_CAPACITY, UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                FiltrationPlantBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return switch (slot) {
                    case 0, 1 -> stack.m_150930_((Item)ModItems.CHARCOAL_FILTER.get());
                    case 2, 3 -> false;
                    default -> super.isItemValid(slot, stack);
                };
            }
        };
    }

    @Override
    protected EnergizedPowerFluidStorage initFluidStorage() {
        return new EnergizedPowerFluidStorage(new int[]{this.baseTankCapacity, this.baseTankCapacity}){

            @Override
            protected void onContentsChanged() {
                FiltrationPlantBlockEntity.this.m_6596_();
                FiltrationPlantBlockEntity.this.syncFluidToPlayers(32);
            }

            @Override
            public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
                if (!super.isFluidValid(tank, stack)) {
                    return false;
                }
                return switch (tank) {
                    case 0 -> stack.isFluidEqual(new FluidStack((Fluid)ModFluids.DIRTY_WATER.get(), 1));
                    case 1 -> stack.isFluidEqual(new FluidStack((Fluid)Fluids.f_76193_, 1));
                    default -> false;
                };
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            return this.lazyItemHandlerSided.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.lazyFluidStorage.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void craftItem(FiltrationPlantRecipe recipe) {
        if (this.f_58857_ == null || !this.hasRecipe()) {
            return;
        }
        ((EnergizedPowerFluidStorage)this.fluidStorage).drain(new FluidStack((Fluid)ModFluids.DIRTY_WATER.get(), DIRTY_WATER_CONSUMPTION_PER_RECIPE), IFluidHandler.FluidAction.EXECUTE);
        ((EnergizedPowerFluidStorage)this.fluidStorage).fill(new FluidStack((Fluid)Fluids.f_76193_, DIRTY_WATER_CONSUMPTION_PER_RECIPE), IFluidHandler.FluidAction.EXECUTE);
        for (int i = 0; i < 2; ++i) {
            ItemStack charcoalFilter = this.itemHandler.getStackInSlot(i).m_41777_();
            if (charcoalFilter.m_41619_() && !charcoalFilter.m_150930_((Item)ModItems.CHARCOAL_FILTER.get())) continue;
            if (charcoalFilter.m_220157_(1, this.f_58857_.f_46441_, null)) {
                this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
                continue;
            }
            this.itemHandler.setStackInSlot(i, charcoalFilter);
        }
        ItemStack[] outputs = recipe.generateOutputs(this.f_58857_.f_46441_);
        if (!outputs[0].m_41619_()) {
            this.itemHandler.setStackInSlot(2, outputs[0].m_255036_(this.itemHandler.getStackInSlot(2).m_41613_() + outputs[0].m_41613_()));
        }
        if (!outputs[1].m_41619_()) {
            this.itemHandler.setStackInSlot(3, outputs[1].m_255036_(this.itemHandler.getStackInSlot(3).m_41613_() + outputs[1].m_41613_()));
        }
        this.resetProgress();
    }

    @Override
    protected boolean canCraftRecipe(SimpleContainer inventory, FiltrationPlantRecipe recipe) {
        ItemStack[] maxOutputs = recipe.getMaxOutputCounts();
        return !(this.f_58857_ == null || ((EnergizedPowerFluidStorage)this.fluidStorage).getFluid(0).getAmount() < DIRTY_WATER_CONSUMPTION_PER_RECIPE || ((EnergizedPowerFluidStorage)this.fluidStorage).getCapacity(1) - ((EnergizedPowerFluidStorage)this.fluidStorage).getFluid(1).getAmount() < DIRTY_WATER_CONSUMPTION_PER_RECIPE || !this.itemHandler.getStackInSlot(0).m_150930_((Item)ModItems.CHARCOAL_FILTER.get()) || !this.itemHandler.getStackInSlot(1).m_150930_((Item)ModItems.CHARCOAL_FILTER.get()) || !maxOutputs[0].m_41619_() && !InventoryUtils.canInsertItemIntoSlot((Container)inventory, 2, maxOutputs[0]) || !maxOutputs[1].m_41619_() && !InventoryUtils.canInsertItemIntoSlot((Container)inventory, 3, maxOutputs[1]));
    }
}

