/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.List;
import me.jddev0.ep.block.ChargingStationBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.base.UpgradableEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.integration.curios.CuriosCompatUtils;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.ChargingStationMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChargingStationBlockEntity
extends UpgradableEnergyStorageBlockEntity<ReceiveOnlyEnergyStorage> {
    public static final int MAX_CHARGING_DISTANCE = ModConfigs.COMMON_CHARGING_STATION_MAX_CHARGING_DISTANCE.getValue();

    public ChargingStationBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.CHARGING_STATION_ENTITY.get(), blockPos, blockState, "charging_station", ModConfigs.COMMON_CHARGING_STATION_CAPACITY.getValue(), ModConfigs.COMMON_CHARGING_STATION_TRANSFER_RATE.getValue(), UpgradeModuleModifier.ENERGY_CAPACITY, UpgradeModuleModifier.RANGE);
    }

    @Override
    protected ReceiveOnlyEnergyStorage initEnergyStorage() {
        return new ReceiveOnlyEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            @Override
            public int getCapacity() {
                return Math.max(1, (int)Math.ceil((double)this.capacity * ChargingStationBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            @Override
            public int getMaxReceive() {
                return Math.max(1, (int)Math.ceil((double)this.maxReceive * ChargingStationBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }

            @Override
            protected void onChange() {
                ChargingStationBlockEntity.this.m_6596_();
                ChargingStationBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        return new ChargingStationMenu(id, inventory, this, this.upgradeModuleInventory);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, ChargingStationBlockEntity blockEntity) {
        int energyPerTick;
        if (level.f_46443_) {
            return;
        }
        int maxChargingDistance = (int)Math.ceil((double)MAX_CHARGING_DISTANCE * blockEntity.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.RANGE));
        List players = level.m_142425_(EntityTypeTest.m_156916_(Player.class), AABB.m_82321_((BoundingBox)BoundingBox.m_162375_((Vec3i)new Vec3i(blockPos.m_123341_() - maxChargingDistance, blockPos.m_123342_() - maxChargingDistance, blockPos.m_123343_() - maxChargingDistance), (Vec3i)new Vec3i(blockPos.m_123341_() + maxChargingDistance, blockPos.m_123342_() + maxChargingDistance, blockPos.m_123343_() + maxChargingDistance))), EntitySelector.f_20408_.and(entity -> entity.m_20238_(blockPos.m_252807_()) <= (double)(maxChargingDistance * maxChargingDistance)));
        int energyPerTickLeft = energyPerTick = Math.min(((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getMaxReceive(), ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy());
        block0: for (Player player : players) {
            if (player.m_21224_()) continue;
            Inventory inventory = player.m_150109_();
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                IEnergyStorage energyStorage;
                ItemStack itemStack = inventory.m_8020_(i);
                LazyOptional energyStorageLazyOptional = itemStack.getCapability(ForgeCapabilities.ENERGY);
                if (energyStorageLazyOptional.isPresent() && (energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null)).canReceive() && (energyPerTickLeft -= energyStorage.receiveEnergy(energyPerTickLeft, false)) == 0) break block0;
            }
            List<ItemStack> curiosItemStacks = CuriosCompatUtils.getCuriosItemStacks(inventory);
            for (ItemStack itemStack : curiosItemStacks) {
                IEnergyStorage energyStorage;
                LazyOptional energyStorageLazyOptional = itemStack.getCapability(ForgeCapabilities.ENERGY);
                if (!energyStorageLazyOptional.isPresent() || !(energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null)).canReceive() || (energyPerTickLeft -= energyStorage.receiveEnergy(energyPerTickLeft, false)) != 0) continue;
                break block0;
            }
        }
        if (energyPerTickLeft == energyPerTick) {
            if (!level.m_8055_(blockPos).m_61138_((Property)ChargingStationBlock.CHARGING) || ((Boolean)level.m_8055_(blockPos).m_61143_((Property)ChargingStationBlock.CHARGING)).booleanValue()) {
                level.m_7731_(blockPos, (BlockState)state.m_61124_((Property)ChargingStationBlock.CHARGING, (Comparable)Boolean.valueOf(false)), 3);
            }
        } else {
            if (!level.m_8055_(blockPos).m_61138_((Property)ChargingStationBlock.CHARGING) || !((Boolean)level.m_8055_(blockPos).m_61143_((Property)ChargingStationBlock.CHARGING)).booleanValue()) {
                level.m_7731_(blockPos, (BlockState)state.m_61124_((Property)ChargingStationBlock.CHARGING, (Comparable)Boolean.TRUE), 3);
            }
            ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).setEnergy(((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() - energyPerTick + energyPerTickLeft);
        }
    }
}

