/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.List;
import java.util.Optional;
import me.jddev0.ep.block.BlockPlacerBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.base.NoWorkData;
import me.jddev0.ep.block.entity.base.WorkerMachineBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.machine.CheckboxUpdate;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.BlockPlacerMenu;
import me.jddev0.ep.util.ByteUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockPlacerBlockEntity
extends WorkerMachineBlockEntity<NoWorkData>
implements CheckboxUpdate {
    private static final List<@NotNull ResourceLocation> PLACEMENT_BLACKLIST = ModConfigs.COMMON_BLOCK_PLACER_PLACEMENT_BLACKLIST.getValue();
    private final LazyOptional<IItemHandler> lazyItemHandlerSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> true, i -> false));
    private boolean inverseRotation;

    public BlockPlacerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.BLOCK_PLACER_ENTITY.get(), blockPos, blockState, "block_placer", 1, (int)ModConfigs.COMMON_BLOCK_PLACER_PLACEMENT_DURATION.getValue(), (int)ModConfigs.COMMON_BLOCK_PLACER_CAPACITY.getValue(), ModConfigs.COMMON_BLOCK_PLACER_TRANSFER_RATE.getValue(), ModConfigs.COMMON_BLOCK_PLACER_ENERGY_CONSUMPTION_PER_TICK.getValue(), UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                BlockPlacerBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    return stack.m_41720_() instanceof BlockItem;
                }
                return super.isItemValid(slot, stack);
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    ItemStack itemStack = this.getStackInSlot(slot);
                    if (!(BlockPlacerBlockEntity.this.f_58857_ == null || stack.m_41619_() || itemStack.m_41619_() || ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack))) {
                        BlockPlacerBlockEntity.this.resetProgress();
                    }
                }
                super.setStackInSlot(slot, stack);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    @Override
    protected ContainerData initContainerData() {
        return new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(BlockPlacerBlockEntity.this.progress, index);
                    case 2, 3 -> ByteUtils.get2Bytes(BlockPlacerBlockEntity.this.maxProgress, index - 2);
                    case 4, 5 -> ByteUtils.get2Bytes(BlockPlacerBlockEntity.this.energyConsumptionLeft, index - 4);
                    case 6 -> {
                        if (BlockPlacerBlockEntity.this.hasEnoughEnergy) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 7 -> {
                        if (BlockPlacerBlockEntity.this.inverseRotation) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 8 -> BlockPlacerBlockEntity.this.redstoneMode.ordinal();
                    case 9 -> BlockPlacerBlockEntity.this.comparatorMode.ordinal();
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: {
                        BlockPlacerBlockEntity.this.progress = ByteUtils.with2Bytes(BlockPlacerBlockEntity.this.progress, (short)value, index);
                        break;
                    }
                    case 2: 
                    case 3: {
                        BlockPlacerBlockEntity.this.maxProgress = ByteUtils.with2Bytes(BlockPlacerBlockEntity.this.maxProgress, (short)value, index - 2);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 7: {
                        BlockPlacerBlockEntity.this.inverseRotation = value != 0;
                        break;
                    }
                    case 8: {
                        BlockPlacerBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                        break;
                    }
                    case 9: {
                        BlockPlacerBlockEntity.this.comparatorMode = ComparatorMode.fromIndex(value);
                    }
                }
            }

            public int m_6499_() {
                return 10;
            }
        };
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        return new BlockPlacerMenu(id, inventory, this, this.upgradeModuleInventory, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            return this.lazyItemHandlerSided.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("inverse_rotation", this.inverseRotation);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inverseRotation = nbt.m_128471_("inverse_rotation");
    }

    @Override
    protected boolean hasWork() {
        Item item;
        ItemStack itemStack = this.itemHandler.getStackInSlot(0);
        if (itemStack.m_41619_() || !((item = itemStack.m_41720_()) instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItemStack = (BlockItem)item;
        return !PLACEMENT_BLACKLIST.contains(ForgeRegistries.BLOCKS.getKey((Object)blockItemStack.m_40614_()));
    }

    @Override
    protected Optional<NoWorkData> getCurrentWorkData() {
        return Optional.of(NoWorkData.INSTANCE);
    }

    @Override
    protected void onWorkStarted(NoWorkData workData) {
    }

    @Override
    protected void onWorkCompleted(NoWorkData workData) {
        Direction direction;
        int energyConsumptionPerTick = this.getEnergyConsumptionFor(workData);
        ItemStack itemStack = this.itemHandler.getStackInSlot(0);
        if (itemStack.m_41619_()) {
            this.energyConsumptionLeft = energyConsumptionPerTick;
            this.m_6596_();
            return;
        }
        BlockPos blockPosPlacement = this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_((Property)BlockPlacerBlock.FACING));
        BlockItem blockItem = (BlockItem)itemStack.m_41720_();
        if (this.inverseRotation) {
            direction = switch ((Direction)this.m_58900_().m_61143_((Property)BlockPlacerBlock.FACING)) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.DOWN -> Direction.UP;
                case Direction.UP -> Direction.DOWN;
                case Direction.NORTH -> Direction.SOUTH;
                case Direction.SOUTH -> Direction.NORTH;
                case Direction.WEST -> Direction.EAST;
                case Direction.EAST -> Direction.WEST;
            };
        } else {
            direction = (Direction)this.m_58900_().m_61143_((Property)BlockPlacerBlock.FACING);
        }
        InteractionResult result = blockItem.m_40576_((BlockPlaceContext)new DirectionalPlaceContext(this.f_58857_, blockPosPlacement, direction, itemStack, direction){

            @NotNull
            public Direction m_7820_() {
                return direction;
            }

            @NotNull
            public @NotNull Direction @NotNull [] m_6232_() {
                Direction[] directionArray;
                switch (direction) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case DOWN: {
                        Direction[] directionArray2 = new Direction[6];
                        directionArray2[0] = Direction.DOWN;
                        directionArray2[1] = Direction.NORTH;
                        directionArray2[2] = Direction.EAST;
                        directionArray2[3] = Direction.SOUTH;
                        directionArray2[4] = Direction.WEST;
                        directionArray = directionArray2;
                        directionArray2[5] = Direction.UP;
                        break;
                    }
                    case UP: {
                        Direction[] directionArray3 = new Direction[6];
                        directionArray3[0] = Direction.UP;
                        directionArray3[1] = Direction.DOWN;
                        directionArray3[2] = Direction.NORTH;
                        directionArray3[3] = Direction.EAST;
                        directionArray3[4] = Direction.SOUTH;
                        directionArray = directionArray3;
                        directionArray3[5] = Direction.WEST;
                        break;
                    }
                    case NORTH: {
                        Direction[] directionArray4 = new Direction[6];
                        directionArray4[0] = Direction.NORTH;
                        directionArray4[1] = Direction.EAST;
                        directionArray4[2] = Direction.WEST;
                        directionArray4[3] = Direction.UP;
                        directionArray4[4] = Direction.DOWN;
                        directionArray = directionArray4;
                        directionArray4[5] = Direction.SOUTH;
                        break;
                    }
                    case SOUTH: {
                        Direction[] directionArray5 = new Direction[6];
                        directionArray5[0] = Direction.SOUTH;
                        directionArray5[1] = Direction.EAST;
                        directionArray5[2] = Direction.WEST;
                        directionArray5[3] = Direction.UP;
                        directionArray5[4] = Direction.DOWN;
                        directionArray = directionArray5;
                        directionArray5[5] = Direction.NORTH;
                        break;
                    }
                    case WEST: {
                        Direction[] directionArray6 = new Direction[6];
                        directionArray6[0] = Direction.WEST;
                        directionArray6[1] = Direction.SOUTH;
                        directionArray6[2] = Direction.UP;
                        directionArray6[3] = Direction.DOWN;
                        directionArray6[4] = Direction.NORTH;
                        directionArray = directionArray6;
                        directionArray6[5] = Direction.EAST;
                        break;
                    }
                    case EAST: {
                        Direction[] directionArray7 = new Direction[6];
                        directionArray7[0] = Direction.EAST;
                        directionArray7[1] = Direction.SOUTH;
                        directionArray7[2] = Direction.UP;
                        directionArray7[3] = Direction.DOWN;
                        directionArray7[4] = Direction.NORTH;
                        directionArray = directionArray7;
                        directionArray7[5] = Direction.WEST;
                    }
                }
                return directionArray;
            }

            public boolean m_7058_() {
                return false;
            }
        });
        if (result == InteractionResult.FAIL) {
            this.energyConsumptionLeft = energyConsumptionPerTick;
            this.m_6596_();
            return;
        }
        this.itemHandler.setStackInSlot(0, itemStack);
        this.resetProgress();
    }

    public void setInverseRotation(boolean inverseRotation) {
        this.inverseRotation = inverseRotation;
        BlockPlacerBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)this.m_58900_());
    }

    @Override
    public void setCheckbox(int checkboxId, boolean checked) {
        switch (checkboxId) {
            case 0: {
                this.setInverseRotation(checked);
            }
        }
    }
}

