/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Arrays;
import me.jddev0.ep.block.AssemblingMachineBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.base.SimpleRecipeMachineBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.AssemblingMachineRecipe;
import me.jddev0.ep.recipe.ModRecipes;
import me.jddev0.ep.screen.AssemblingMachineMenu;
import me.jddev0.ep.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssemblingMachineBlockEntity
extends SimpleRecipeMachineBlockEntity<AssemblingMachineRecipe> {
    private final LazyOptional<IItemHandler> lazyItemHandlerSidedTopBottom = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i >= 0 && i < 4, i -> i == 4));
    private final LazyOptional<IItemHandler> lazyItemHandlerSidedFront = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 3, i -> i == 4));
    private final LazyOptional<IItemHandler> lazyItemHandlerSidedBack = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i == 4));
    private final LazyOptional<IItemHandler> lazyItemHandlerSidedLeft = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 1, i -> i == 4));
    private final LazyOptional<IItemHandler> lazyItemHandlerSidedRight = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 2, i -> i == 4));

    public AssemblingMachineBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.ASSEMBLING_MACHINE_ENTITY.get(), blockPos, blockState, "assembling_machine", AssemblingMachineMenu::new, 5, (RecipeType)ModRecipes.ASSEMBLING_MACHINE_TYPE.get(), (int)ModConfigs.COMMON_ASSEMBLING_MACHINE_RECIPE_DURATION.getValue(), (int)ModConfigs.COMMON_ASSEMBLING_MACHINE_CAPACITY.getValue(), ModConfigs.COMMON_ASSEMBLING_MACHINE_TRANSFER_RATE.getValue(), ModConfigs.COMMON_ASSEMBLING_MACHINE_ENERGY_CONSUMPTION_PER_TICK.getValue(), UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return switch (slot) {
                    case 0, 1, 2, 3 -> {
                        if (AssemblingMachineBlockEntity.this.f_58857_ == null || AssemblingMachineBlockEntity.this.f_58857_.m_7465_().m_44013_((RecipeType)AssemblingMachineRecipe.Type.INSTANCE).stream().map(AssemblingMachineRecipe::getInputs).anyMatch(inputs -> Arrays.stream(inputs).map(AssemblingMachineRecipe.IngredientWithCount::input).anyMatch(ingredient -> ingredient.test(stack)))) {
                            yield true;
                        }
                        yield false;
                    }
                    case 4 -> false;
                    default -> false;
                };
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                if (slot >= 0 && slot < 4) {
                    ItemStack itemStack = this.getStackInSlot(slot);
                    if (!(AssemblingMachineBlockEntity.this.f_58857_ == null || stack.m_41619_() || itemStack.m_41619_() || ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack))) {
                        AssemblingMachineBlockEntity.this.resetProgress();
                    }
                }
                super.setStackInSlot(slot, stack);
            }

            protected void onContentsChanged(int slot) {
                AssemblingMachineBlockEntity.this.m_6596_();
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            Direction facing = (Direction)this.m_58900_().m_61143_((Property)AssemblingMachineBlock.FACING);
            if (facing == side) {
                return this.lazyItemHandlerSidedFront.cast();
            }
            if (facing.m_122424_() == side) {
                return this.lazyItemHandlerSidedBack.cast();
            }
            if (facing.m_122427_() == side) {
                return this.lazyItemHandlerSidedLeft.cast();
            }
            if (facing.m_122428_() == side) {
                return this.lazyItemHandlerSidedRight.cast();
            }
            return this.lazyItemHandlerSidedTopBottom.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void craftItem(AssemblingMachineRecipe recipe) {
        if (this.f_58857_ == null || !this.hasRecipe()) {
            return;
        }
        AssemblingMachineRecipe.IngredientWithCount[] inputs = recipe.getInputs();
        boolean[] usedIndices = new boolean[4];
        for (int i = 0; i < 4; ++i) {
            usedIndices[i] = this.itemHandler.getStackInSlot(i).m_41619_();
        }
        int len = Math.min(inputs.length, 4);
        for (int i = 0; i < len; ++i) {
            AssemblingMachineRecipe.IngredientWithCount input = inputs[i];
            int indexMinCount = -1;
            int minCount = Integer.MAX_VALUE;
            for (int j = 0; j < 4; ++j) {
                if (usedIndices[j]) continue;
                ItemStack item = this.itemHandler.getStackInSlot(j);
                if (indexMinCount != -1 && item.m_41613_() >= minCount || !input.input().test(item) || item.m_41613_() < input.count()) continue;
                indexMinCount = j;
                minCount = item.m_41613_();
            }
            if (indexMinCount == -1) {
                return;
            }
            usedIndices[indexMinCount] = true;
            this.itemHandler.extractItem(indexMinCount, input.count(), false);
        }
        this.itemHandler.setStackInSlot(4, recipe.m_8043_(this.f_58857_.m_9598_()).m_255036_(this.itemHandler.getStackInSlot(4).m_41613_() + recipe.m_8043_(this.f_58857_.m_9598_()).m_41613_()));
        this.resetProgress();
    }

    @Override
    protected boolean canCraftRecipe(SimpleContainer inventory, AssemblingMachineRecipe recipe) {
        return this.f_58857_ != null && InventoryUtils.canInsertItemIntoSlot((Container)inventory, 4, recipe.m_8043_(this.f_58857_.m_9598_()));
    }
}

