/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.List;
import java.util.Optional;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.base.ConfigurableUpgradableInventoryEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.SyncFurnaceRecipeTypeS2CPacket;
import me.jddev0.ep.recipe.FurnaceRecipeTypePacketUpdate;
import me.jddev0.ep.screen.AdvancedPoweredFurnaceMenu;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.InventoryUtils;
import me.jddev0.ep.util.RecipeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancedPoweredFurnaceBlockEntity
extends ConfigurableUpgradableInventoryEnergyStorageBlockEntity<ReceiveOnlyEnergyStorage, ItemStackHandler>
implements FurnaceRecipeTypePacketUpdate {
    private static final List<@NotNull ResourceLocation> RECIPE_BLACKLIST = ModConfigs.COMMON_ADVANCED_POWERED_FURNACE_RECIPE_BLACKLIST.getValue();
    private static final int ENERGY_USAGE_PER_INPUT_PER_TICK = ModConfigs.COMMON_ADVANCED_POWERED_FURNACE_ENERGY_CONSUMPTION_PER_INPUT_PER_TICK.getValue();
    public static final float RECIPE_DURATION_MULTIPLIER = ModConfigs.COMMON_ADVANCED_POWERED_FURNACE_RECIPE_DURATION_MULTIPLIER.getValue().floatValue();
    private final LazyOptional<IItemHandler> lazyItemHandlerSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i >= 0 && i < 3, i -> i >= 3 && i < 6));
    private int[] progress = new int[]{0, 0, 0};
    private int[] maxProgress = new int[]{0, 0, 0};
    private int[] energyConsumptionLeft = new int[]{-1, -1, -1};
    private boolean[] hasEnoughEnergy = new boolean[]{false, false, false};
    @NotNull
    private RecipeType<? extends AbstractCookingRecipe> recipeType = RecipeType.f_44108_;

    public AdvancedPoweredFurnaceBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.ADVANCED_POWERED_FURNACE_ENTITY.get(), blockPos, blockState, "advanced_powered_furnace", ModConfigs.COMMON_ADVANCED_POWERED_FURNACE_CAPACITY.getValue(), ModConfigs.COMMON_ADVANCED_POWERED_FURNACE_TRANSFER_RATE.getValue(), 6, UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY, UpgradeModuleModifier.FURNACE_MODE);
    }

    @Override
    protected ReceiveOnlyEnergyStorage initEnergyStorage() {
        return new ReceiveOnlyEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            @Override
            public int getCapacity() {
                return Math.max(1, (int)Math.ceil((double)this.capacity * AdvancedPoweredFurnaceBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            @Override
            public int getMaxReceive() {
                return Math.max(1, (int)Math.ceil((double)this.maxReceive * AdvancedPoweredFurnaceBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }

            @Override
            protected void onChange() {
                AdvancedPoweredFurnaceBlockEntity.this.m_6596_();
                AdvancedPoweredFurnaceBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                AdvancedPoweredFurnaceBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return switch (slot) {
                    case 0, 1, 2 -> {
                        if (AdvancedPoweredFurnaceBlockEntity.this.f_58857_ == null || RecipeUtils.isIngredientOfAny(AdvancedPoweredFurnaceBlockEntity.this.f_58857_, AdvancedPoweredFurnaceBlockEntity.this.getRecipeForFurnaceModeUpgrade(), stack)) {
                            yield true;
                        }
                        yield false;
                    }
                    case 3, 4, 5 -> false;
                    default -> super.isItemValid(slot, stack);
                };
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                if (slot >= 0 && slot < 3) {
                    ItemStack itemStack = this.getStackInSlot(slot);
                    if (!(AdvancedPoweredFurnaceBlockEntity.this.f_58857_ == null || stack.m_41619_() || itemStack.m_41619_() || ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack))) {
                        AdvancedPoweredFurnaceBlockEntity.this.resetProgress(slot, AdvancedPoweredFurnaceBlockEntity.this.f_58858_, AdvancedPoweredFurnaceBlockEntity.this.f_58857_.m_8055_(AdvancedPoweredFurnaceBlockEntity.this.f_58858_));
                    }
                }
                super.setStackInSlot(slot, stack);
            }
        };
    }

    @Override
    protected ContainerData initContainerData() {
        return new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(AdvancedPoweredFurnaceBlockEntity.this.energyConsumptionLeft[0], index);
                    case 2, 3 -> ByteUtils.get2Bytes(AdvancedPoweredFurnaceBlockEntity.this.energyConsumptionLeft[1], index - 2);
                    case 4, 5 -> ByteUtils.get2Bytes(AdvancedPoweredFurnaceBlockEntity.this.energyConsumptionLeft[2], index - 4);
                    case 6, 7 -> ByteUtils.get2Bytes(AdvancedPoweredFurnaceBlockEntity.this.progress[0], index - 6);
                    case 8, 9 -> ByteUtils.get2Bytes(AdvancedPoweredFurnaceBlockEntity.this.maxProgress[0], index - 8);
                    case 10, 11 -> ByteUtils.get2Bytes(AdvancedPoweredFurnaceBlockEntity.this.progress[1], index - 10);
                    case 12, 13 -> ByteUtils.get2Bytes(AdvancedPoweredFurnaceBlockEntity.this.maxProgress[1], index - 12);
                    case 14, 15 -> ByteUtils.get2Bytes(AdvancedPoweredFurnaceBlockEntity.this.progress[2], index - 14);
                    case 16, 17 -> ByteUtils.get2Bytes(AdvancedPoweredFurnaceBlockEntity.this.maxProgress[2], index - 16);
                    case 18 -> {
                        if (AdvancedPoweredFurnaceBlockEntity.this.hasEnoughEnergy[0]) {
                            yield 0;
                        }
                        yield 1;
                    }
                    case 19 -> {
                        if (AdvancedPoweredFurnaceBlockEntity.this.hasEnoughEnergy[1]) {
                            yield 0;
                        }
                        yield 1;
                    }
                    case 20 -> {
                        if (AdvancedPoweredFurnaceBlockEntity.this.hasEnoughEnergy[2]) {
                            yield 0;
                        }
                        yield 1;
                    }
                    case 21 -> AdvancedPoweredFurnaceBlockEntity.this.redstoneMode.ordinal();
                    case 22 -> AdvancedPoweredFurnaceBlockEntity.this.comparatorMode.ordinal();
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 6: 
                    case 7: {
                        AdvancedPoweredFurnaceBlockEntity.this.progress[0] = ByteUtils.with2Bytes(AdvancedPoweredFurnaceBlockEntity.this.progress[0], (short)value, index - 6);
                        break;
                    }
                    case 8: 
                    case 9: {
                        AdvancedPoweredFurnaceBlockEntity.this.maxProgress[0] = ByteUtils.with2Bytes(AdvancedPoweredFurnaceBlockEntity.this.maxProgress[0], (short)value, index - 8);
                        break;
                    }
                    case 10: 
                    case 11: {
                        AdvancedPoweredFurnaceBlockEntity.this.progress[1] = ByteUtils.with2Bytes(AdvancedPoweredFurnaceBlockEntity.this.progress[1], (short)value, index - 10);
                        break;
                    }
                    case 12: 
                    case 13: {
                        AdvancedPoweredFurnaceBlockEntity.this.maxProgress[1] = ByteUtils.with2Bytes(AdvancedPoweredFurnaceBlockEntity.this.maxProgress[1], (short)value, index - 12);
                        break;
                    }
                    case 14: 
                    case 15: {
                        AdvancedPoweredFurnaceBlockEntity.this.progress[2] = ByteUtils.with2Bytes(AdvancedPoweredFurnaceBlockEntity.this.progress[2], (short)value, index - 14);
                        break;
                    }
                    case 16: 
                    case 17: {
                        AdvancedPoweredFurnaceBlockEntity.this.maxProgress[2] = ByteUtils.with2Bytes(AdvancedPoweredFurnaceBlockEntity.this.maxProgress[2], (short)value, index - 16);
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 18: 
                    case 19: 
                    case 20: {
                        break;
                    }
                    case 21: {
                        AdvancedPoweredFurnaceBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                        break;
                    }
                    case 22: {
                        AdvancedPoweredFurnaceBlockEntity.this.comparatorMode = ComparatorMode.fromIndex(value);
                    }
                }
            }

            public int m_6499_() {
                return 23;
            }
        };
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        ModMessages.sendToPlayer(new SyncFurnaceRecipeTypeS2CPacket(this.getRecipeForFurnaceModeUpgrade(), this.m_58899_()), (ServerPlayer)player);
        return new AdvancedPoweredFurnaceMenu(id, inventory, this, this.upgradeModuleInventory, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            return this.lazyItemHandlerSided.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag nbt) {
        int i;
        super.m_183515_(nbt);
        for (i = 0; i < 3; ++i) {
            nbt.m_128365_("recipe.progress." + i, (Tag)IntTag.m_128679_((int)this.progress[i]));
        }
        for (i = 0; i < 3; ++i) {
            nbt.m_128365_("recipe.max_progress." + i, (Tag)IntTag.m_128679_((int)this.maxProgress[i]));
        }
        for (i = 0; i < 3; ++i) {
            nbt.m_128365_("recipe.energy_consumption_left." + i, (Tag)IntTag.m_128679_((int)this.energyConsumptionLeft[i]));
        }
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        int i;
        super.m_142466_(nbt);
        for (i = 0; i < 3; ++i) {
            this.progress[i] = nbt.m_128451_("recipe.progress." + i);
        }
        for (i = 0; i < 3; ++i) {
            this.maxProgress[i] = nbt.m_128451_("recipe.max_progress." + i);
        }
        for (i = 0; i < 3; ++i) {
            this.energyConsumptionLeft[i] = nbt.m_128451_("recipe.energy_consumption_left." + i);
        }
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, AdvancedPoweredFurnaceBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_))) {
            return;
        }
        boolean hasNoRecipe = true;
        int hasNotEnoughEnergyCount = 0;
        for (int i = 0; i < 3; ++i) {
            if (AdvancedPoweredFurnaceBlockEntity.hasRecipe(i, blockEntity)) {
                hasNoRecipe = false;
                SimpleContainer inventory = new SimpleContainer(2);
                inventory.m_6836_(0, blockEntity.itemHandler.getStackInSlot(i));
                inventory.m_6836_(1, blockEntity.itemHandler.getStackInSlot(3 + i));
                Optional<? extends AbstractCookingRecipe> recipe = blockEntity.getRecipeFor((Container)inventory, level);
                if (recipe.isEmpty()) continue;
                int cookingTime = recipe.get().m_43753_();
                if (blockEntity.maxProgress[i] == 0) {
                    blockEntity.maxProgress[i] = Math.max(1, (int)Math.ceil((double)((float)cookingTime * RECIPE_DURATION_MULTIPLIER / 6.0f) / blockEntity.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.SPEED)));
                }
                int energyUsagePerInputPerTick = Math.max(1, (int)Math.ceil((double)ENERGY_USAGE_PER_INPUT_PER_TICK * blockEntity.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CONSUMPTION)));
                if (blockEntity.energyConsumptionLeft[i] < 0) {
                    blockEntity.energyConsumptionLeft[i] = energyUsagePerInputPerTick * blockEntity.maxProgress[i];
                }
                if (energyUsagePerInputPerTick <= ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy()) {
                    blockEntity.hasEnoughEnergy[i] = true;
                    if (level.m_8055_(blockPos).m_61138_((Property)BlockStateProperties.f_61443_) && !((Boolean)level.m_8055_(blockPos).m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
                        level.m_7731_(blockPos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 3);
                    }
                    if (blockEntity.progress[i] < 0 || blockEntity.maxProgress[i] < 0 || blockEntity.energyConsumptionLeft[i] < 0) {
                        blockEntity.resetProgress(i, blockPos, state);
                        AdvancedPoweredFurnaceBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
                        continue;
                    }
                    ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).setEnergy(((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() - energyUsagePerInputPerTick);
                    int n = i;
                    blockEntity.energyConsumptionLeft[n] = blockEntity.energyConsumptionLeft[n] - energyUsagePerInputPerTick;
                    int n2 = i;
                    blockEntity.progress[n2] = blockEntity.progress[n2] + 1;
                    if (blockEntity.progress[i] >= blockEntity.maxProgress[i]) {
                        AdvancedPoweredFurnaceBlockEntity.craftItem(i, blockPos, state, blockEntity);
                    }
                    AdvancedPoweredFurnaceBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
                    continue;
                }
                blockEntity.hasEnoughEnergy[i] = false;
                ++hasNotEnoughEnergyCount;
                AdvancedPoweredFurnaceBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
                continue;
            }
            blockEntity.resetProgress(i, blockPos, state);
            ++hasNotEnoughEnergyCount;
            AdvancedPoweredFurnaceBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
        if ((hasNoRecipe || hasNotEnoughEnergyCount == 3) && level.m_8055_(blockPos).m_61138_((Property)BlockStateProperties.f_61443_) && ((Boolean)level.m_8055_(blockPos).m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            level.m_7731_(blockPos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    private void resetProgress(int index, BlockPos blockPos, BlockState state) {
        this.progress[index] = 0;
        this.maxProgress[index] = 0;
        this.energyConsumptionLeft[index] = -1;
        this.hasEnoughEnergy[index] = false;
    }

    private static void craftItem(int index, BlockPos blockPos, BlockState state, AdvancedPoweredFurnaceBlockEntity blockEntity) {
        Level level = blockEntity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(2);
        inventory.m_6836_(0, blockEntity.itemHandler.getStackInSlot(index));
        inventory.m_6836_(1, blockEntity.itemHandler.getStackInSlot(3 + index));
        Optional<? extends AbstractCookingRecipe> recipe = blockEntity.getRecipeFor((Container)inventory, level);
        if (!AdvancedPoweredFurnaceBlockEntity.hasRecipe(index, blockEntity) || recipe.isEmpty()) {
            return;
        }
        blockEntity.itemHandler.extractItem(index, 1, false);
        blockEntity.itemHandler.setStackInSlot(3 + index, recipe.get().m_8043_(level.m_9598_()).m_255036_(blockEntity.itemHandler.getStackInSlot(3 + index).m_41613_() + recipe.get().m_8043_(level.m_9598_()).m_41613_()));
        blockEntity.resetProgress(index, blockPos, state);
    }

    private static boolean hasRecipe(int index, AdvancedPoweredFurnaceBlockEntity blockEntity) {
        Level level = blockEntity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(2);
        inventory.m_6836_(0, blockEntity.itemHandler.getStackInSlot(index));
        inventory.m_6836_(1, blockEntity.itemHandler.getStackInSlot(3 + index));
        Optional<? extends AbstractCookingRecipe> recipe = blockEntity.getRecipeFor((Container)inventory, level);
        inventory = new SimpleContainer(blockEntity.itemHandler.getSlots());
        for (int i = 0; i < blockEntity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, blockEntity.itemHandler.getStackInSlot(i));
        }
        return recipe.isPresent() && InventoryUtils.canInsertItemIntoSlot((Container)inventory, 3 + index, recipe.get().m_8043_(level.m_9598_()));
    }

    private Optional<? extends AbstractCookingRecipe> getRecipeFor(Container container, Level level) {
        return level.m_7465_().m_44013_(this.getRecipeForFurnaceModeUpgrade()).stream().filter(recipe -> !RECIPE_BLACKLIST.contains(recipe.m_6423_())).filter(recipe -> recipe.m_5818_(container, level)).findFirst();
    }

    public RecipeType<? extends AbstractCookingRecipe> getRecipeForFurnaceModeUpgrade() {
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            return this.recipeType;
        }
        double value = this.upgradeModuleInventory.getUpgradeModuleModifierEffect(3, UpgradeModuleModifier.FURNACE_MODE);
        if (value == 1.0) {
            return RecipeType.f_44109_;
        }
        if (value == 2.0) {
            return RecipeType.f_44110_;
        }
        return RecipeType.f_44108_;
    }

    @Override
    public void setRecipeType(RecipeType<? extends AbstractCookingRecipe> recipeType) {
        this.recipeType = recipeType;
    }

    @Override
    protected void updateUpgradeModules() {
        for (int i = 0; i < 3; ++i) {
            this.resetProgress(i, this.m_58899_(), this.m_58900_());
        }
        super.updateUpgradeModules();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            ModMessages.sendToPlayersWithinXBlocks(new SyncFurnaceRecipeTypeS2CPacket(this.getRecipeForFurnaceModeUpgrade(), this.m_58899_()), this.m_58899_(), (ResourceKey<Level>)this.f_58857_.m_46472_(), 32);
        }
    }
}

