/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.LinkedList;
import java.util.List;
import me.jddev0.ep.block.AdvancedMinecartUnchargerBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.base.MenuEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ExtractOnlyEnergyStorage;
import me.jddev0.ep.entity.AbstractMinecartBatteryBox;
import me.jddev0.ep.screen.AdvancedMinecartUnchargerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancedMinecartUnchargerBlockEntity
extends MenuEnergyStorageBlockEntity<ExtractOnlyEnergyStorage> {
    public static final int MAX_TRANSFER = ModConfigs.COMMON_ADVANCED_MINECART_UNCHARGER_TRANSFER_RATE.getValue();
    private boolean hasMinecartOld = true;
    private boolean hasMinecart = false;

    public AdvancedMinecartUnchargerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.ADVANCED_MINECART_UNCHARGER_ENTITY.get(), blockPos, blockState, "advanced_minecart_uncharger", ModConfigs.COMMON_ADVANCED_MINECART_UNCHARGER_CAPACITY.getValue(), MAX_TRANSFER);
    }

    @Override
    protected ExtractOnlyEnergyStorage initEnergyStorage() {
        return new ExtractOnlyEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            @Override
            protected void onChange() {
                AdvancedMinecartUnchargerBlockEntity.this.m_6596_();
                AdvancedMinecartUnchargerBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        return new AdvancedMinecartUnchargerMenu(id, inventory, this);
    }

    public int getRedstoneOutput() {
        BlockPos blockPosFacing = this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_((Property)AdvancedMinecartUnchargerBlock.FACING));
        List minecarts = this.f_58857_.m_142425_(EntityTypeTest.m_156916_(AbstractMinecartBatteryBox.class), new AABB((double)blockPosFacing.m_123341_(), (double)blockPosFacing.m_123342_(), (double)blockPosFacing.m_123343_(), (double)(blockPosFacing.m_123341_() + 1), (double)(blockPosFacing.m_123342_() + 1), (double)(blockPosFacing.m_123343_() + 1)), EntitySelector.f_20402_);
        if (minecarts.isEmpty()) {
            return 0;
        }
        AbstractMinecartBatteryBox minecart = (AbstractMinecartBatteryBox)((Object)minecarts.get(0));
        int minecartEnergy = minecart.getEnergy();
        boolean isEmptyFlag = minecartEnergy == 0;
        return Math.min(Mth.m_14143_((float)((float)minecartEnergy / (float)minecart.getCapacity() * 14.0f)) + (isEmptyFlag ? 0 : 1), 15);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, AdvancedMinecartUnchargerBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (blockEntity.hasMinecartOld != blockEntity.hasMinecart) {
            AdvancedMinecartUnchargerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
        blockEntity.hasMinecartOld = blockEntity.hasMinecart;
        BlockPos blockPosFacing = blockEntity.m_58899_().m_121945_((Direction)blockEntity.m_58900_().m_61143_((Property)AdvancedMinecartUnchargerBlock.FACING));
        List minecarts = level.m_142425_(EntityTypeTest.m_156916_(AbstractMinecartBatteryBox.class), new AABB((double)blockPosFacing.m_123341_(), (double)blockPosFacing.m_123342_(), (double)blockPosFacing.m_123343_(), (double)(blockPosFacing.m_123341_() + 1), (double)(blockPosFacing.m_123342_() + 1), (double)(blockPosFacing.m_123343_() + 1)), EntitySelector.f_20402_);
        boolean bl = blockEntity.hasMinecart = !minecarts.isEmpty();
        if (!blockEntity.hasMinecart) {
            return;
        }
        AbstractMinecartBatteryBox minecart = (AbstractMinecartBatteryBox)((Object)minecarts.get(0));
        int transferred = Math.min(Math.min(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getCapacity() - ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy(), ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getMaxExtract()), Math.min(minecart.getTransferRate(), minecart.getEnergy()));
        minecart.setEnergy(minecart.getEnergy() - transferred);
        ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).setEnergy(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() + transferred);
        AdvancedMinecartUnchargerBlockEntity.transferEnergy(level, blockPos, state, blockEntity);
    }

    private static void transferEnergy(Level level, BlockPos blockPos, BlockState state, AdvancedMinecartUnchargerBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        LinkedList<IEnergyStorage> consumerItems = new LinkedList<IEnergyStorage>();
        LinkedList<Integer> consumerEnergyValues = new LinkedList<Integer>();
        int consumptionSum = 0;
        for (Direction direction : Direction.values()) {
            int received;
            IEnergyStorage energyStorage;
            LazyOptional energyStorageLazyOptional;
            BlockPos testPos = blockPos.m_121945_(direction);
            BlockEntity testBlockEntity = level.m_7702_(testPos);
            if (testBlockEntity == null || !(energyStorageLazyOptional = testBlockEntity.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_())).isPresent() || !(energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null)).canReceive() || (received = energyStorage.receiveEnergy(Math.min(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getMaxExtract(), ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy()), true)) <= 0) continue;
            consumptionSum += received;
            consumerItems.add(energyStorage);
            consumerEnergyValues.add(received);
        }
        LinkedList<Integer> consumerEnergyDistributed = new LinkedList<Integer>();
        for (int i = 0; i < consumerItems.size(); ++i) {
            consumerEnergyDistributed.add(0);
        }
        int consumptionLeft = Math.min(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getMaxExtract(), Math.min(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy(), consumptionSum));
        ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).extractEnergy(consumptionLeft, false);
        int divisor = consumerItems.size();
        block2: while (consumptionLeft > 0) {
            int consumptionPerConsumer = consumptionLeft / divisor;
            if (consumptionPerConsumer == 0) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = consumptionLeft / divisor;
            }
            for (int i = 0; i < consumerEnergyValues.size(); ++i) {
                int consumptionDistributed = (Integer)consumerEnergyDistributed.get(i);
                int consumptionOfConsumerLeft = (Integer)consumerEnergyValues.get(i) - consumptionDistributed;
                int consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, consumptionLeft));
                consumerEnergyDistributed.set(i, consumptionDistributed + consumptionDistributedNew);
                if ((consumptionLeft -= consumptionDistributedNew) == 0) break block2;
            }
        }
        for (int i = 0; i < consumerItems.size(); ++i) {
            int energy = (Integer)consumerEnergyDistributed.get(i);
            if (energy <= 0) continue;
            ((IEnergyStorage)consumerItems.get(i)).receiveEnergy(energy, false);
        }
    }
}

