/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Optional;
import me.jddev0.ep.block.AdvancedChargerBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.base.ConfigurableUpgradableInventoryEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.ChargerRecipe;
import me.jddev0.ep.screen.AdvancedChargerMenu;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.RecipeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancedChargerBlockEntity
extends ConfigurableUpgradableInventoryEnergyStorageBlockEntity<ReceiveOnlyEnergyStorage, ItemStackHandler> {
    public static final float CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER = ModConfigs.COMMON_ADVANCED_CHARGER_CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER.getValue().floatValue();
    private final LazyOptional<IItemHandler> lazyItemHandlerSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> true, i -> {
        if (i < 0 || i > 2) {
            return false;
        }
        ItemStack stack = this.itemHandler.getStackInSlot(i.intValue());
        if (this.f_58857_ != null && RecipeUtils.isResultOfAny(this.f_58857_, ChargerRecipe.Type.INSTANCE, stack)) {
            return true;
        }
        if (this.f_58857_ == null || RecipeUtils.isIngredientOfAny(this.f_58857_, ChargerRecipe.Type.INSTANCE, stack)) {
            return false;
        }
        LazyOptional energyStorageLazyOptional = stack.getCapability(ForgeCapabilities.ENERGY);
        if (!energyStorageLazyOptional.isPresent()) {
            return true;
        }
        IEnergyStorage energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null);
        if (!energyStorage.canReceive()) {
            return true;
        }
        return energyStorage.receiveEnergy(((ReceiveOnlyEnergyStorage)this.energyStorage).getMaxReceive() / 3, true) == 0;
    }));
    private int[] energyConsumptionLeft = new int[]{-1, -1, -1};

    public AdvancedChargerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.ADVANCED_CHARGER_ENTITY.get(), blockPos, blockState, "advanced_charger", ModConfigs.COMMON_ADVANCED_CHARGER_CAPACITY_PER_SLOT.getValue() * 3, ModConfigs.COMMON_ADVANCED_CHARGER_TRANSFER_RATE_PER_SLOT.getValue() * 3, 3, UpgradeModuleModifier.ENERGY_CAPACITY);
    }

    @Override
    protected ReceiveOnlyEnergyStorage initEnergyStorage() {
        return new ReceiveOnlyEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            @Override
            public int getCapacity() {
                return Math.max(1, (int)Math.ceil((double)this.capacity * AdvancedChargerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            @Override
            public int getMaxReceive() {
                return Math.max(1, (int)Math.ceil((double)this.maxReceive * AdvancedChargerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }

            @Override
            protected void onChange() {
                AdvancedChargerBlockEntity.this.m_6596_();
                AdvancedChargerBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                AdvancedChargerBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot >= 0 && slot < 3) {
                    if (AdvancedChargerBlockEntity.this.f_58857_ == null || RecipeUtils.isIngredientOfAny(AdvancedChargerBlockEntity.this.f_58857_, ChargerRecipe.Type.INSTANCE, stack)) {
                        return true;
                    }
                    LazyOptional energyStorageLazyOptional = stack.getCapability(ForgeCapabilities.ENERGY);
                    if (!energyStorageLazyOptional.isPresent()) {
                        return false;
                    }
                    IEnergyStorage energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null);
                    return energyStorage.canReceive();
                }
                return super.isItemValid(slot, stack);
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                if (slot >= 0 && slot < 3) {
                    ItemStack itemStack = this.getStackInSlot(slot);
                    if (!(AdvancedChargerBlockEntity.this.f_58857_ == null || stack.m_41619_() || itemStack.m_41619_() || ItemStack.m_41656_((ItemStack)stack, (ItemStack)itemStack) && (ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack) || stack.getCapability(ForgeCapabilities.ENERGY).isPresent() && itemStack.getCapability(ForgeCapabilities.ENERGY).isPresent()))) {
                        AdvancedChargerBlockEntity.this.resetProgress(slot);
                    }
                }
                super.setStackInSlot(slot, stack);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    @Override
    protected ContainerData initContainerData() {
        return new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(AdvancedChargerBlockEntity.this.energyConsumptionLeft[0], index);
                    case 2, 3 -> ByteUtils.get2Bytes(AdvancedChargerBlockEntity.this.energyConsumptionLeft[1], index - 2);
                    case 4, 5 -> ByteUtils.get2Bytes(AdvancedChargerBlockEntity.this.energyConsumptionLeft[2], index - 4);
                    case 6 -> AdvancedChargerBlockEntity.this.redstoneMode.ordinal();
                    case 7 -> AdvancedChargerBlockEntity.this.comparatorMode.ordinal();
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        break;
                    }
                    case 6: {
                        AdvancedChargerBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                        break;
                    }
                    case 7: {
                        AdvancedChargerBlockEntity.this.comparatorMode = ComparatorMode.fromIndex(value);
                    }
                }
            }

            public int m_6499_() {
                return 8;
            }
        };
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        return new AdvancedChargerMenu(id, inventory, this, this.upgradeModuleInventory, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            return this.lazyItemHandlerSided.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        for (int i = 0; i < 3; ++i) {
            nbt.m_128365_("recipe.energy_consumption_left." + i, (Tag)IntTag.m_128679_((int)this.energyConsumptionLeft[i]));
        }
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        for (int i = 0; i < 3; ++i) {
            this.energyConsumptionLeft[i] = nbt.m_128451_("recipe.energy_consumption_left." + i);
        }
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, AdvancedChargerBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.m_61143_((Property)AdvancedChargerBlock.POWERED))) {
            return;
        }
        int maxReceivePerSlot = (int)Math.min((double)((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getMaxReceive() / 3.0, Math.ceil((double)((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() / 3.0));
        for (int i = 0; i < 3; ++i) {
            if (blockEntity.hasRecipe(i)) {
                int energyConsumptionPerTick;
                ItemStack stack = blockEntity.itemHandler.getStackInSlot(i);
                SimpleContainer inventory = new SimpleContainer(1);
                inventory.m_6836_(0, blockEntity.itemHandler.getStackInSlot(i));
                Optional recipe = level.m_7465_().m_44015_((RecipeType)ChargerRecipe.Type.INSTANCE, (Container)inventory, level);
                if (recipe.isPresent()) {
                    if (blockEntity.energyConsumptionLeft[i] == -1) {
                        blockEntity.energyConsumptionLeft[i] = (int)((float)((ChargerRecipe)recipe.get()).getEnergyConsumption() * CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER);
                    }
                    if (((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() == 0) {
                        AdvancedChargerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
                        continue;
                    }
                    energyConsumptionPerTick = Math.min(blockEntity.energyConsumptionLeft[i], Math.min(maxReceivePerSlot, ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy()));
                } else {
                    IEnergyStorage energyStorage;
                    LazyOptional energyStorageLazyOptional = stack.getCapability(ForgeCapabilities.ENERGY);
                    if (!energyStorageLazyOptional.isPresent() || !(energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null)).canReceive()) continue;
                    blockEntity.energyConsumptionLeft[i] = energyStorage.getMaxEnergyStored() - energyStorage.getEnergyStored();
                    if (((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() == 0) {
                        AdvancedChargerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
                        continue;
                    }
                    energyConsumptionPerTick = energyStorage.receiveEnergy(Math.min(maxReceivePerSlot, ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy()), false);
                }
                if (blockEntity.energyConsumptionLeft[i] < 0 || energyConsumptionPerTick < 0) {
                    blockEntity.resetProgress(i);
                    AdvancedChargerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
                    continue;
                }
                ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).setEnergy(((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() - energyConsumptionPerTick);
                int n = i;
                blockEntity.energyConsumptionLeft[n] = blockEntity.energyConsumptionLeft[n] - energyConsumptionPerTick;
                if (blockEntity.energyConsumptionLeft[i] <= 0) {
                    int index = i;
                    recipe.ifPresent(chargerRecipe -> blockEntity.itemHandler.setStackInSlot(index, chargerRecipe.m_8043_(level.m_9598_()).m_255036_(1)));
                    blockEntity.resetProgress(i);
                }
                AdvancedChargerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
                continue;
            }
            blockEntity.resetProgress(i);
            AdvancedChargerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    private void resetProgress(int index) {
        this.energyConsumptionLeft[index] = -1;
    }

    private boolean hasRecipe(int index) {
        ItemStack stack = this.itemHandler.getStackInSlot(index);
        if (stack.getCapability(ForgeCapabilities.ENERGY).isPresent()) {
            return true;
        }
        SimpleContainer inventory = new SimpleContainer(1);
        inventory.m_6836_(0, this.itemHandler.getStackInSlot(index));
        Optional recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)ChargerRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
        return recipe.isPresent();
    }

    @Override
    protected void updateUpgradeModules() {
        for (int i = 0; i < 3; ++i) {
            this.resetProgress(i);
        }
        super.updateUpgradeModules();
    }
}

