/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block;

import java.util.List;
import me.jddev0.ep.block.ModBlocks;
import me.jddev0.ep.block.entity.SolarPanelBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.util.EnergyUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class SolarPanelBlock
extends BaseEntityBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    private final Tier tier;

    public static Block getBlockFromTier(Tier tier) {
        return switch (tier) {
            default -> throw new IncompatibleClassChangeError();
            case Tier.TIER_1 -> (SolarPanelBlock)((Object)ModBlocks.SOLAR_PANEL_1.get());
            case Tier.TIER_2 -> (SolarPanelBlock)((Object)ModBlocks.SOLAR_PANEL_2.get());
            case Tier.TIER_3 -> (SolarPanelBlock)((Object)ModBlocks.SOLAR_PANEL_3.get());
            case Tier.TIER_4 -> (SolarPanelBlock)((Object)ModBlocks.SOLAR_PANEL_4.get());
            case Tier.TIER_5 -> (SolarPanelBlock)((Object)ModBlocks.SOLAR_PANEL_5.get());
            case Tier.TIER_6 -> (SolarPanelBlock)((Object)ModBlocks.SOLAR_PANEL_6.get());
        };
    }

    public SolarPanelBlock(Tier tier) {
        super(tier.getProperties());
        this.tier = tier;
    }

    public Tier getTier() {
        return this.tier;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState state) {
        return new SolarPanelBlockEntity(blockPos, state, this.tier);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6810_(BlockState state, Level level, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() == newState.m_60734_()) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (!(blockEntity instanceof SolarPanelBlockEntity)) {
            return;
        }
        ((SolarPanelBlockEntity)blockEntity).drops(level, blockPos);
        super.m_6810_(state, level, blockPos, newState, isMoving);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand handItem, BlockHitResult hit) {
        if (level.m_5776_()) {
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (!(blockEntity instanceof SolarPanelBlockEntity) || ((SolarPanelBlockEntity)blockEntity).getTier() != this.tier) {
            throw new IllegalStateException("Container is invalid");
        }
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)((SolarPanelBlockEntity)blockEntity), (BlockPos)blockPos);
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return SolarPanelBlock.m_152132_(type, SolarPanelBlockEntity.getEntityTypeFromTier(this.tier), SolarPanelBlockEntity::tick);
    }

    public static enum Tier {
        TIER_1("solar_panel_1", ModConfigs.COMMON_SOLAR_PANEL_1_ENERGY_PEAK_PRODUCTION.getValue(), ModConfigs.COMMON_SOLAR_PANEL_1_TRANSFER_RATE.getValue(), ModConfigs.COMMON_SOLAR_PANEL_1_CAPACITY.getValue(), BlockBehaviour.Properties.m_284310_().m_60999_().m_60913_(4.0f, 5.0f).m_60918_(SoundType.f_56743_)),
        TIER_2("solar_panel_2", ModConfigs.COMMON_SOLAR_PANEL_2_ENERGY_PEAK_PRODUCTION.getValue(), ModConfigs.COMMON_SOLAR_PANEL_2_TRANSFER_RATE.getValue(), ModConfigs.COMMON_SOLAR_PANEL_2_CAPACITY.getValue(), BlockBehaviour.Properties.m_284310_().m_60999_().m_60913_(4.0f, 5.0f).m_60918_(SoundType.f_56743_)),
        TIER_3("solar_panel_3", ModConfigs.COMMON_SOLAR_PANEL_3_ENERGY_PEAK_PRODUCTION.getValue(), ModConfigs.COMMON_SOLAR_PANEL_3_TRANSFER_RATE.getValue(), ModConfigs.COMMON_SOLAR_PANEL_3_CAPACITY.getValue(), BlockBehaviour.Properties.m_284310_().m_60999_().m_60913_(4.0f, 5.0f).m_60918_(SoundType.f_56743_)),
        TIER_4("solar_panel_4", ModConfigs.COMMON_SOLAR_PANEL_4_ENERGY_PEAK_PRODUCTION.getValue(), ModConfigs.COMMON_SOLAR_PANEL_4_TRANSFER_RATE.getValue(), ModConfigs.COMMON_SOLAR_PANEL_4_CAPACITY.getValue(), BlockBehaviour.Properties.m_284310_().m_60999_().m_60913_(4.0f, 5.0f).m_60918_(SoundType.f_56743_)),
        TIER_5("solar_panel_5", ModConfigs.COMMON_SOLAR_PANEL_5_ENERGY_PEAK_PRODUCTION.getValue(), ModConfigs.COMMON_SOLAR_PANEL_5_TRANSFER_RATE.getValue(), ModConfigs.COMMON_SOLAR_PANEL_5_CAPACITY.getValue(), BlockBehaviour.Properties.m_284310_().m_60999_().m_60913_(4.0f, 5.0f).m_60918_(SoundType.f_56743_)),
        TIER_6("solar_panel_6", ModConfigs.COMMON_SOLAR_PANEL_6_ENERGY_PEAK_PRODUCTION.getValue(), ModConfigs.COMMON_SOLAR_PANEL_6_TRANSFER_RATE.getValue(), ModConfigs.COMMON_SOLAR_PANEL_6_CAPACITY.getValue(), BlockBehaviour.Properties.m_284310_().m_60999_().m_60913_(4.0f, 5.0f).m_60918_(SoundType.f_56743_));

        private final String resourceId;
        private final int peakFePerTick;
        private final int maxTransfer;
        private final int capacity;
        private final BlockBehaviour.Properties props;

        private Tier(String resourceId, int peakFePerTick, int maxTransfer, int capacity, BlockBehaviour.Properties props) {
            this.resourceId = resourceId;
            this.peakFePerTick = peakFePerTick;
            this.maxTransfer = maxTransfer;
            this.capacity = capacity;
            this.props = props;
        }

        public String getResourceId() {
            return this.resourceId;
        }

        public int getPeakFePerTick() {
            return this.peakFePerTick;
        }

        public int getMaxTransfer() {
            return this.maxTransfer;
        }

        public int getCapacity() {
            return this.capacity;
        }

        public BlockBehaviour.Properties getProperties() {
            return this.props;
        }
    }

    public static class Item
    extends BlockItem {
        private final Tier tier;

        public Item(Block block, Item.Properties props, Tier tier) {
            super(block, props);
            this.tier = tier;
        }

        public Tier getTier() {
            return this.tier;
        }

        public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
            if (Screen.m_96638_()) {
                components.add((Component)Component.m_237110_((String)"tooltip.energizedpower.solar_panel.txt.shift.1", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(this.tier.getPeakFePerTick())}).m_130940_(ChatFormatting.GRAY));
                components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.solar_panel.txt.shift.2").m_130940_(ChatFormatting.GRAY));
            } else {
                components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.shift_details.txt").m_130940_(ChatFormatting.YELLOW));
            }
        }
    }
}

