/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block;

import java.util.List;
import me.jddev0.ep.block.ModBlockStateProperties;
import me.jddev0.ep.block.WrenchConfigurable;
import me.jddev0.ep.block.entity.ItemConveyorBeltBlockEntity;
import me.jddev0.ep.block.entity.ModBlockEntities;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemConveyorBeltBlock
extends BaseEntityBlock
implements WrenchConfigurable {
    public static final EnumProperty<ModBlockStateProperties.ConveyorBeltDirection> FACING = ModBlockStateProperties.CONVEYOR_BELT_FACING;
    protected static final VoxelShape SHAPE_FLAT = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    protected static final VoxelShape SHAPE_HALF_BLOCK = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);

    protected ItemConveyorBeltBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(FACING, (Comparable)((Object)ModBlockStateProperties.ConveyorBeltDirection.NORTH_SOUTH)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState state) {
        return new ItemConveyorBeltBlockEntity(blockPos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos blockPos) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (!(blockEntity instanceof ItemConveyorBeltBlockEntity)) {
            return super.m_6782_(state, level, blockPos);
        }
        ItemConveyorBeltBlockEntity itemConveyorBeltBlockEntity = (ItemConveyorBeltBlockEntity)blockEntity;
        return itemConveyorBeltBlockEntity.getRedstoneOutput();
    }

    public void m_6810_(BlockState state, Level level, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() == newState.m_60734_()) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (!(blockEntity instanceof ItemConveyorBeltBlockEntity)) {
            return;
        }
        ((ItemConveyorBeltBlockEntity)blockEntity).drops(level, blockPos);
        super.m_6810_(state, level, blockPos, newState, isMoving);
    }

    @Override
    @NotNull
    public InteractionResult onUseWrench(UseOnContext useOnContext, Direction selectedFace, boolean nextPreviousValue) {
        Level level = useOnContext.m_43725_();
        BlockPos blockPos = useOnContext.m_8083_();
        if (level.f_46443_ || !(level.m_7702_(blockPos) instanceof ItemConveyorBeltBlockEntity)) {
            return InteractionResult.SUCCESS;
        }
        BlockState state = level.m_8055_(blockPos);
        Player player = useOnContext.m_43723_();
        ModBlockStateProperties.ConveyorBeltDirection facing = (ModBlockStateProperties.ConveyorBeltDirection)((Object)state.m_61143_(FACING));
        Object shape = nextPreviousValue ? (facing.isAscending() ? null : (facing.isDescending() ? Boolean.valueOf(true) : Boolean.valueOf(false))) : (facing.isAscending() ? Boolean.valueOf(false) : (facing.isDescending() ? null : Boolean.valueOf(true)));
        level.m_7731_(blockPos, (BlockState)state.m_61124_(FACING, (Comparable)((Object)ModBlockStateProperties.ConveyorBeltDirection.of(facing.getDirection(), (Boolean)shape))), 3);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"tooltip.energizedpower.item_conveyor_belt.wrench_configuration.changed", (Object[])new Object[]{Component.m_237115_((String)("tooltip.energizedpower.conveyor_belt_direction.slope." + (shape == null ? "flat" : (((Boolean)shape).booleanValue() ? "ascending" : "descending")))).m_130944_(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD})}).m_130940_(ChatFormatting.GREEN)));
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_(FACING, (Comparable)((Object)ModBlockStateProperties.ConveyorBeltDirection.of(context.m_8125_(), null)));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        ModBlockStateProperties.ConveyorBeltDirection facing = (ModBlockStateProperties.ConveyorBeltDirection)((Object)state.m_61143_(FACING));
        Boolean slope = facing.getSlope();
        return (BlockState)state.m_61124_(FACING, (Comparable)((Object)ModBlockStateProperties.ConveyorBeltDirection.of(rotation.m_55954_(facing.getDirection()), slope)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_(((ModBlockStateProperties.ConveyorBeltDirection)((Object)state.m_61143_(FACING))).getDirection()));
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        ModBlockStateProperties.ConveyorBeltDirection facing = (ModBlockStateProperties.ConveyorBeltDirection)((Object)blockState.m_61143_(FACING));
        if (facing.isAscending() || facing.isDescending()) {
            return SHAPE_HALF_BLOCK;
        }
        return SHAPE_FLAT;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return ItemConveyorBeltBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.ITEM_CONVEYOR_BELT_ENTITY.get()), ItemConveyorBeltBlockEntity::tick);
    }

    public static class Item
    extends BlockItem {
        public Item(Block block, Item.Properties props) {
            super(block, props);
        }

        public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
            if (Screen.m_96638_()) {
                components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.wrench_configurable").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            } else {
                components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.shift_details.txt").m_130940_(ChatFormatting.YELLOW));
            }
        }
    }
}

