/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block;

import java.util.List;
import me.jddev0.ep.block.ModBlockStateProperties;
import me.jddev0.ep.block.ModBlocks;
import me.jddev0.ep.block.WrenchConfigurable;
import me.jddev0.ep.block.entity.FluidPipeBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.util.FluidUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidPipeBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
WrenchConfigurable {
    public static final EnumProperty<ModBlockStateProperties.PipeConnection> UP = ModBlockStateProperties.PIPE_CONNECTION_UP;
    public static final EnumProperty<ModBlockStateProperties.PipeConnection> DOWN = ModBlockStateProperties.PIPE_CONNECTION_DOWN;
    public static final EnumProperty<ModBlockStateProperties.PipeConnection> NORTH = ModBlockStateProperties.PIPE_CONNECTION_NORTH;
    public static final EnumProperty<ModBlockStateProperties.PipeConnection> SOUTH = ModBlockStateProperties.PIPE_CONNECTION_SOUTH;
    public static final EnumProperty<ModBlockStateProperties.PipeConnection> EAST = ModBlockStateProperties.PIPE_CONNECTION_EAST;
    public static final EnumProperty<ModBlockStateProperties.PipeConnection> WEST = ModBlockStateProperties.PIPE_CONNECTION_WEST;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE_CORE = Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    private static final VoxelShape SHAPE_UP = Block.m_49796_((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape SHAPE_DOWN = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0);
    private static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)4.0);
    private static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0, (double)16.0);
    private static final VoxelShape SHAPE_EAST = Block.m_49796_((double)12.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    private static final VoxelShape SHAPE_WEST = Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0);
    private final Tier tier;

    @NotNull
    public static EnumProperty<ModBlockStateProperties.PipeConnection> getPipeConnectionPropertyFromDirection(@NotNull Direction dir) {
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> UP;
            case Direction.DOWN -> DOWN;
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.EAST -> EAST;
            case Direction.WEST -> WEST;
        };
    }

    public static Block getBlockFromTier(Tier tier) {
        return switch (tier) {
            default -> throw new IncompatibleClassChangeError();
            case Tier.IRON -> (FluidPipeBlock)ModBlocks.IRON_FLUID_PIPE.get();
            case Tier.GOLDEN -> (FluidPipeBlock)ModBlocks.GOLDEN_FLUID_PIPE.get();
        };
    }

    public FluidPipeBlock(Tier tier) {
        super(tier.getProperties());
        this.tier = tier;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(UP, (Comparable)((Object)ModBlockStateProperties.PipeConnection.NOT_CONNECTED))).m_61124_(DOWN, (Comparable)((Object)ModBlockStateProperties.PipeConnection.NOT_CONNECTED))).m_61124_(NORTH, (Comparable)((Object)ModBlockStateProperties.PipeConnection.NOT_CONNECTED))).m_61124_(SOUTH, (Comparable)((Object)ModBlockStateProperties.PipeConnection.NOT_CONNECTED))).m_61124_(EAST, (Comparable)((Object)ModBlockStateProperties.PipeConnection.NOT_CONNECTED))).m_61124_(WEST, (Comparable)((Object)ModBlockStateProperties.PipeConnection.NOT_CONNECTED))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public Tier getTier() {
        return this.tier;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState state) {
        return new FluidPipeBlockEntity(blockPos, state, this.tier);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    @NotNull
    public InteractionResult onUseWrench(UseOnContext useOnContext, Direction selectedFace, boolean nextPreviousValue) {
        Level level = useOnContext.m_43725_();
        BlockPos blockPos = useOnContext.m_8083_();
        if (level.f_46443_ || !(level.m_7702_(blockPos) instanceof FluidPipeBlockEntity)) {
            return InteractionResult.SUCCESS;
        }
        BlockState state = level.m_8055_(blockPos);
        BlockPos testPos = blockPos.m_121945_(selectedFace);
        Player player = useOnContext.m_43723_();
        BlockEntity testBlockEntity = level.m_7702_(testPos);
        if (testBlockEntity == null || testBlockEntity instanceof FluidPipeBlockEntity) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"tooltip.energizedpower.fluid_pipe.wrench_configuration.face_change_not_possible", (Object[])new Object[]{Component.m_237115_((String)("tooltip.energizedpower.direction." + selectedFace.m_7912_())).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.RED)));
            }
            return InteractionResult.SUCCESS;
        }
        LazyOptional fluidStorageLazyOptional = testBlockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, selectedFace.m_122424_());
        if (!fluidStorageLazyOptional.isPresent()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"tooltip.energizedpower.fluid_pipe.wrench_configuration.face_change_not_possible", (Object[])new Object[]{Component.m_237115_((String)("tooltip.energizedpower.direction." + selectedFace.m_7912_())).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.RED)));
            }
            return InteractionResult.SUCCESS;
        }
        IFluidHandler fluidStorage = (IFluidHandler)fluidStorageLazyOptional.orElse(null);
        if (fluidStorage.getTanks() == 0) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"tooltip.energizedpower.fluid_pipe.wrench_configuration.face_change_not_possible", (Object[])new Object[]{Component.m_237115_((String)("tooltip.energizedpower.direction." + selectedFace.m_7912_())).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.RED)));
            }
            return InteractionResult.SUCCESS;
        }
        EnumProperty<ModBlockStateProperties.PipeConnection> pipeConnectionProperty = FluidPipeBlock.getPipeConnectionPropertyFromDirection(selectedFace);
        int diff = nextPreviousValue ? -1 : 1;
        ModBlockStateProperties.PipeConnection pipeConnection = (ModBlockStateProperties.PipeConnection)((Object)state.m_61143_(pipeConnectionProperty));
        pipeConnection = ModBlockStateProperties.PipeConnection.values()[(pipeConnection.ordinal() + diff + ModBlockStateProperties.PipeConnection.values().length) % ModBlockStateProperties.PipeConnection.values().length];
        level.m_7731_(blockPos, (BlockState)state.m_61124_(pipeConnectionProperty, (Comparable)((Object)pipeConnection)), 3);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"tooltip.energizedpower.fluid_pipe.wrench_configuration.face_changed", (Object[])new Object[]{Component.m_237115_((String)("tooltip.energizedpower.direction." + selectedFace.m_7912_())).m_130940_(ChatFormatting.WHITE), Component.m_237115_((String)pipeConnection.getTranslationKey()).m_130944_(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD})}).m_130940_(ChatFormatting.GREEN)));
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        Level level = blockPlaceContext.m_43725_();
        BlockPos selfPos = blockPlaceContext.m_8083_();
        FluidState fluidState = level.m_6425_(selfPos);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(UP, (Comparable)((Object)this.shouldConnectTo(level, selfPos, this.m_49966_(), Direction.UP)))).m_61124_(DOWN, (Comparable)((Object)this.shouldConnectTo(level, selfPos, this.m_49966_(), Direction.DOWN)))).m_61124_(NORTH, (Comparable)((Object)this.shouldConnectTo(level, selfPos, this.m_49966_(), Direction.NORTH)))).m_61124_(SOUTH, (Comparable)((Object)this.shouldConnectTo(level, selfPos, this.m_49966_(), Direction.SOUTH)))).m_61124_(EAST, (Comparable)((Object)this.shouldConnectTo(level, selfPos, this.m_49966_(), Direction.EAST)))).m_61124_(WEST, (Comparable)((Object)this.shouldConnectTo(level, selfPos, this.m_49966_(), Direction.WEST)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((Object)((ModBlockStateProperties.PipeConnection)((Object)state.m_61143_(WEST)))))).m_61124_(SOUTH, (Comparable)((Object)((ModBlockStateProperties.PipeConnection)((Object)state.m_61143_(EAST)))))).m_61124_(EAST, (Comparable)((Object)((ModBlockStateProperties.PipeConnection)((Object)state.m_61143_(NORTH)))))).m_61124_(WEST, (Comparable)((Object)((ModBlockStateProperties.PipeConnection)((Object)state.m_61143_(SOUTH)))));
            }
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((Object)((ModBlockStateProperties.PipeConnection)((Object)state.m_61143_(SOUTH)))))).m_61124_(SOUTH, (Comparable)((Object)((ModBlockStateProperties.PipeConnection)((Object)state.m_61143_(NORTH)))))).m_61124_(EAST, (Comparable)((Object)((ModBlockStateProperties.PipeConnection)((Object)state.m_61143_(WEST)))))).m_61124_(WEST, (Comparable)((Object)((ModBlockStateProperties.PipeConnection)((Object)state.m_61143_(EAST)))));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((Object)((ModBlockStateProperties.PipeConnection)((Object)state.m_61143_(EAST)))))).m_61124_(SOUTH, (Comparable)((Object)((ModBlockStateProperties.PipeConnection)((Object)state.m_61143_(WEST)))))).m_61124_(EAST, (Comparable)((Object)((ModBlockStateProperties.PipeConnection)((Object)state.m_61143_(SOUTH)))))).m_61124_(WEST, (Comparable)((Object)((ModBlockStateProperties.PipeConnection)((Object)state.m_61143_(NORTH)))));
            }
        }
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((Object)((ModBlockStateProperties.PipeConnection)((Object)state.m_61143_(SOUTH)))))).m_61124_(SOUTH, (Comparable)((Object)((ModBlockStateProperties.PipeConnection)((Object)state.m_61143_(NORTH)))));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.m_61124_(EAST, (Comparable)((Object)((ModBlockStateProperties.PipeConnection)((Object)state.m_61143_(WEST)))))).m_61124_(WEST, (Comparable)((Object)((ModBlockStateProperties.PipeConnection)((Object)state.m_61143_(EAST)))));
            }
        }
        return state;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        VoxelShape shape = SHAPE_CORE;
        if (((ModBlockStateProperties.PipeConnection)((Object)blockState.m_61143_(UP))).isConnected()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_UP);
        }
        if (((ModBlockStateProperties.PipeConnection)((Object)blockState.m_61143_(DOWN))).isConnected()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_DOWN);
        }
        if (((ModBlockStateProperties.PipeConnection)((Object)blockState.m_61143_(NORTH))).isConnected()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_NORTH);
        }
        if (((ModBlockStateProperties.PipeConnection)((Object)blockState.m_61143_(SOUTH))).isConnected()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_SOUTH);
        }
        if (((ModBlockStateProperties.PipeConnection)((Object)blockState.m_61143_(EAST))).isConnected()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_EAST);
        }
        if (((ModBlockStateProperties.PipeConnection)((Object)blockState.m_61143_(WEST))).isConnected()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_WEST);
        }
        return shape;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos selfPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(selfPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, selfPos, facingPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{UP}).m_61104_(new Property[]{DOWN}).m_61104_(new Property[]{NORTH}).m_61104_(new Property[]{SOUTH}).m_61104_(new Property[]{EAST}).m_61104_(new Property[]{WEST}).m_61104_(new Property[]{WATERLOGGED});
    }

    public void m_6861_(BlockState selfState, Level level, BlockPos selfPos, Block fromBlock, BlockPos fromPos, boolean isMoving) {
        BlockState newState;
        int dz;
        int dy;
        super.m_6861_(selfState, level, selfPos, fromBlock, fromPos, isMoving);
        if (level.m_5776_()) {
            return;
        }
        FluidState fluidState = level.m_6425_(selfPos);
        int dx = fromPos.m_123341_() - selfPos.m_123341_();
        Direction dir = Direction.m_122378_((int)dx, (int)(dy = fromPos.m_123342_() - selfPos.m_123342_()), (int)(dz = fromPos.m_123343_() - selfPos.m_123343_()));
        if (dir == null) {
            newState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(UP, (Comparable)((Object)((ModBlockStateProperties.PipeConnection)((Object)selfState.m_61143_(UP)))))).m_61124_(DOWN, (Comparable)((Object)((ModBlockStateProperties.PipeConnection)((Object)selfState.m_61143_(DOWN)))))).m_61124_(NORTH, (Comparable)((Object)((ModBlockStateProperties.PipeConnection)((Object)selfState.m_61143_(NORTH)))))).m_61124_(SOUTH, (Comparable)((Object)((ModBlockStateProperties.PipeConnection)((Object)selfState.m_61143_(SOUTH)))))).m_61124_(EAST, (Comparable)((Object)((ModBlockStateProperties.PipeConnection)((Object)selfState.m_61143_(EAST)))))).m_61124_(WEST, (Comparable)((Object)((ModBlockStateProperties.PipeConnection)((Object)selfState.m_61143_(WEST)))))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        } else {
            EnumProperty<ModBlockStateProperties.PipeConnection> pipeConnectionProperty = FluidPipeBlock.getPipeConnectionPropertyFromDirection(dir);
            newState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(UP, (Comparable)((Object)((ModBlockStateProperties.PipeConnection)((Object)selfState.m_61143_(UP)))))).m_61124_(DOWN, (Comparable)((Object)((ModBlockStateProperties.PipeConnection)((Object)selfState.m_61143_(DOWN)))))).m_61124_(NORTH, (Comparable)((Object)((ModBlockStateProperties.PipeConnection)((Object)selfState.m_61143_(NORTH)))))).m_61124_(SOUTH, (Comparable)((Object)((ModBlockStateProperties.PipeConnection)((Object)selfState.m_61143_(SOUTH)))))).m_61124_(EAST, (Comparable)((Object)((ModBlockStateProperties.PipeConnection)((Object)selfState.m_61143_(EAST)))))).m_61124_(WEST, (Comparable)((Object)((ModBlockStateProperties.PipeConnection)((Object)selfState.m_61143_(WEST)))))).m_61124_(pipeConnectionProperty, (Comparable)((Object)this.shouldConnectTo(level, selfPos, selfState, dir)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        }
        level.m_46597_(selfPos, newState);
        BlockEntity blockEntity = level.m_7702_(selfPos);
        if (blockEntity == null || !(blockEntity instanceof FluidPipeBlockEntity)) {
            return;
        }
        FluidPipeBlockEntity.updateConnections(level, selfPos, newState, (FluidPipeBlockEntity)blockEntity);
    }

    private ModBlockStateProperties.PipeConnection shouldConnectTo(Level level, BlockPos selfPos, BlockState selfState, Direction direction) {
        LazyOptional fluidStorageLazyOptional;
        FluidPipeBlockEntity fluidPipeBlockEntity;
        BlockPos toPos = selfPos.m_121945_(direction);
        BlockEntity blockEntity = level.m_7702_(toPos);
        if (blockEntity == null) {
            return ModBlockStateProperties.PipeConnection.NOT_CONNECTED;
        }
        if (blockEntity instanceof FluidPipeBlockEntity && (fluidPipeBlockEntity = (FluidPipeBlockEntity)blockEntity).getTier() != this.getTier()) {
            return ModBlockStateProperties.PipeConnection.NOT_CONNECTED;
        }
        ModBlockStateProperties.PipeConnection currentConnectionState = (ModBlockStateProperties.PipeConnection)((Object)selfState.m_61143_(FluidPipeBlock.getPipeConnectionPropertyFromDirection(direction)));
        if (currentConnectionState == ModBlockStateProperties.PipeConnection.NOT_CONNECTED) {
            currentConnectionState = ModBlockStateProperties.PipeConnection.CONNECTED;
        }
        return (fluidStorageLazyOptional = blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, direction.m_122424_())).isPresent() ? currentConnectionState : ModBlockStateProperties.PipeConnection.NOT_CONNECTED;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return FluidPipeBlock.m_152132_(type, FluidPipeBlockEntity.getEntityTypeFromTier(this.tier), FluidPipeBlockEntity::tick);
    }

    public static enum Tier {
        IRON("fluid_pipe", ModConfigs.COMMON_IRON_FLUID_PIPE_FLUID_TRANSFER_RATE.getValue(), BlockBehaviour.Properties.m_284310_().m_60999_().m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_)),
        GOLDEN("golden_fluid_pipe", ModConfigs.COMMON_GOLDEN_FLUID_PIPE_FLUID_TRANSFER_RATE.getValue(), BlockBehaviour.Properties.m_284310_().m_60999_().m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_));

        private final String resourceId;
        private final int transferRate;
        private final BlockBehaviour.Properties props;

        private Tier(String resourceId, int transferRate, BlockBehaviour.Properties props) {
            this.resourceId = resourceId;
            this.transferRate = transferRate;
            this.props = props;
        }

        public String getResourceId() {
            return this.resourceId;
        }

        public int getTransferRate() {
            return this.transferRate;
        }

        public BlockBehaviour.Properties getProperties() {
            return this.props;
        }
    }

    public static class Item
    extends BlockItem {
        private final Tier tier;

        public Item(Block block, Item.Properties props, Tier tier) {
            super(block, props);
            this.tier = tier;
        }

        public Tier getTier() {
            return this.tier;
        }

        public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
            if (Screen.m_96638_()) {
                components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.wrench_configurable").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                components.add((Component)Component.m_237110_((String)"tooltip.energizedpower.fluid_pipe.max_extraction", (Object[])new Object[]{FluidUtils.getFluidAmountWithPrefix(this.tier.getTransferRate())}).m_130940_(ChatFormatting.GRAY));
            } else {
                components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.shift_details.txt").m_130940_(ChatFormatting.YELLOW));
            }
        }
    }
}

