/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block;

import java.util.List;
import me.jddev0.ep.block.entity.CableBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.util.EnergyUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class CableBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE_CORE = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape SHAPE_UP = Block.m_49796_((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_DOWN = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
    private static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0);
    private static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0);
    private static final VoxelShape SHAPE_EAST = Block.m_49796_((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private static final VoxelShape SHAPE_WEST = Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0);
    private final Tier tier;

    public CableBlock(Tier tier) {
        super(tier.getProperties());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.tier = tier;
    }

    public Tier getTier() {
        return this.tier;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        Level level = blockPlaceContext.m_43725_();
        BlockPos selfPos = blockPlaceContext.m_8083_();
        FluidState fluidState = level.m_6425_(selfPos);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)UP, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, Direction.UP)))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, Direction.DOWN)))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, Direction.NORTH)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, Direction.SOUTH)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, Direction.EAST)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, Direction.WEST)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)));
            }
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            }
        }
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            }
        }
        return state;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        VoxelShape shape = SHAPE_CORE;
        if (((Boolean)blockState.m_61143_((Property)UP)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_UP);
        }
        if (((Boolean)blockState.m_61143_((Property)DOWN)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_DOWN);
        }
        if (((Boolean)blockState.m_61143_((Property)NORTH)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_NORTH);
        }
        if (((Boolean)blockState.m_61143_((Property)SOUTH)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_SOUTH);
        }
        if (((Boolean)blockState.m_61143_((Property)EAST)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_EAST);
        }
        if (((Boolean)blockState.m_61143_((Property)WEST)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_WEST);
        }
        return shape;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos selfPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(selfPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, selfPos, facingPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{UP}).m_61104_(new Property[]{DOWN}).m_61104_(new Property[]{NORTH}).m_61104_(new Property[]{SOUTH}).m_61104_(new Property[]{EAST}).m_61104_(new Property[]{WEST}).m_61104_(new Property[]{WATERLOGGED});
    }

    public void m_6861_(BlockState selfState, Level level, BlockPos selfPos, Block fromBlock, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(selfState, level, selfPos, fromBlock, fromPos, isMoving);
        if (level.m_5776_()) {
            return;
        }
        FluidState fluidState = level.m_6425_(selfPos);
        BlockState newState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)UP, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, Direction.UP)))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, Direction.DOWN)))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, Direction.NORTH)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, Direction.SOUTH)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, Direction.EAST)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, Direction.WEST)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        level.m_46597_(selfPos, newState);
        BlockEntity blockEntity = level.m_7702_(selfPos);
        if (blockEntity == null || !(blockEntity instanceof CableBlockEntity)) {
            return;
        }
        CableBlockEntity.updateConnections(level, selfPos, newState, (CableBlockEntity)blockEntity);
    }

    private boolean shouldConnectTo(Level level, BlockPos selfPos, Direction direction) {
        CableBlockEntity cableBlockEntity;
        BlockPos toPos = selfPos.m_121945_(direction);
        BlockEntity blockEntity = level.m_7702_(toPos);
        if (blockEntity == null) {
            return false;
        }
        if (blockEntity instanceof CableBlockEntity && (cableBlockEntity = (CableBlockEntity)blockEntity).getTier() != this.getTier()) {
            return false;
        }
        LazyOptional energyStorageLazyOptional = blockEntity.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_());
        return energyStorageLazyOptional.isPresent();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState state) {
        return new CableBlockEntity(blockPos, state, this.tier);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return CableBlock.m_152132_(type, CableBlockEntity.getEntityTypeFromTier(this.tier), CableBlockEntity::tick);
    }

    public static enum Tier {
        TIER_TIN("tin_cable", ModConfigs.COMMON_TIN_CABLE_TRANSFER_RATE.getValue(), BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283818_).m_60978_(0.5f).m_60918_(SoundType.f_56745_)),
        TIER_COPPER("copper_cable", ModConfigs.COMMON_COPPER_CABLE_TRANSFER_RATE.getValue(), BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283818_).m_60978_(0.5f).m_60918_(SoundType.f_56745_)),
        TIER_GOLD("gold_cable", ModConfigs.COMMON_GOLD_CABLE_TRANSFER_RATE.getValue(), BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283818_).m_60978_(0.5f).m_60918_(SoundType.f_56745_)),
        TIER_ENERGIZED_COPPER("energized_copper_cable", ModConfigs.COMMON_ENERGIZED_COPPER_CABLE_TRANSFER_RATE.getValue(), BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283818_).m_60978_(0.5f).m_60918_(SoundType.f_56745_)),
        TIER_ENERGIZED_GOLD("energized_gold_cable", ModConfigs.COMMON_ENERGIZED_GOLD_CABLE_TRANSFER_RATE.getValue(), BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283818_).m_60978_(0.5f).m_60918_(SoundType.f_56745_)),
        TIER_ENERGIZED_CRYSTAL_MATRIX("energized_crystal_matrix_cable", ModConfigs.COMMON_ENERGIZED_CRYSTAL_MATRIX_CABLE_TRANSFER_RATE.getValue(), BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283818_).m_60978_(0.5f).m_60918_(SoundType.f_56745_));

        private final String resourceId;
        private final int maxTransfer;
        private final BlockBehaviour.Properties props;

        private Tier(String resourceId, int maxTransfer, BlockBehaviour.Properties props) {
            this.resourceId = resourceId;
            this.maxTransfer = maxTransfer;
            this.props = props;
        }

        public String getResourceId() {
            return this.resourceId;
        }

        public int getMaxTransfer() {
            return this.maxTransfer;
        }

        public BlockBehaviour.Properties getProperties() {
            return this.props;
        }
    }

    public static enum EnergyExtractionMode {
        PUSH,
        PULL,
        BOTH;


        public boolean isPush() {
            return this == PUSH || this == BOTH;
        }

        public boolean isPull() {
            return this == PULL || this == BOTH;
        }
    }

    public static class Item
    extends BlockItem {
        private final Tier tier;

        public Item(Block block, Item.Properties props, Tier tier) {
            super(block, props);
            this.tier = tier;
        }

        public Tier getTier() {
            return this.tier;
        }

        public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
            if (Screen.m_96638_()) {
                components.add((Component)Component.m_237110_((String)"tooltip.energizedpower.cable.txt.shift.1", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(this.tier.getMaxTransfer())}).m_130940_(ChatFormatting.GRAY));
                components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.cable.txt.shift.2").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            } else {
                components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.shift_details.txt").m_130940_(ChatFormatting.YELLOW));
            }
        }
    }
}

