/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.client.gui.GuiHelper;
import shetiphian.enderchests.client.gui.Textures;
import shetiphian.enderchests.common.inventory.ContainerEnderChest;
import shetiphian.enderchests.common.inventory.Slots;
import shetiphian.enderchests.common.item.ItemEnderBag;

@OnlyIn(value=Dist.CLIENT)
public class GuiEnderChest
extends AbstractContainerScreen<ContainerEnderChest> {
    private int slotCount;
    private int columns;
    private int rows;
    private int colOffset;

    public GuiEnderChest(ContainerEnderChest container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title);
        this.f_97726_ = 182;
        this.setLayout();
        ((ContainerEnderChest)this.f_97732_).setInventoryChangeCallback(this::setLayout);
    }

    private void setLayout() {
        this.slotCount = ((ContainerEnderChest)this.f_97732_).getChestSize();
        int n = this.columns = this.slotCount >= 27 ? 9 : this.slotCount / 3;
        this.rows = this.slotCount <= 27 ? 3 : (this.slotCount % 9 == 0 ? this.slotCount / 9 : this.slotCount / 9 + 1);
        this.colOffset = (9 - this.columns) * 9;
        int rowOffset = (this.rows - 3) * 18;
        this.f_97727_ = 172 + rowOffset;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        for (Slot invSlot : ((ContainerEnderChest)this.f_97732_).f_38839_) {
            if (invSlot instanceof Slots.Hideable) {
                Slots.Hideable slot = (Slots.Hideable)invSlot;
                int group = slot.getSlotIndex();
                if (slot.getSlotIndex() >= this.slotCount) {
                    slot.setVisible(false);
                    continue;
                }
                slot.setVisible(true);
                int toX = 11 + this.colOffset + group % this.columns * 18;
                int toY = 11 + group / this.columns * 18;
                Slots.moveSlot(slot, toX, toY);
                continue;
            }
            int slotId = invSlot.getSlotIndex();
            int row = slotId / 9 - 1;
            int col = slotId % 9 * 18;
            Slots.moveSlot(invSlot, 11 + col, 87 + rowOffset + (row == -1 ? 58 : row * 18));
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280653_(this.f_96547_, ((ContainerEnderChest)this.f_97732_).getOwner(), this.f_97726_ / 2, -8, -32961);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        ResourceLocation guiTexture = Textures.ENDERCHEST.get();
        if (this.slotCount != ((ContainerEnderChest)this.f_97732_).getChestSize()) {
            this.setLayout();
        }
        int ypos = 0;
        if (this.slotCount >= 27) {
            int rem;
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.f_97735_, (double)(this.f_97736_ + ypos), (int)0, (int)102, (int)182, (int)46, (ResourceLocation)guiTexture);
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.f_97735_, (double)(this.f_97736_ + (ypos += 46)), (int)0, (int)112, (int)182, (int)(this.rows == 3 ? 18 : 36), (ResourceLocation)guiTexture);
            ypos += this.rows == 3 ? 18 : 36;
            if (this.rows > 4) {
                GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.f_97735_, (double)(this.f_97736_ + ypos), (int)0, (int)112, (int)182, (int)(this.rows == 5 ? 18 : 36), (ResourceLocation)guiTexture);
                ypos += this.rows == 5 ? 18 : 36;
            }
            if ((rem = this.slotCount % 9) != 0) {
                int left = rem == 3 ? 64 : 118;
                GuiHelper.drawTexture((GuiGraphics)graphics, (double)(this.f_97735_ + left), (double)(this.f_97736_ + ypos - 18), (int)left, (int)(this.rows % 2 == 0 ? 82 : 64), (int)(182 - left - 10), (int)18, (ResourceLocation)guiTexture);
            }
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.f_97735_, (double)(this.f_97736_ + ypos), (int)0, (int)148, (int)182, (int)10, (ResourceLocation)guiTexture);
        } else {
            int left = this.colOffset;
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)(this.f_97735_ + left), (double)this.f_97736_, (int)0, (int)102, (int)10, (int)46, (ResourceLocation)guiTexture);
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)(this.f_97735_ + left), (double)(this.f_97736_ + 46), (int)0, (int)112, (int)10, (int)18, (ResourceLocation)guiTexture);
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)(this.f_97735_ + left), (double)(this.f_97736_ + 64), (int)0, (int)148, (int)10, (int)10, (ResourceLocation)guiTexture);
            int half = (this.columns / 2 - 1) * 18;
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)(this.f_97735_ + (left += 10)), (double)this.f_97736_, (int)(64 - half), (int)102, (int)(this.columns * 18), (int)46, (ResourceLocation)guiTexture);
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)(this.f_97735_ + left), (double)(this.f_97736_ + 46), (int)(64 - half), (int)112, (int)(this.columns * 18), (int)18, (ResourceLocation)guiTexture);
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)(this.f_97735_ + left), (double)(this.f_97736_ + 64), (int)(64 - half), (int)148, (int)(this.columns * 18), (int)10, (ResourceLocation)guiTexture);
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)(this.f_97735_ + (left += this.columns * 18)), (double)this.f_97736_, (int)172, (int)102, (int)10, (int)46, (ResourceLocation)guiTexture);
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)(this.f_97735_ + left), (double)(this.f_97736_ + 46), (int)172, (int)112, (int)10, (int)18, (ResourceLocation)guiTexture);
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)(this.f_97735_ + left), (double)(this.f_97736_ + 64), (int)172, (int)148, (int)10, (int)10, (ResourceLocation)guiTexture);
            ypos += 64;
        }
        GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.f_97735_, (double)(this.f_97736_ + (ypos += 10)), (int)0, (int)158, (int)182, (int)98, (ResourceLocation)guiTexture);
    }

    protected void m_6597_(Slot slot, int slotId, int clickedButton, ClickType clickType) {
        ItemStack stack;
        if (slot != null && slot.m_6657_() && !(stack = slot.m_7993_()).m_41619_() && stack.m_41720_() instanceof ItemEnderBag && ItemEnderBag.isOpen(stack)) {
            return;
        }
        super.m_6597_(slot, slotId, clickedButton, clickType);
    }
}

