/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.data.recipes;

import com.enderio.EnderIO;
import com.enderio.base.common.init.EIOFluids;
import com.enderio.base.common.init.EIOItems;
import com.enderio.base.data.recipe.RecipeDataUtil;
import com.enderio.core.data.recipes.EnderRecipeProvider;
import com.enderio.machines.common.init.MachineRecipes;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class TankRecipeProvider
extends EnderRecipeProvider {
    public TankRecipeProvider(PackOutput packOutput) {
        super(packOutput);
    }

    protected void m_245200_(Consumer<FinishedRecipe> pWriter) {
        this.buildEmptying(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42612_}), (ItemLike)Items.f_42590_, new FluidStack((Fluid)EIOFluids.XP_JUICE.getSource(), 250), pWriter);
        this.buildFilling(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42590_}), (ItemLike)Items.f_42612_, new FluidStack((Fluid)EIOFluids.XP_JUICE.getSource(), 250), pWriter);
        this.buildEmptying(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41903_}), (ItemLike)Items.f_41902_, new FluidStack((Fluid)Fluids.f_76193_, 1000), pWriter);
        this.buildFilling(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41902_}), (ItemLike)Items.f_41903_, new FluidStack((Fluid)Fluids.f_76193_, 1000), pWriter);
        this.buildFilling(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42398_}), (ItemLike)EIOItems.NUTRITIOUS_STICK, new FluidStack((Fluid)EIOFluids.NUTRIENT_DISTILLATION.getSource(), 1000), pWriter);
        this.buildFilling(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42315_}), (ItemLike)Items.f_42246_, new FluidStack((Fluid)Fluids.f_76193_, 1000), pWriter);
        this.buildFilling(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42316_}), (ItemLike)Items.f_42247_, new FluidStack((Fluid)Fluids.f_76193_, 1000), pWriter);
        this.buildFilling(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42317_}), (ItemLike)Items.f_42248_, new FluidStack((Fluid)Fluids.f_76193_, 1000), pWriter);
        this.buildFilling(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42318_}), (ItemLike)Items.f_42249_, new FluidStack((Fluid)Fluids.f_76193_, 1000), pWriter);
        this.buildFilling(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42319_}), (ItemLike)Items.f_42303_, new FluidStack((Fluid)Fluids.f_76193_, 1000), pWriter);
        this.buildFilling(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42320_}), (ItemLike)Items.f_42304_, new FluidStack((Fluid)Fluids.f_76193_, 1000), pWriter);
        this.buildFilling(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42321_}), (ItemLike)Items.f_42305_, new FluidStack((Fluid)Fluids.f_76193_, 1000), pWriter);
        this.buildFilling(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42322_}), (ItemLike)Items.f_42306_, new FluidStack((Fluid)Fluids.f_76193_, 1000), pWriter);
        this.buildFilling(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42323_}), (ItemLike)Items.f_42307_, new FluidStack((Fluid)Fluids.f_76193_, 1000), pWriter);
        this.buildFilling(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42324_}), (ItemLike)Items.f_42308_, new FluidStack((Fluid)Fluids.f_76193_, 1000), pWriter);
        this.buildFilling(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42325_}), (ItemLike)Items.f_42309_, new FluidStack((Fluid)Fluids.f_76193_, 1000), pWriter);
        this.buildFilling(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42326_}), (ItemLike)Items.f_42310_, new FluidStack((Fluid)Fluids.f_76193_, 1000), pWriter);
        this.buildFilling(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42327_}), (ItemLike)Items.f_42311_, new FluidStack((Fluid)Fluids.f_76193_, 1000), pWriter);
        this.buildFilling(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42328_}), (ItemLike)Items.f_42312_, new FluidStack((Fluid)Fluids.f_76193_, 1000), pWriter);
        this.buildFilling(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42277_}), (ItemLike)Items.f_42313_, new FluidStack((Fluid)Fluids.f_76193_, 1000), pWriter);
        this.buildFilling(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42278_}), (ItemLike)Items.f_42314_, new FluidStack((Fluid)Fluids.f_76193_, 1000), pWriter);
    }

    protected void buildEmptying(Ingredient input, ItemLike output, FluidStack fluid, Consumer<FinishedRecipe> finishedRecipeConsumer) {
        finishedRecipeConsumer.accept(new FinishedTankRecipe(EnderIO.loc("tank_empty/" + ForgeRegistries.ITEMS.getKey((Object)output.m_5456_()).m_135815_()), input, output.m_5456_(), fluid, true));
    }

    protected void buildFilling(Ingredient input, ItemLike output, FluidStack fluid, Consumer<FinishedRecipe> finishedRecipeConsumer) {
        finishedRecipeConsumer.accept(new FinishedTankRecipe(EnderIO.loc("tank_fill/" + ForgeRegistries.ITEMS.getKey((Object)output.m_5456_()).m_135815_()), input, output.m_5456_(), fluid, false));
    }

    protected static class FinishedTankRecipe
    extends EnderRecipeProvider.EnderFinishedRecipe {
        private final Ingredient input;
        private final Item output;
        private final FluidStack fluid;
        private final boolean isEmptying;

        protected FinishedTankRecipe(ResourceLocation id, Ingredient input, Item output, FluidStack fluid, boolean isEmptying) {
            super(id);
            this.input = input;
            this.output = output;
            this.fluid = fluid;
            this.isEmptying = isEmptying;
        }

        @Override
        public void m_7917_(JsonObject json) {
            json.add("input", this.input.m_43942_());
            json.addProperty("output", ForgeRegistries.ITEMS.getKey((Object)this.output).toString());
            JsonObject fluidJson = new JsonObject();
            fluidJson.addProperty("fluid", ForgeRegistries.FLUIDS.getKey((Object)this.fluid.getFluid()).toString());
            fluidJson.addProperty("amount", (Number)this.fluid.getAmount());
            json.add("fluid", (JsonElement)fluidJson);
            json.addProperty("is_emptying", Boolean.valueOf(this.isEmptying));
            super.m_7917_(json);
        }

        @Override
        protected Set<String> getModDependencies() {
            HashSet<String> mods = new HashSet<String>(RecipeDataUtil.getIngredientModIds(this.input));
            mods.add(ForgeRegistries.ITEMS.getKey((Object)this.output).m_135827_());
            mods.add(ForgeRegistries.FLUIDS.getKey((Object)this.fluid.getFluid()).m_135827_());
            return mods;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)MachineRecipes.TANK.serializer().get();
        }
    }
}

