/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.recipe;

import com.enderio.EnderIO;
import com.enderio.api.capability.IEntityStorage;
import com.enderio.base.common.init.EIOCapabilities;
import com.enderio.base.common.init.EIOItems;
import com.enderio.base.common.util.ExperienceUtil;
import com.enderio.core.common.recipes.OutputStack;
import com.enderio.machines.common.blockentity.SoulBinderBlockEntity;
import com.enderio.machines.common.init.MachineRecipes;
import com.enderio.machines.common.recipe.MachineRecipe;
import com.enderio.machines.common.souldata.SoulDataReloadListener;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class SoulBindingRecipe
implements MachineRecipe<Container> {
    private final ResourceLocation id;
    private final Item output;
    private final Ingredient input;
    private final int energy;
    private final int exp;
    @Nullable
    private final ResourceLocation entityType;
    @Nullable
    private final MobCategory mobCategory;
    @Nullable
    private final String souldata;

    public SoulBindingRecipe(ResourceLocation id, Item output, Ingredient input, int energy, int exp, @Nullable ResourceLocation entityType, @Nullable MobCategory mobCategory, @Nullable String souldata) {
        this.id = id;
        this.output = output;
        this.input = input;
        this.energy = energy;
        this.exp = exp;
        if (entityType != null && mobCategory != null) {
            throw new IllegalStateException("entityType and mobCategory are mutually exclusive!");
        }
        if (souldata != null && mobCategory != null) {
            throw new IllegalStateException("souldata and mobCategory are mutually exclusive!");
        }
        if (entityType != null && souldata != null) {
            throw new IllegalStateException("entityType and souldata are mutually exclusive!");
        }
        this.entityType = entityType;
        this.mobCategory = mobCategory;
        this.souldata = souldata;
    }

    public Ingredient getInput() {
        return this.input;
    }

    @Nullable
    public ResourceLocation getEntityType() {
        return this.entityType;
    }

    @Nullable
    public MobCategory getMobCategory() {
        return this.mobCategory;
    }

    @Nullable
    public String getSouldata() {
        return this.souldata;
    }

    @Override
    public int getBaseEnergyCost() {
        return this.energy;
    }

    public int getExpCost() {
        return this.exp;
    }

    @Override
    public List<OutputStack> craft(Container container, RegistryAccess registryAccess) {
        ItemStack vial = SoulBinderBlockEntity.INPUT_SOUL.getItemStack((net.minecraft.world.Container)container);
        List<OutputStack> results = this.getResultStacks(registryAccess);
        ItemStack result = results.get(0).getItem();
        vial.getCapability(EIOCapabilities.ENTITY_STORAGE).ifPresent(inputEntity -> result.getCapability(EIOCapabilities.ENTITY_STORAGE).ifPresent(resultEntity -> resultEntity.setStoredEntityData(inputEntity.getStoredEntityData())));
        return results;
    }

    @Override
    public List<OutputStack> getResultStacks(RegistryAccess registryAccess) {
        return List.of(OutputStack.of(this.output.m_7968_()), OutputStack.of(EIOItems.EMPTY_SOUL_VIAL.asStack()));
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.input});
    }

    public boolean matches(Container container, Level pLevel) {
        if (!container.m_8020_(0).m_150930_((Item)EIOItems.FILLED_SOUL_VIAL.get())) {
            return false;
        }
        if (!this.input.test(SoulBinderBlockEntity.INPUT_OTHER.getItemStack((net.minecraft.world.Container)container))) {
            return false;
        }
        LazyOptional capability = container.m_8020_(0).getCapability(EIOCapabilities.ENTITY_STORAGE);
        if (!capability.isPresent()) {
            return false;
        }
        if (this.souldata != null) {
            if (SoulDataReloadListener.fromString(this.souldata).matches(((IEntityStorage)container.m_8020_(0).getCapability(EIOCapabilities.ENTITY_STORAGE).resolve().get()).getStoredEntityData().getEntityType().get()).isEmpty()) {
                return false;
            }
            return ExperienceUtil.getLevelFromFluid(container.fluid.get()) >= this.exp;
        }
        if (this.mobCategory == null && this.entityType == null) {
            return ExperienceUtil.getLevelFromFluid(container.fluid.get()) >= this.exp;
        }
        IEntityStorage storage = (IEntityStorage)capability.resolve().get();
        if (storage.hasStoredEntity()) {
            Optional<ResourceLocation> type = storage.getStoredEntityData().getEntityType();
            if (type.isEmpty()) {
                return false;
            }
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(type.get());
            if (entityType == null) {
                return false;
            }
            if (entityType.m_20674_().equals((Object)this.mobCategory)) {
                return ExperienceUtil.getLevelFromFluid(container.fluid.get()) >= this.exp;
            }
        }
        if (storage.hasStoredEntity() && storage.getStoredEntityData().getEntityType().get().equals((Object)this.entityType)) {
            return ExperienceUtil.getLevelFromFluid(container.fluid.get()) >= this.exp;
        }
        return false;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)MachineRecipes.SOUL_BINDING.serializer().get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)MachineRecipes.SOUL_BINDING.type().get();
    }

    public static class Container
    extends RecipeWrapper {
        private final Supplier<Integer> fluid;

        public Container(IItemHandlerModifiable inv, Supplier<Integer> fluid) {
            super(inv);
            this.fluid = fluid;
        }
    }

    public static class Serializer
    implements RecipeSerializer<SoulBindingRecipe> {
        public SoulBindingRecipe fromJson(ResourceLocation pRecipeId, JsonObject serializedRecipe) {
            ResourceLocation id = new ResourceLocation(serializedRecipe.get("output").getAsString());
            Item output = (Item)ForgeRegistries.ITEMS.getValue(id);
            Ingredient input = Ingredient.m_43917_((JsonElement)serializedRecipe.get("input").getAsJsonObject());
            int energy = serializedRecipe.get("energy").getAsInt();
            int exp = serializedRecipe.get("exp").getAsInt();
            ResourceLocation entityType = null;
            if (serializedRecipe.has("entity_type")) {
                entityType = new ResourceLocation(serializedRecipe.get("entity_type").getAsString());
            }
            MobCategory mobCategory = null;
            if (serializedRecipe.has("mob_category")) {
                mobCategory = MobCategory.byName((String)serializedRecipe.get("mob_category").getAsString());
            }
            String souldata = null;
            if (serializedRecipe.has("souldata")) {
                souldata = serializedRecipe.get("souldata").getAsString();
            }
            return new SoulBindingRecipe(pRecipeId, output, input, energy, exp, entityType, mobCategory, souldata);
        }

        @Nullable
        public SoulBindingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            try {
                ResourceLocation outputId = buffer.m_130281_();
                Item output = (Item)ForgeRegistries.ITEMS.getValue(outputId);
                if (output == null) {
                    throw new ResourceLocationException("The output of recipe " + recipeId + " does not exist.");
                }
                Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
                int energy = buffer.readInt();
                int exp = buffer.readInt();
                int mode = buffer.readInt();
                ResourceLocation entityType = null;
                if (mode == 1) {
                    entityType = buffer.m_130281_();
                }
                MobCategory mobCategory = null;
                if (mode == 2) {
                    mobCategory = MobCategory.byName((String)buffer.m_130277_());
                }
                String souldata = null;
                if (mode == 3) {
                    souldata = buffer.m_130277_();
                }
                return new SoulBindingRecipe(recipeId, output, input, energy, exp, entityType, mobCategory, souldata);
            }
            catch (Exception ex) {
                EnderIO.LOGGER.error("Error reading soul binding recipe from packet.", (Throwable)ex);
                throw ex;
            }
        }

        public void toNetwork(FriendlyByteBuf buffer, SoulBindingRecipe recipe) {
            try {
                buffer.m_130085_(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)recipe.output)));
                recipe.input.m_43923_(buffer);
                buffer.writeInt(recipe.energy);
                buffer.writeInt(recipe.exp);
                if (recipe.entityType != null) {
                    buffer.writeInt(1);
                    buffer.m_130085_(recipe.entityType);
                } else if (recipe.mobCategory != null) {
                    buffer.writeInt(2);
                    buffer.m_130070_(recipe.mobCategory.m_21607_());
                } else if (recipe.souldata != null) {
                    buffer.writeInt(3);
                    buffer.m_130070_(recipe.souldata);
                } else {
                    buffer.writeInt(0);
                }
            }
            catch (Exception ex) {
                EnderIO.LOGGER.error("Error writing soul binding recipe to packet.", (Throwable)ex);
                throw ex;
            }
        }
    }
}

