/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.recipe;

import com.enderio.EnderIO;
import com.enderio.core.common.recipes.OutputStack;
import com.enderio.machines.common.init.MachineRecipes;
import com.enderio.machines.common.recipe.MachineRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class SlicingRecipe
implements MachineRecipe<Container> {
    private final ResourceLocation id;
    private final Item output;
    private final List<Ingredient> inputs;
    private final int energy;

    public SlicingRecipe(ResourceLocation id, Item output, List<Ingredient> inputs, int energy) {
        this.id = id;
        this.output = output;
        this.inputs = inputs;
        this.energy = energy;
    }

    @Override
    public int getBaseEnergyCost() {
        return this.energy;
    }

    @Override
    public List<OutputStack> craft(Container container, RegistryAccess registryAccess) {
        return this.getResultStacks(registryAccess);
    }

    @Override
    public List<OutputStack> getResultStacks(RegistryAccess registryAccess) {
        return List.of(OutputStack.of(new ItemStack((ItemLike)this.output, 1)));
    }

    public List<Ingredient> getInputs() {
        return List.copyOf(this.inputs);
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])this.inputs.toArray(new Ingredient[0]));
    }

    public boolean m_5818_(Container container, Level level) {
        for (int i = 0; i < this.inputs.size(); ++i) {
            if (this.inputs.get(i).test(container.m_8020_(i))) continue;
            return false;
        }
        return true;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)MachineRecipes.SLICING.serializer().get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)MachineRecipes.SLICING.type().get();
    }

    public static class Serializer
    implements RecipeSerializer<SlicingRecipe> {
        public SlicingRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            ResourceLocation id = new ResourceLocation(serializedRecipe.get("output").getAsString());
            Item output = (Item)ForgeRegistries.ITEMS.getValue(id);
            if (output == null) {
                EnderIO.LOGGER.error("Slicing recipe {} tried to load missing item {}", (Object)recipeId, (Object)id);
                throw new ResourceLocationException("Item not found for slicing recipe.");
            }
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            JsonArray inputsJson = serializedRecipe.getAsJsonArray("inputs");
            for (JsonElement itemJson : inputsJson) {
                inputs.add(Ingredient.m_43917_((JsonElement)itemJson));
            }
            int energy = serializedRecipe.get("energy").getAsInt();
            return new SlicingRecipe(recipeId, output, inputs, energy);
        }

        @Nullable
        public SlicingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            try {
                ResourceLocation outputId = buffer.m_130281_();
                Item output = (Item)ForgeRegistries.ITEMS.getValue(outputId);
                if (output == null) {
                    throw new ResourceLocationException("The output of recipe " + recipeId + " does not exist.");
                }
                List inputs = (List)buffer.m_236838_(ArrayList::new, Ingredient::m_43940_);
                int energy = buffer.readInt();
                return new SlicingRecipe(recipeId, output, inputs, energy);
            }
            catch (Exception ex) {
                EnderIO.LOGGER.error("Error reading slicing recipe from packet.", (Throwable)ex);
                throw ex;
            }
        }

        public void toNetwork(FriendlyByteBuf buffer, SlicingRecipe recipe) {
            try {
                buffer.m_130085_(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)recipe.output)));
                buffer.m_236828_(recipe.inputs, (buf, ing) -> ing.m_43923_(buf));
                buffer.writeInt(recipe.energy);
            }
            catch (Exception ex) {
                EnderIO.LOGGER.error("Error writing slicing recipe to packet.", (Throwable)ex);
                throw ex;
            }
        }
    }
}

