/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.init;

import com.enderio.EnderIO;
import com.enderio.base.common.init.EIOCreativeTabs;
import com.enderio.core.data.model.EIOModel;
import com.enderio.machines.common.block.CapacitorBankBlock;
import com.enderio.machines.common.block.MachineBlock;
import com.enderio.machines.common.block.ProgressMachineBlock;
import com.enderio.machines.common.block.SolarPanelBlock;
import com.enderio.machines.common.block.TravelAnchorBlock;
import com.enderio.machines.common.blockentity.base.MachineBlockEntity;
import com.enderio.machines.common.blockentity.capacitorbank.CapacitorBankBlockEntity;
import com.enderio.machines.common.blockentity.capacitorbank.CapacitorTier;
import com.enderio.machines.common.blockentity.solar.SolarPanelBlockEntity;
import com.enderio.machines.common.blockentity.solar.SolarPanelTier;
import com.enderio.machines.common.init.MachineBlockEntities;
import com.enderio.machines.common.item.BoundSoulBlockItem;
import com.enderio.machines.common.item.CapacitorBankItem;
import com.enderio.machines.common.item.FluidTankItem;
import com.enderio.machines.data.loot.MachinesLootTable;
import com.enderio.machines.data.model.MachineModelUtil;
import com.google.common.collect.ImmutableMap;
import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.entry.BlockEntityEntry;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.loaders.CompositeModelBuilder;

public class MachineBlocks {
    private static final Registrate REGISTRATE = EnderIO.registrate();
    public static final BlockEntry<MachineBlock> FLUID_TANK = ((BlockBuilder)REGISTRATE.block("fluid_tank", props -> new MachineBlock((BlockBehaviour.Properties)props, (BlockEntityEntry<? extends MachineBlockEntity>)MachineBlockEntities.FLUID_TANK)).properties(props -> props.m_60913_(2.5f, 8.0f).m_60971_((pState, pLevel, pPos) -> false).m_60955_()).loot(MachinesLootTable::copyNBT).tag(new TagKey[]{BlockTags.f_144285_, BlockTags.f_144282_}).blockstate((ctx, prov) -> prov.horizontalBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)((CompositeModelBuilder)((BlockModelBuilder)prov.models().getBuilder(ctx.getName())).customLoader(CompositeModelBuilder::begin)).child("tank", (ModelBuilder)EIOModel.getExistingParent(prov.models(), EnderIO.loc(String.format("block/%s_body", ctx.getName())))).child("overlay", (ModelBuilder)EIOModel.getExistingParent(prov.models(), EnderIO.loc("block/io_overlay"))).end()).texture("particle", EnderIO.loc("block/machine_side")))).item((block, props) -> new FluidTankItem((MachineBlock)((Object)block), (Item.Properties)props, 16000)).model((ctx, prov) -> {}).tab(EIOCreativeTabs.MACHINES).build()).register();
    public static final BlockEntry<MachineBlock> PRESSURIZED_FLUID_TANK = ((BlockBuilder)REGISTRATE.block("pressurized_fluid_tank", props -> new MachineBlock((BlockBehaviour.Properties)props, (BlockEntityEntry<? extends MachineBlockEntity>)MachineBlockEntities.PRESSURIZED_FLUID_TANK)).properties(props -> props.m_60913_(2.5f, 8.0f).m_60971_((pState, pLevel, pPos) -> false).m_60955_()).loot(MachinesLootTable::copyNBT).tag(new TagKey[]{BlockTags.f_144285_, BlockTags.f_144282_}).blockstate((ctx, prov) -> prov.horizontalBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)((CompositeModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), prov.mcLoc("block/block"))).customLoader(CompositeModelBuilder::begin)).child("tank", (ModelBuilder)EIOModel.getExistingParent(prov.models(), EnderIO.loc(String.format("block/%s_body", ctx.getName())))).child("overlay", (ModelBuilder)EIOModel.getExistingParent(prov.models(), EnderIO.loc("block/io_overlay"))).end()).texture("particle", EnderIO.loc("block/machine_side")))).item((block, props) -> new FluidTankItem((MachineBlock)((Object)block), (Item.Properties)props, 32000)).model((ctx, prov) -> {}).tab(EIOCreativeTabs.MACHINES).build()).register();
    public static final BlockEntry<MachineBlock> ENCHANTER = ((BlockBuilder)REGISTRATE.block("enchanter", props -> new MachineBlock((BlockBehaviour.Properties)props, (BlockEntityEntry<? extends MachineBlockEntity>)MachineBlockEntities.ENCHANTER)).properties(props -> props.m_60913_(2.5f, 8.0f).m_60955_().m_60971_((pState, pLevel, pPos) -> false)).loot(MachinesLootTable::copyNBT).tag(new TagKey[]{BlockTags.f_144285_, BlockTags.f_144282_}).blockstate(MachineModelUtil::machineBlock).item().tab(EIOCreativeTabs.MACHINES).build()).register();
    public static final BlockEntry<ProgressMachineBlock> PRIMITIVE_ALLOY_SMELTER = MachineBlocks.progressMachine("primitive_alloy_smelter", () -> MachineBlockEntities.PRIMITIVE_ALLOY_SMELTER).register();
    public static final BlockEntry<ProgressMachineBlock> ALLOY_SMELTER = MachineBlocks.progressMachine("alloy_smelter", () -> MachineBlockEntities.ALLOY_SMELTER).register();
    public static final BlockEntry<ProgressMachineBlock> PAINTING_MACHINE = MachineBlocks.progressMachine("painting_machine", () -> MachineBlockEntities.PAINTING_MACHINE).register();
    public static final BlockEntry<MachineBlock> WIRED_CHARGER = MachineBlocks.machine("wired_charger", () -> MachineBlockEntities.WIRED_CHARGER).register();
    public static final BlockEntry<MachineBlock> CREATIVE_POWER = ((BlockBuilder)REGISTRATE.block("creative_power", props -> new MachineBlock((BlockBehaviour.Properties)props, (BlockEntityEntry<? extends MachineBlockEntity>)MachineBlockEntities.CREATIVE_POWER)).item().tab(EIOCreativeTabs.MACHINES).build()).register();
    public static final BlockEntry<ProgressMachineBlock> STIRLING_GENERATOR = MachineBlocks.progressMachine("stirling_generator", () -> MachineBlockEntities.STIRLING_GENERATOR).register();
    public static final BlockEntry<ProgressMachineBlock> SAG_MILL = MachineBlocks.progressMachine("sag_mill", () -> MachineBlockEntities.SAG_MILL).lang("SAG Mill").register();
    public static final BlockEntry<ProgressMachineBlock> SLICE_AND_SPLICE = MachineBlocks.progressMachine("slice_and_splice", () -> MachineBlockEntities.SLICE_AND_SPLICE).lang("Slice'N'Splice").register();
    public static final BlockEntry<ProgressMachineBlock> IMPULSE_HOPPER = MachineBlocks.progressMachine("impulse_hopper", () -> MachineBlockEntities.IMPULSE_HOPPER).lang("Impulse Hopper").register();
    public static final BlockEntry<ProgressMachineBlock> SOUL_BINDER = MachineBlocks.progressMachine("soul_binder", () -> MachineBlockEntities.SOUL_BINDER).lang("Soul Binder").register();
    public static final BlockEntry<ProgressMachineBlock> POWERED_SPAWNER = ((BlockBuilder)REGISTRATE.block("powered_spawner", properties -> new ProgressMachineBlock((BlockBehaviour.Properties)properties, (BlockEntityEntry<? extends MachineBlockEntity>)MachineBlockEntities.POWERED_SPAWNER)).loot((l, t) -> MachinesLootTable.copyNBTSingleCap(l, t, "EntityStorage")).properties(props -> props.m_60913_(2.5f, 8.0f)).blockstate(MachineModelUtil::progressMachineBlock).tag(new TagKey[]{BlockTags.f_144285_, BlockTags.f_144282_}).item(BoundSoulBlockItem::new).tab(EIOCreativeTabs.MACHINES).build()).register();
    public static final BlockEntry<MachineBlock> VACUUM_CHEST = ((BlockBuilder)REGISTRATE.block("vacuum_chest", p -> new MachineBlock((BlockBehaviour.Properties)p, (BlockEntityEntry<? extends MachineBlockEntity>)MachineBlockEntities.VACUUM_CHEST)).properties(props -> props.m_60913_(2.5f, 8.0f).m_60955_()).tag(new TagKey[]{BlockTags.f_144285_, BlockTags.f_144282_}).loot(MachinesLootTable::copyNBT).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().getExistingFile(EnderIO.loc("block/" + ctx.getName())))).item().tab(EIOCreativeTabs.MACHINES).build()).register();
    public static final BlockEntry<MachineBlock> XP_VACUUM = ((BlockBuilder)REGISTRATE.block("xp_vacuum", p -> new MachineBlock((BlockBehaviour.Properties)p, (BlockEntityEntry<? extends MachineBlockEntity>)MachineBlockEntities.XP_VACUUM)).properties(props -> props.m_60913_(2.5f, 8.0f).m_60955_()).tag(new TagKey[]{BlockTags.f_144285_, BlockTags.f_144282_}).loot(MachinesLootTable::copyNBT).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().getExistingFile(EnderIO.loc("block/" + ctx.getName())))).lang("XP Vacuum").item().tab(EIOCreativeTabs.MACHINES).build()).register();
    public static final BlockEntry<TravelAnchorBlock> TRAVEL_ANCHOR = ((BlockBuilder)REGISTRATE.block("travel_anchor", TravelAnchorBlock::new).properties(props -> props.m_60913_(2.5f, 8.0f).m_60955_()).tag(new TagKey[]{BlockTags.f_144285_, BlockTags.f_144282_}).loot(MachinesLootTable::copyNBT).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().getExistingFile(EnderIO.loc("block/" + ctx.getName())))).item().tab(EIOCreativeTabs.MACHINES).build()).register();
    public static final Map<SolarPanelTier, BlockEntry<SolarPanelBlock>> SOLAR_PANELS = (Map)Util.m_137537_(() -> {
        HashMap<SolarPanelTier, BlockEntry> panels = new HashMap<SolarPanelTier, BlockEntry>();
        for (SolarPanelTier tier : SolarPanelTier.values()) {
            panels.put(tier, MachineBlocks.solarPanel(tier.name().toLowerCase(Locale.ROOT) + "_photovoltaic_module", () -> MachineBlockEntities.SOLAR_PANELS.get(tier), tier).register());
        }
        return ImmutableMap.copyOf(panels);
    });
    public static final Map<CapacitorTier, BlockEntry<CapacitorBankBlock>> CAPACITOR_BANKS = (Map)Util.m_137537_(() -> {
        HashMap<CapacitorTier, BlockEntry> banks = new HashMap<CapacitorTier, BlockEntry>();
        for (CapacitorTier tier : CapacitorTier.values()) {
            banks.put(tier, MachineBlocks.capacitorBank(tier.name().toLowerCase(Locale.ROOT) + "_capacitor_bank", () -> MachineBlockEntities.CAPACITOR_BANKS.get(tier), tier).register());
        }
        return ImmutableMap.copyOf(banks);
    });
    public static final BlockEntry<ProgressMachineBlock> CRAFTER = MachineBlocks.progressMachine("crafter", () -> MachineBlockEntities.CRAFTER).register();
    public static final BlockEntry<ProgressMachineBlock> SOUL_ENGINE = ((BlockBuilder)REGISTRATE.block("soul_engine", p -> new ProgressMachineBlock((BlockBehaviour.Properties)p, (BlockEntityEntry<? extends MachineBlockEntity>)MachineBlockEntities.SOUL_ENGINE)).properties(props -> props.m_60913_(2.5f, 8.0f).m_60955_()).loot(MachinesLootTable::copyNBT).tag(new TagKey[]{BlockTags.f_144285_, BlockTags.f_144282_}).blockstate(MachineModelUtil::progressMachineBlock).item(BoundSoulBlockItem::new).tab(EIOCreativeTabs.MACHINES).build()).register();
    public static final BlockEntry<ProgressMachineBlock> DRAIN = MachineBlocks.progressMachine("drain", () -> MachineBlockEntities.DRAIN).register();
    public static final BlockEntry<MachineBlock> XP_OBELISK = ((BlockBuilder)REGISTRATE.block("xp_obelisk", props -> new MachineBlock((BlockBehaviour.Properties)props, (BlockEntityEntry<? extends MachineBlockEntity>)MachineBlockEntities.XP_OBELISK)).properties(props -> props.m_60913_(2.5f, 8.0f).m_60971_((pState, pLevel, pPos) -> false).m_60955_()).loot(MachinesLootTable::copyNBT).tag(new TagKey[]{BlockTags.f_144285_, BlockTags.f_144282_}).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().getExistingFile(EnderIO.loc("block/" + ctx.getName())))).lang("XP Obelisk").item().tab(EIOCreativeTabs.MACHINES).build()).register();

    private static <T extends MachineBlock> BlockBuilder<T, Registrate> baseMachine(BlockBuilder<T, Registrate> machineBlock, NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> blockStateProvider) {
        return (BlockBuilder)machineBlock.properties(props -> props.m_60913_(2.5f, 8.0f)).loot(MachinesLootTable::copyNBT).tag(new TagKey[]{BlockTags.f_144285_, BlockTags.f_144282_}).blockstate(blockStateProvider).item().tab(EIOCreativeTabs.MACHINES).build();
    }

    private static BlockBuilder<MachineBlock, Registrate> machine(String name, Supplier<BlockEntityEntry<? extends MachineBlockEntity>> blockEntityEntry) {
        return MachineBlocks.baseMachine(REGISTRATE.block(name, props -> new MachineBlock((BlockBehaviour.Properties)props, (BlockEntityEntry<? extends MachineBlockEntity>)((BlockEntityEntry)blockEntityEntry.get()))), MachineModelUtil::machineBlock);
    }

    private static BlockBuilder<ProgressMachineBlock, Registrate> progressMachine(String name, Supplier<BlockEntityEntry<? extends MachineBlockEntity>> blockEntityEntry) {
        return MachineBlocks.baseMachine(REGISTRATE.block(name, props -> new ProgressMachineBlock((BlockBehaviour.Properties)props, (BlockEntityEntry<? extends MachineBlockEntity>)((BlockEntityEntry)blockEntityEntry.get()))), MachineModelUtil::progressMachineBlock);
    }

    private static BlockBuilder<SolarPanelBlock, Registrate> solarPanel(String name, Supplier<BlockEntityEntry<? extends SolarPanelBlockEntity>> blockEntityEntry, SolarPanelTier tier) {
        return (BlockBuilder)REGISTRATE.block(name, props -> new SolarPanelBlock((BlockBehaviour.Properties)props, (BlockEntityEntry<? extends MachineBlockEntity>)((BlockEntityEntry)blockEntityEntry.get()), tier)).properties(props -> props.m_60913_(2.5f, 8.0f)).blockstate((ctx, prov) -> MachineModelUtil.solarPanel((DataGenContext<Block, ? extends Block>)ctx, prov, tier)).tag(new TagKey[]{BlockTags.f_144282_}).item().model((ctx, prov) -> MachineModelUtil.solarPanel((DataGenContext<Item, ? extends Item>)ctx, prov, tier)).tab(EIOCreativeTabs.MACHINES).build();
    }

    private static BlockBuilder<CapacitorBankBlock, Registrate> capacitorBank(String name, Supplier<BlockEntityEntry<? extends CapacitorBankBlockEntity>> blockEntityEntry, CapacitorTier tier) {
        return (BlockBuilder)REGISTRATE.block(name, props -> new CapacitorBankBlock((BlockBehaviour.Properties)props, (BlockEntityEntry<? extends MachineBlockEntity>)((BlockEntityEntry)blockEntityEntry.get()), tier)).properties(props -> props.m_60913_(2.5f, 8.0f)).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)prov.models().getExistingFile(EnderIO.loc(ctx.getName())))).loot(MachinesLootTable::copyNBT).tag(new TagKey[]{BlockTags.f_144282_}).item(CapacitorBankItem::new).model((ctx, cons) -> {}).tab(EIOCreativeTabs.MACHINES).build();
    }

    public static void register() {
    }
}

