/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity.multienergy;

import com.enderio.api.io.IIOConfig;
import com.enderio.api.io.energy.EnergyIOMode;
import com.enderio.machines.common.blockentity.multienergy.ICapacityTier;
import com.enderio.machines.common.blockentity.multienergy.MultiEnergyNode;
import com.enderio.machines.common.io.energy.ILargeMachineEnergyStorage;
import com.enderio.machines.common.io.energy.MachineEnergyStorage;
import dev.gigaherz.graph3.Graph;
import dev.gigaherz.graph3.GraphObject;
import dev.gigaherz.graph3.Mergeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class MultiEnergyStorageWrapper
extends MachineEnergyStorage
implements ILargeMachineEnergyStorage {
    @Nullable
    private Graph<Mergeable.Dummy> graph;
    private final Supplier<ICapacityTier> tier;
    private long addedEnergy = 0L;
    private long removedEnergy = 0L;
    private long lastResetTime = 0L;

    public MultiEnergyStorageWrapper(IIOConfig config, EnergyIOMode ioMode, Supplier<ICapacityTier> tier) {
        super(config, ioMode, () -> ((ICapacityTier)tier.get()).getStorageCapacity(), () -> ((ICapacityTier)tier.get()).getStorageCapacity());
        this.tier = tier;
    }

    public void setGraph(Graph<Mergeable.Dummy> graph) {
        this.graph = graph;
    }

    @Override
    public int getEnergyStored() {
        return (int)Math.min(Integer.MAX_VALUE, this.getLargeEnergyStored());
    }

    @Override
    public long getLargeEnergyStored() {
        if (this.graph == null) {
            return 0L;
        }
        long cumulativeEnergy = 0L;
        for (GraphObject object : this.graph.getObjects()) {
            if (!(object instanceof MultiEnergyNode)) continue;
            MultiEnergyNode panelNode = (MultiEnergyNode)object;
            cumulativeEnergy += (long)panelNode.getInternal().get().getEnergyStored();
        }
        return cumulativeEnergy;
    }

    @Override
    public int getMaxEnergyStored() {
        return (int)Math.min(this.getLargeMaxEnergyStored(), Integer.MAX_VALUE);
    }

    @Override
    public long getLargeMaxEnergyStored() {
        if (this.graph == null) {
            return 0L;
        }
        return (long)this.graph.getObjects().size() * (long)this.tier.get().getStorageCapacity();
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyReceived = (int)Math.min(this.getLargeMaxEnergyStored() - this.getLargeEnergyStored(), (long)Math.min(this.getMaxEnergyUse() * 2, maxReceive));
        if (!simulate) {
            this.addEnergy(energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int takeEnergy(int energy) {
        MultiEnergyNode node;
        GraphObject object;
        if (this.graph == null || energy == 0) {
            return 0;
        }
        int cumulativeEnergy = 0;
        ArrayList nodes = new ArrayList(this.graph.getObjects());
        Collections.shuffle(nodes);
        Iterator iterator = nodes.iterator();
        while (iterator.hasNext() && (!((object = (GraphObject)iterator.next()) instanceof MultiEnergyNode) || energy - (cumulativeEnergy += (node = (MultiEnergyNode)object).getInternal().get().extractEnergy(energy - cumulativeEnergy, false)) > 0)) {
        }
        this.removedEnergy += (long)cumulativeEnergy;
        return cumulativeEnergy;
    }

    @Override
    public int addEnergy(int energy) {
        MultiEnergyNode node;
        GraphObject object;
        if (this.graph == null || energy == 0) {
            return 0;
        }
        int cumulativeEnergy = 0;
        ArrayList nodes = new ArrayList(this.graph.getObjects());
        Collections.shuffle(nodes);
        Iterator iterator = nodes.iterator();
        while (iterator.hasNext() && (!((object = (GraphObject)iterator.next()) instanceof MultiEnergyNode) || energy - (cumulativeEnergy += (node = (MultiEnergyNode)object).getInternal().get().receiveEnergy(energy - cumulativeEnergy, false)) > 0)) {
        }
        this.addedEnergy += (long)cumulativeEnergy;
        return cumulativeEnergy;
    }

    public long getAddedEnergy() {
        return this.addedEnergy;
    }

    public long getRemovedEnergy() {
        return this.removedEnergy;
    }

    public void resetEnergyStats(long gameTime) {
        if (this.lastResetTime != gameTime) {
            this.addedEnergy = 0L;
            this.removedEnergy = 0L;
            this.lastResetTime = gameTime;
        }
    }

    public long getLastResetTime() {
        return this.lastResetTime;
    }
}

