/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity;

import com.enderio.base.common.init.EIOFluids;
import com.enderio.base.common.util.ExperienceUtil;
import com.enderio.core.common.network.slot.IntegerNetworkDataSlot;
import com.enderio.machines.common.blockentity.base.VacuumMachineBlockEntity;
import com.enderio.machines.common.config.MachinesConfig;
import com.enderio.machines.common.menu.XPVacuumMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.Nullable;

public class XPVacuumBlockEntity
extends VacuumMachineBlockEntity<ExperienceOrb> {
    public XPVacuumBlockEntity(BlockEntityType<?> pType, BlockPos pWorldPosition, BlockState pBlockState) {
        super(pType, pWorldPosition, pBlockState, ExperienceOrb.class);
        this.addDataSlot(new IntegerNetworkDataSlot(() -> this.getFluidTankNN().getFluidInTank(0).getAmount(), i -> this.getFluidTankNN().setFluid(new FluidStack((Fluid)EIOFluids.XP_JUICE.getSource(), i.intValue()))));
    }

    @Override
    public String getColor() {
        return (String)MachinesConfig.CLIENT.BLOCKS.XP_VACUUM_RANGE_COLOR.get();
    }

    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new XPVacuumMenu(this, inventory, containerId);
    }

    @Override
    public void handleEntity(ExperienceOrb xpe) {
        int filled = this.getFluidTankNN().fill(new FluidStack((Fluid)EIOFluids.XP_JUICE.getSource(), xpe.m_20801_() * ExperienceUtil.EXP_TO_FLUID), IFluidHandler.FluidAction.EXECUTE);
        if (filled == xpe.m_20801_() * ExperienceUtil.EXP_TO_FLUID) {
            xpe.m_146870_();
        } else {
            xpe.f_20770_ = (int)((float)xpe.f_20770_ - (float)filled / (float)ExperienceUtil.EXP_TO_FLUID);
        }
    }

    @Override
    @Nullable
    protected FluidTank createFluidTank() {
        return new FluidTank(Integer.MAX_VALUE){

            protected void onContentsChanged() {
                super.onContentsChanged();
                XPVacuumBlockEntity.this.m_6596_();
            }
        };
    }
}

