/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity;

import com.enderio.api.capacitor.CapacitorModifier;
import com.enderio.api.capacitor.QuadraticScalable;
import com.enderio.api.grindingball.IGrindingBallData;
import com.enderio.api.io.energy.EnergyIOMode;
import com.enderio.base.common.util.GrindingBallManager;
import com.enderio.core.common.network.slot.IntegerNetworkDataSlot;
import com.enderio.core.common.network.slot.ResourceLocationNetworkDataSlot;
import com.enderio.machines.common.blockentity.base.PoweredMachineBlockEntity;
import com.enderio.machines.common.blockentity.task.PoweredCraftingMachineTask;
import com.enderio.machines.common.blockentity.task.host.CraftingMachineTaskHost;
import com.enderio.machines.common.config.MachinesConfig;
import com.enderio.machines.common.init.MachineRecipes;
import com.enderio.machines.common.io.item.MachineInventory;
import com.enderio.machines.common.io.item.MachineInventoryLayout;
import com.enderio.machines.common.io.item.MultiSlotAccess;
import com.enderio.machines.common.io.item.SingleSlotAccess;
import com.enderio.machines.common.menu.SagMillMenu;
import com.enderio.machines.common.recipe.RecipeCaches;
import com.enderio.machines.common.recipe.SagMillingRecipe;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class SagMillBlockEntity
extends PoweredMachineBlockEntity {
    public static final QuadraticScalable CAPACITY = new QuadraticScalable(CapacitorModifier.ENERGY_CAPACITY, (Supplier<Integer>)MachinesConfig.COMMON.ENERGY.SAG_MILL_CAPACITY);
    public static final QuadraticScalable USAGE = new QuadraticScalable(CapacitorModifier.ENERGY_USE, (Supplier<Integer>)MachinesConfig.COMMON.ENERGY.SAG_MILL_USAGE);
    public static final SingleSlotAccess INPUT = new SingleSlotAccess();
    public static final SingleSlotAccess GRINDING_BALL = new SingleSlotAccess();
    public static final MultiSlotAccess OUTPUT = new MultiSlotAccess();
    private IGrindingBallData grindingBallData = IGrindingBallData.IDENTITY;
    @Nullable
    private ResourceLocation pendingGrindingBallId;
    private int grindingBallDamage;
    private final CraftingMachineTaskHost<SagMillingRecipe, SagMillingRecipe.Container> craftingTaskHost;
    private static final String KEY_GRINDING_BALL_ID = "GrindingBallId";
    private static final String KEY_GRINDING_BALL_DAMAGE = "GrindingBallDamage";

    public SagMillBlockEntity(BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState) {
        super(EnergyIOMode.Input, CAPACITY, USAGE, type, worldPosition, blockState);
        this.addDataSlot(new IntegerNetworkDataSlot(() -> this.grindingBallDamage, i -> {
            this.grindingBallDamage = i;
        }));
        this.addDataSlot(new ResourceLocationNetworkDataSlot(() -> this.grindingBallData.getGrindingBallId(), gId -> {
            this.grindingBallData = GrindingBallManager.getData(gId);
        }));
        this.craftingTaskHost = new CraftingMachineTaskHost<SagMillingRecipe, SagMillingRecipe.Container>(this, this::hasEnergy, (RecipeType)MachineRecipes.SAG_MILLING.type().get(), new SagMillingRecipe.Container((IItemHandlerModifiable)this.getInventoryNN(), this::getGrindingBallData), this::createTask);
    }

    public IGrindingBallData getGrindingBallData() {
        return this.grindingBallData;
    }

    public void setGrindingBallData(IGrindingBallData data) {
        this.grindingBallDamage = 0;
        this.grindingBallData = data;
    }

    public float getGrindingBallDamage() {
        if (this.grindingBallData.getDurability() <= 0) {
            return 0.0f;
        }
        return 1.0f - (float)this.grindingBallDamage / (float)this.grindingBallData.getDurability();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new SagMillMenu(this, inventory, containerId);
    }

    @Override
    public void serverTick() {
        super.serverTick();
        if (this.canAct()) {
            this.craftingTaskHost.tick();
        }
    }

    public void onLoad() {
        super.onLoad();
        this.craftingTaskHost.onLevelReady();
        if (this.pendingGrindingBallId != null) {
            this.grindingBallData = GrindingBallManager.getData(this.pendingGrindingBallId);
        }
    }

    @Override
    public MachineInventoryLayout getInventoryLayout() {
        return MachineInventoryLayout.builder().inputSlot(this::isValidInput).slotAccess(INPUT).outputSlot(4).slotAccess(OUTPUT).inputSlot((slot, stack) -> GrindingBallManager.isGrindingBall(stack)).slotAccess(GRINDING_BALL).capacitor().build();
    }

    private boolean isValidInput(int index, ItemStack stack) {
        return RecipeCaches.SAG_MILLING.hasRecipe(List.of(stack));
    }

    @Override
    protected void onInventoryContentsChanged(int slot) {
        super.onInventoryContentsChanged(slot);
        this.craftingTaskHost.newTaskAvailable();
    }

    public float getCraftingProgress() {
        return this.craftingTaskHost.getProgress();
    }

    @Override
    protected boolean isActive() {
        return this.canAct() && this.hasEnergy() && this.craftingTaskHost.hasTask();
    }

    protected PoweredCraftingMachineTask<SagMillingRecipe, SagMillingRecipe.Container> createTask(Level level, SagMillingRecipe.Container container, @Nullable SagMillingRecipe recipe) {
        return new PoweredCraftingMachineTask<SagMillingRecipe, SagMillingRecipe.Container>(level, this.getInventoryNN(), this.getEnergyStorage(), container, OUTPUT, recipe){

            @Override
            protected void consumeInputs(SagMillingRecipe recipe) {
                ItemStack ball;
                MachineInventory inv = this.getInventory();
                INPUT.getItemStack(inv).m_41774_(1);
                if (recipe.getBonusType().useGrindingBall() && SagMillBlockEntity.this.grindingBallData == IGrindingBallData.IDENTITY && !(ball = GRINDING_BALL.getItemStack(inv)).m_41619_()) {
                    IGrindingBallData data = GrindingBallManager.getData(ball);
                    SagMillBlockEntity.this.setGrindingBallData(data);
                    if (data != IGrindingBallData.IDENTITY) {
                        ball.m_41774_(1);
                    }
                }
            }

            @Override
            protected int makeProgress(int remainingProgress) {
                int energyConsumed = super.makeProgress(remainingProgress);
                if (((SagMillingRecipe)this.getRecipe()).getBonusType().useGrindingBall()) {
                    SagMillBlockEntity.this.grindingBallDamage += energyConsumed;
                    if (SagMillBlockEntity.this.grindingBallDamage >= SagMillBlockEntity.this.grindingBallData.getDurability()) {
                        SagMillBlockEntity.this.setGrindingBallData(IGrindingBallData.IDENTITY);
                    }
                }
                return energyConsumed;
            }
        };
    }

    @Override
    public void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        this.craftingTaskHost.save(pTag);
        if (this.grindingBallData != IGrindingBallData.IDENTITY) {
            pTag.m_128359_(KEY_GRINDING_BALL_ID, this.grindingBallData.getGrindingBallId().toString());
            pTag.m_128405_(KEY_GRINDING_BALL_DAMAGE, this.grindingBallDamage);
        }
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.craftingTaskHost.load(pTag);
        if (pTag.m_128441_(KEY_GRINDING_BALL_ID)) {
            this.pendingGrindingBallId = new ResourceLocation(pTag.m_128461_(KEY_GRINDING_BALL_ID));
        }
        if (pTag.m_128441_(KEY_GRINDING_BALL_DAMAGE)) {
            this.grindingBallDamage = pTag.m_128451_(KEY_GRINDING_BALL_DAMAGE);
        }
    }
}

