/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.network.slot;

import com.enderio.core.common.network.slot.NetworkDataSlot;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class BooleanNetworkDataSlot
extends NetworkDataSlot<Boolean> {
    public BooleanNetworkDataSlot(Supplier<Boolean> getter, Consumer<Boolean> setter) {
        super(getter, setter);
    }

    @Override
    public Tag serializeValueNBT(Boolean value) {
        return ByteTag.m_128273_((boolean)value);
    }

    @Override
    protected Boolean valueFromNBT(Tag nbt) {
        if (nbt instanceof ByteTag) {
            ByteTag byteTag = (ByteTag)nbt;
            return byteTag.m_7063_() == 1;
        }
        throw new IllegalStateException("Invalid boolean tag was passed over the network.");
    }

    @Override
    public void toBuffer(FriendlyByteBuf buf, Boolean value) {
        buf.writeBoolean(value.booleanValue());
    }

    @Override
    public Boolean valueFromBuffer(FriendlyByteBuf buf) {
        try {
            return buf.readBoolean();
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalid boolean buffer was passed over the network.");
        }
    }
}

