/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.types;

import com.enderio.api.UseOnly;
import com.enderio.api.conduit.IClientConduitData;
import com.enderio.api.conduit.IConduitMenuData;
import com.enderio.api.conduit.IConduitType;
import com.enderio.api.conduit.IExtendedConduitData;
import com.enderio.api.conduit.ticker.IConduitTicker;
import com.enderio.api.misc.Vector2i;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.LogicalSide;

public class SimpleConduitType<T extends IExtendedConduitData<T>>
implements IConduitType<T> {
    private final ResourceLocation texture;
    private final IConduitTicker ticker;
    private final Supplier<T> extendedDataFactory;
    private final IClientConduitData<T> clientConduitData;
    private final IConduitMenuData menuData;

    public SimpleConduitType(ResourceLocation texture, IConduitTicker ticker, Supplier<T> extendedDataFactory, ResourceLocation iconTexture, Vector2i iconTexturePos, IConduitMenuData menuData) {
        this(texture, ticker, extendedDataFactory, new IClientConduitData.Simple(iconTexture, iconTexturePos), menuData);
    }

    public SimpleConduitType(ResourceLocation texture, IConduitTicker ticker, Supplier<T> extendedDataFactory, IClientConduitData<T> clientConduitData, IConduitMenuData menuData) {
        this.texture = texture;
        this.ticker = ticker;
        this.extendedDataFactory = extendedDataFactory;
        this.clientConduitData = clientConduitData;
        this.menuData = menuData;
    }

    @Override
    public ResourceLocation getTexture(T data) {
        return this.texture;
    }

    @Override
    public ResourceLocation getItemTexture() {
        return this.texture;
    }

    @Override
    public IConduitTicker getTicker() {
        return this.ticker;
    }

    @Override
    @UseOnly(value=LogicalSide.CLIENT)
    public IClientConduitData<T> getClientData() {
        return this.clientConduitData;
    }

    @Override
    public IConduitMenuData getMenuData() {
        return this.menuData;
    }

    @Override
    public T createExtendedConduitData(Level level, BlockPos pos) {
        return (T)((IExtendedConduitData)this.extendedDataFactory.get());
    }
}

