/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.menu;

import com.enderio.conduits.common.blockentity.ConduitBundle;
import com.enderio.conduits.common.blockentity.SlotData;
import com.enderio.conduits.common.blockentity.SlotType;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class ConduitSlot
extends SlotItemHandler {
    private final Supplier<Direction> visibleDirection;
    private final Supplier<Integer> visibleType;
    private final Direction visibleForDirection;
    private final int visibleForType;
    private final SlotType slotType;
    private final ConduitBundle bundle;

    public ConduitSlot(ConduitBundle bundle, IItemHandler itemHandler, Supplier<Direction> visibleDirection, Direction visibleForDirection, Supplier<Integer> visibleType, int visibleForType, SlotType slotType) {
        super(itemHandler, new SlotData(visibleForDirection, visibleForType, slotType).slotIndex(), slotType.getX(), slotType.getY());
        this.visibleDirection = visibleDirection;
        this.visibleType = visibleType;
        this.visibleForDirection = visibleForDirection;
        this.visibleForType = visibleForType;
        this.slotType = slotType;
        this.bundle = bundle;
    }

    public boolean m_5857_(ItemStack stack) {
        return this.isVisible() && super.m_5857_(stack);
    }

    public boolean m_8010_(Player playerIn) {
        return this.isVisible() && super.m_8010_(playerIn);
    }

    @NotNull
    public ItemStack m_6201_(int amount) {
        return this.isVisible() ? super.m_6201_(amount) : ItemStack.f_41583_;
    }

    public void updateVisibilityPosition() {
        if (this.isVisible()) {
            this.f_40220_ = this.slotType.getX();
            this.f_40221_ = this.slotType.getY();
        } else {
            this.f_40220_ = Integer.MIN_VALUE;
            this.f_40221_ = Integer.MIN_VALUE;
        }
    }

    private boolean isVisible() {
        return this.visibleDirection.get() == this.visibleForDirection && this.visibleType.get() == this.visibleForType && this.bundle.getTypes().size() > this.visibleForType && this.slotType.isAvailableFor(this.bundle.getTypes().get(this.visibleForType).getMenuData());
    }
}

