/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.integrations.ae2;

import appeng.api.implementations.items.IFacadeItem;
import appeng.api.networking.IInWorldGridNodeHost;
import com.enderio.EnderIO;
import com.enderio.api.conduit.ConduitItemFactory;
import com.enderio.api.conduit.ConduitTypes;
import com.enderio.api.conduit.IConduitType;
import com.enderio.api.integration.Integration;
import com.enderio.base.common.init.EIOCreativeTabs;
import com.enderio.conduits.common.integrations.ae2.AE2ConduitType;
import com.tterrag.registrate.util.entry.ItemEntry;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.registries.RegistryObject;

public class AE2Integration
implements Integration {
    private final Capability<IInWorldGridNodeHost> IN_WORLD_GRID_NODE_HOST = CapabilityManager.get((CapabilityToken)new CapabilityToken<IInWorldGridNodeHost>(){});
    private static final RegistryObject<AE2ConduitType> DENSE = ConduitTypes.CONDUIT_TYPES.register("dense_me", () -> new AE2ConduitType(true));
    private static final RegistryObject<AE2ConduitType> NORMAL = ConduitTypes.CONDUIT_TYPES.register("me", () -> new AE2ConduitType(false));
    public static final ItemEntry<Item> DENSE_ITEM = AE2Integration.createConduitItem(DENSE, "dense_me", "Dense ME Conduit");
    public static final ItemEntry<Item> NORMAL_ITEM = AE2Integration.createConduitItem(NORMAL, "me", "ME Conduit");

    @Override
    public void onModConstruct() {
    }

    @Override
    public Optional<BlockState> getFacadeOf(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof IFacadeItem) {
            IFacadeItem facadeItem = (IFacadeItem)item;
            return Optional.of(facadeItem.getTextureBlockState(stack));
        }
        return Optional.empty();
    }

    public Capability<IInWorldGridNodeHost> getInWorldGridNodeHost() {
        return this.IN_WORLD_GRID_NODE_HOST;
    }

    private static ItemEntry<Item> createConduitItem(Supplier<? extends IConduitType<?>> type, String itemName, String english) {
        return EnderIO.registrate().item(itemName + "_conduit", properties -> ConduitItemFactory.build(type, properties)).tab(EIOCreativeTabs.CONDUITS).lang(english).model((ctx, prov) -> ((ItemModelBuilder)prov.withExistingParent(itemName + "_conduit", EnderIO.loc("item/conduit"))).texture("0", ((IConduitType)type.get()).getItemTexture())).register();
    }
}

