/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.blockentity;

import com.enderio.api.conduit.ConduitTypes;
import com.enderio.api.conduit.IConduitType;
import com.enderio.api.conduit.TieredConduit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConduitTypeSorter {
    private static final List<IConduitType<?>> SORTED_TYPES = new ArrayList();

    @SubscribeEvent
    public static void afterRegistryFreeze(FMLCommonSetupEvent event) {
        ForgeRegistry<IConduitType<?>> registry = ConduitTypes.getRegistry();
        ArrayList<ResourceLocation> tieredTypes = new ArrayList<ResourceLocation>();
        for (IConduitType value : registry.getValues()) {
            TieredConduit tiered;
            if (!(value instanceof TieredConduit) || tieredTypes.contains((tiered = (TieredConduit)value).getType())) continue;
            tieredTypes.add(tiered.getType());
        }
        tieredTypes.sort(ResourceLocation::compareTo);
        for (ResourceLocation tieredType : tieredTypes) {
            ArrayList<IConduitType> typesInType = new ArrayList<IConduitType>();
            for (IConduitType type : registry.getValues()) {
                TieredConduit tiered;
                if (!(type instanceof TieredConduit) || !(tiered = (TieredConduit)type).getType().equals((Object)tieredType)) continue;
                typesInType.add(type);
            }
            typesInType.sort(Comparator.comparing(arg_0 -> registry.getKey(arg_0)));
            SORTED_TYPES.addAll(typesInType);
        }
        ArrayList<IConduitType> unadded = new ArrayList<IConduitType>();
        for (IConduitType type : registry.getValues()) {
            if (type instanceof TieredConduit) continue;
            unadded.add(type);
        }
        unadded.sort(Comparator.comparing(arg_0 -> registry.getKey(arg_0)));
        SORTED_TYPES.addAll(unadded);
    }

    public static int getSortIndex(IConduitType<?> type) {
        return SORTED_TYPES.indexOf(type);
    }
}

