/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.api.capability;

import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.util.INBTSerializable;

public class StoredEntityData
implements INBTSerializable<Tag> {
    private CompoundTag entityTag = new CompoundTag();
    private float maxHealth = 0.0f;
    public static final String KEY_ID = "id";
    public static final String KEY_ENTITY = "Entity";
    private static final String KEY_HEALTH = "Health";
    private static final String KEY_MAX_HEALTH = "MaxHealth";

    public static StoredEntityData of(LivingEntity entity) {
        StoredEntityData data = new StoredEntityData();
        data.entityTag = entity.serializeNBT();
        data.maxHealth = entity.m_21233_();
        return data;
    }

    public static StoredEntityData of(ResourceLocation entityType) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_(KEY_ID, entityType.toString());
        StoredEntityData data = new StoredEntityData();
        data.entityTag = tag;
        data.maxHealth = 0.0f;
        return data;
    }

    public static StoredEntityData empty() {
        StoredEntityData data = new StoredEntityData();
        data.maxHealth = 0.0f;
        return data;
    }

    public Optional<ResourceLocation> getEntityType() {
        CompoundTag tag = this.entityTag;
        if (tag.m_128441_(KEY_ID)) {
            return Optional.of(new ResourceLocation(tag.m_128461_(KEY_ID)));
        }
        return Optional.empty();
    }

    public CompoundTag getEntityTag() {
        return this.entityTag;
    }

    public Optional<Tuple<Float, Float>> getHealthState() {
        CompoundTag tag;
        if (this.maxHealth > 0.0f && (tag = this.entityTag).m_128441_(KEY_HEALTH)) {
            return Optional.of(new Tuple((Object)Float.valueOf(tag.m_128457_(KEY_HEALTH)), (Object)Float.valueOf(this.maxHealth)));
        }
        return Optional.empty();
    }

    public Tag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_(KEY_ENTITY, (Tag)this.entityTag);
        if (this.maxHealth > 0.0f) {
            compound.m_128350_(KEY_MAX_HEALTH, this.maxHealth);
        }
        return compound;
    }

    public void deserializeNBT(Tag tag) {
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            this.entityTag = compoundTag.m_128469_(KEY_ENTITY);
            if (compoundTag.m_128441_(KEY_MAX_HEALTH)) {
                this.maxHealth = compoundTag.m_128457_(KEY_MAX_HEALTH);
            }
        }
    }
}

