/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.util;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.fluid.FluidBiomassHolder;
import com.lothrazar.cyclic.fluid.FluidHoneyHolder;
import com.lothrazar.cyclic.fluid.FluidMagmaHolder;
import com.lothrazar.cyclic.fluid.FluidSlimeHolder;
import com.lothrazar.cyclic.fluid.FluidXpJuiceHolder;
import com.lothrazar.library.data.Model3D;
import com.lothrazar.library.render.FluidRenderMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FluidHelpers {
    private static final int COLOUR_DEFAULT = 11393254;
    private static final int COLOUR_MILK = 0xF1F1F1;
    private static final int COLOUR_LAVA = 16747520;
    public static final FluidRenderMap<Int2ObjectMap<Model3D>> CACHED_FLUIDS = new FluidRenderMap();
    public static final int STAGES = 1400;

    public static int getColorFromFluid(FluidStack fstack) {
        if (fstack != null && fstack.getFluid() != null) {
            if (fstack.getFluid() == FluidBiomassHolder.STILL.get()) {
                return 7494972;
            }
            if (fstack.getFluid() == FluidHoneyHolder.STILL.get()) {
                return 16764509;
            }
            if (fstack.getFluid() == FluidMagmaHolder.STILL.get()) {
                return 4924959;
            }
            if (fstack.getFluid() == FluidSlimeHolder.STILL.get()) {
                return 5349438;
            }
            if (fstack.getFluid() == FluidXpJuiceHolder.STILL.get()) {
                return 2293571;
            }
            if (fstack.getFluid() == ForgeMod.MILK.get()) {
                return 0xF1F1F1;
            }
            if (fstack.getFluid() == Fluids.f_76195_) {
                return 16747520;
            }
        }
        return 11393254;
    }

    public static void extractSourceWaterloggedCauldron(Level level, BlockPos posTarget, IFluidHandler tank) {
        int simFill;
        if (tank == null) {
            return;
        }
        BlockState targetState = level.m_8055_(posTarget);
        FluidState fluidState = level.m_6425_(posTarget);
        if (targetState.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)targetState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            int simFill2 = tank.fill(new FluidStack(new FluidStack((Fluid)Fluids.f_76193_, 1000), 1000), IFluidHandler.FluidAction.SIMULATE);
            if (simFill2 == 1000 && level.m_46597_(posTarget, (BlockState)targetState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)))) {
                tank.fill(new FluidStack((Fluid)Fluids.f_76193_, 1000), IFluidHandler.FluidAction.EXECUTE);
            }
        } else if (targetState.m_60734_() == Blocks.f_152476_) {
            int simFill3 = tank.fill(new FluidStack(new FluidStack((Fluid)Fluids.f_76193_, 1000), 1000), IFluidHandler.FluidAction.SIMULATE);
            if (simFill3 == 1000 && level.m_46597_(posTarget, Blocks.f_50256_.m_49966_())) {
                tank.fill(new FluidStack(new FluidStack((Fluid)Fluids.f_76193_, 1000), 1000), IFluidHandler.FluidAction.EXECUTE);
            }
        } else if (targetState.m_60734_() == Blocks.f_152477_) {
            int simFill4 = tank.fill(new FluidStack(new FluidStack((Fluid)Fluids.f_76195_, 1000), 1000), IFluidHandler.FluidAction.SIMULATE);
            if (simFill4 == 1000 && level.m_46597_(posTarget, Blocks.f_50256_.m_49966_())) {
                tank.fill(new FluidStack(new FluidStack((Fluid)Fluids.f_76195_, 1000), 1000), IFluidHandler.FluidAction.EXECUTE);
            }
        } else if (fluidState != null && fluidState.m_76170_() && fluidState.m_76152_() != null && (simFill = tank.fill(new FluidStack(new FluidStack(fluidState.m_76152_(), 1000), 1000), IFluidHandler.FluidAction.SIMULATE)) == 1000 && level.m_46597_(posTarget, Blocks.f_50016_.m_49966_())) {
            tank.fill(new FluidStack(fluidState.m_76152_(), 1000), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public static TextureAtlasSprite getBaseFluidTexture(Fluid fluid, FluidRenderMap.FluidFlow type) {
        return FluidRenderMap.getFluidTexture((FluidStack)new FluidStack(fluid, 1), (FluidRenderMap.FluidFlow)type);
    }

    public static TextureAtlasSprite getSprite(ResourceLocation spriteLocation) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(spriteLocation);
    }

    public static Model3D getFluidModel(FluidStack fluid, int stage) {
        if (CACHED_FLUIDS.containsKey((Object)fluid) && ((Int2ObjectMap)CACHED_FLUIDS.get((Object)fluid)).containsKey(stage)) {
            return (Model3D)((Int2ObjectMap)CACHED_FLUIDS.get((Object)fluid)).get(stage);
        }
        Model3D model = new Model3D();
        model.setTexture(FluidRenderMap.getFluidTexture((FluidStack)fluid, (FluidRenderMap.FluidFlow)FluidRenderMap.FluidFlow.STILL));
        if (IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getStillTexture(fluid) != null) {
            double sideSpacing = 0.00625;
            double belowSpacing = 0.015625;
            model.minX = sideSpacing;
            model.minY = belowSpacing;
            model.minZ = sideSpacing;
            model.maxX = 1.0 - sideSpacing;
            model.maxY = 1.0 - belowSpacing;
            model.maxZ = 1.0 - sideSpacing;
        }
        if (CACHED_FLUIDS.containsKey((Object)fluid)) {
            ((Int2ObjectMap)CACHED_FLUIDS.get((Object)fluid)).put(stage, (Object)model);
        } else {
            Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
            map.put(stage, (Object)model);
            CACHED_FLUIDS.put((Object)fluid, (Object)map);
        }
        return model;
    }

    public static float getScale(FluidTank tank) {
        return FluidHelpers.getScale(tank.getFluidAmount(), tank.getCapacity(), tank.isEmpty());
    }

    public static float getScale(int stored, int capacity, boolean empty) {
        float targetScale = (float)stored / (float)capacity;
        return targetScale;
    }

    public static IFluidHandler getTank(Level world, BlockPos pos, Direction side) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile == null) {
            return null;
        }
        return (IFluidHandler)tile.getCapability(ForgeCapabilities.FLUID_HANDLER, side).orElse(null);
    }

    public static boolean tryFillPositionFromTank(Level world, BlockPos posSide, Direction sideOpp, IFluidHandler tankFrom, int amount) {
        if (tankFrom == null || amount <= 0) {
            return false;
        }
        try {
            IFluidHandler fluidTo = (IFluidHandler)FluidUtil.getFluidHandler((Level)world, (BlockPos)posSide, (Direction)sideOpp).orElse(null);
            if (fluidTo == null) {
                return false;
            }
            FluidStack toBeDrained = tankFrom.drain(amount, IFluidHandler.FluidAction.SIMULATE);
            if (toBeDrained == null || toBeDrained.isEmpty()) {
                return false;
            }
            int filledAmount = fluidTo.fill(toBeDrained, IFluidHandler.FluidAction.EXECUTE);
            if (filledAmount <= 0) {
                return false;
            }
            FluidStack drained = tankFrom.drain(filledAmount, IFluidHandler.FluidAction.EXECUTE);
            int drainedAmount = drained.getAmount();
            if (filledAmount != drainedAmount) {
                ModCyclic.LOGGER.error("Imbalance filling fluids, filled " + filledAmount + " drained " + drainedAmount);
            }
            return true;
        }
        catch (Exception e) {
            ModCyclic.LOGGER.error("A fluid tank had an issue when we tried to fill", e);
            return false;
        }
    }

    public static class FluidAttributes {
        public static final int BUCKET_VOLUME = 1000;
    }
}

