/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.net;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.library.packet.PacketFlib;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketTileData
extends PacketFlib {
    private int field;
    private int value;
    private BlockPos pos;
    private boolean autoIncrement = false;

    public PacketTileData(int field, BlockPos pos) {
        this.field = field;
        this.value = -1;
        this.autoIncrement = true;
        this.pos = pos;
    }

    public PacketTileData(int field, int value, BlockPos pos) {
        this.field = field;
        this.value = value;
        this.autoIncrement = false;
        this.pos = pos;
    }

    public PacketTileData(int field, boolean value, BlockPos pos) {
        this(field, value ? 1 : 0, pos);
    }

    public PacketTileData() {
    }

    public static void handle(PacketTileData message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            Level world = player.m_20193_();
            BlockEntity tile = world.m_7702_(message.pos);
            if (tile instanceof TileBlockEntityCyclic) {
                TileBlockEntityCyclic base = (TileBlockEntityCyclic)tile;
                if (message.autoIncrement) {
                    int incr = base.getField(message.field) + 1;
                    base.setField(message.field, incr);
                } else {
                    base.setField(message.field, message.value);
                }
                base.m_6596_();
            }
        });
        message.done(ctx);
    }

    public static PacketTileData decode(FriendlyByteBuf buf) {
        PacketTileData p = new PacketTileData();
        p.field = buf.readInt();
        p.value = buf.readInt();
        CompoundTag tags = buf.m_130260_();
        p.pos = new BlockPos(tags.m_128451_("x"), tags.m_128451_("y"), tags.m_128451_("z"));
        p.autoIncrement = buf.readBoolean();
        return p;
    }

    public static void encode(PacketTileData msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.field);
        buf.writeInt(msg.value);
        CompoundTag tags = new CompoundTag();
        tags.m_128405_("x", msg.pos.m_123341_());
        tags.m_128405_("y", msg.pos.m_123342_());
        tags.m_128405_("z", msg.pos.m_123343_());
        buf.m_130079_(tags);
        buf.writeBoolean(msg.autoIncrement);
    }
}

