/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.net;

import com.lothrazar.cyclic.data.CraftingActionEnum;
import com.lothrazar.cyclic.data.IContainerCraftingAction;
import com.lothrazar.library.packet.PacketFlib;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketCraftAction
extends PacketFlib {
    private CraftingActionEnum action;

    public PacketCraftAction(CraftingActionEnum s) {
        this.action = s;
    }

    public static PacketCraftAction decode(FriendlyByteBuf buf) {
        return new PacketCraftAction(CraftingActionEnum.values()[buf.readInt()]);
    }

    public static void encode(PacketCraftAction msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.action.ordinal());
    }

    public static void handle(PacketCraftAction message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender.f_36096_ instanceof IContainerCraftingAction) {
                IContainerCraftingAction c = (IContainerCraftingAction)sender.f_36096_;
                PacketCraftAction.performAction(c, (Player)sender, message.action);
            }
        });
        message.done(ctx);
    }

    private static void performAction(IContainerCraftingAction c, Player player, CraftingActionEnum action) {
        switch (action) {
            case EMPTY: {
                for (int i = 1; i <= 9; ++i) {
                    c.transferStack(player, i);
                }
                c.getCraftResult().m_6211_();
                break;
            }
            case SPREAD: {
                PacketCraftAction.balanceLargestSlot(c, false);
                break;
            }
            case SPREADMATCH: {
                PacketCraftAction.balanceLargestSlot(c, true);
            }
        }
    }

    private static void balanceLargestSlot(IContainerCraftingAction c, boolean onlyExisting) {
        ItemStack biggest = ItemStack.f_41583_;
        int foundSlot = -1;
        for (int i = 0; i <= 8; ++i) {
            ItemStack tmp = c.getCraftMatrix().m_8020_(i);
            if (tmp.m_41619_() || tmp.m_41613_() <= biggest.m_41613_()) continue;
            foundSlot = i;
            biggest = tmp;
        }
        if (biggest.m_41619_()) {
            return;
        }
        HashSet<Integer> slotTargest = new HashSet<Integer>();
        int totalQuantity = 0;
        for (int i = 0; i <= 8; ++i) {
            ItemStack tmp = c.getCraftMatrix().m_8020_(i);
            if (tmp.m_41619_() && !onlyExisting) {
                slotTargest.add(i);
            }
            if (!ItemStack.m_150942_((ItemStack)tmp, (ItemStack)biggest)) continue;
            slotTargest.add(i);
            totalQuantity += tmp.m_41613_();
        }
        int slotsUsedForBalancing = slotTargest.size();
        int avg = totalQuantity / slotsUsedForBalancing;
        int remainder = totalQuantity % slotsUsedForBalancing;
        if (avg == 0) {
            return;
        }
        Iterator iterator = slotTargest.iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            int size = slot == foundSlot ? avg + remainder : avg;
            ItemStack copy = biggest.m_41777_();
            copy.m_41764_(size);
            c.getCraftMatrix().m_6836_(slot, copy);
        }
    }
}

