/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.elemental;

import com.lothrazar.cyclic.block.fishing.TileFisher;
import com.lothrazar.cyclic.registry.EntityRegistry;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.registry.PotionEffectRegistry;
import com.lothrazar.library.util.ItemStackUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class FishingEnderEntity
extends ThrowableItemProjectile {
    public FishingEnderEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public FishingEnderEntity(LivingEntity livingEntityIn, Level worldIn) {
        super((EntityType)EntityRegistry.ENDER_FISHING.get(), livingEntityIn, worldIn);
    }

    protected Item m_7881_() {
        return (Item)ItemRegistry.ENDER_FISHING.get();
    }

    protected void m_6532_(HitResult result) {
        HitResult.Type type = result.m_6662_();
        Level level = this.m_9236_();
        if (type == HitResult.Type.ENTITY) {
            EntityHitResult entityRayTrace = (EntityHitResult)result;
            Entity target = entityRayTrace.m_82443_();
            if (target.m_6084_() && target instanceof LivingEntity) {
                LivingEntity alive = (LivingEntity)target;
                alive.m_7292_(new MobEffectInstance((MobEffect)PotionEffectRegistry.SWIMSPEED.get(), 60, 2));
                target.m_6469_(level.m_269111_().m_269390_((Entity)this, this.m_19749_()), 0.0f);
            }
        } else if (type == HitResult.Type.BLOCK) {
            BlockHitResult ray = (BlockHitResult)result;
            if (ray.m_82425_() == null) {
                return;
            }
            BlockPos pos = ray.m_82425_();
            if (ray.m_82434_() != null) {
                pos = pos.m_121945_(ray.m_82434_());
            }
            if (TileFisher.isWater(level, pos) && !level.f_46443_) {
                LootDataManager manager = level.m_7654_().m_278653_();
                if (manager == null) {
                    return;
                }
                LootTable table = null;
                table = level.f_46441_.m_188500_() < 0.1 ? (LootTable)manager.m_278789_(LootDataType.f_278413_, BuiltInLootTables.f_78721_) : (LootTable)manager.m_278789_(LootDataType.f_278413_, BuiltInLootTables.f_78723_);
                if (table == null) {
                    return;
                }
                int luck = 2;
                ItemStack fishingRod = new ItemStack((ItemLike)Items.f_42523_);
                fishingRod.m_41663_(Enchantments.f_44953_, 2);
                LootParams lootContext = new LootParams.Builder((ServerLevel)level).m_287239_(2.0f).m_287286_(LootContextParams.f_81460_, (Object)new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())).m_287286_(LootContextParams.f_81463_, (Object)fishingRod).m_287235_(LootContextParamSets.f_81414_);
                ObjectArrayList lootDrops = table.m_287195_(lootContext);
                if (lootDrops != null && lootDrops.size() > 0) {
                    ItemStackUtil.drop((Level)level, (BlockPos)pos, (List)lootDrops);
                }
            }
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

