/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.datacard;

import com.lothrazar.cyclic.item.ItemBaseCyclic;
import com.lothrazar.cyclic.item.datacard.BlockStateMatcher;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockstateCard
extends ItemBaseCyclic {
    private static final String EXACT_TAG = "doExactState";
    private static final String STATESTAG = "states";
    private static final int MAXSIZE = 18;

    public BlockstateCard(Item.Properties properties) {
        super(properties);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack held, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (held.m_41783_() != null && held.m_41783_().m_128441_(STATESTAG)) {
            for (BlockStateMatcher m : BlockstateCard.getSavedStates(worldIn, held)) {
                BlockState st = m.getState();
                ChatFormatting c = m.isExactProperties() ? ChatFormatting.LIGHT_PURPLE : ChatFormatting.DARK_PURPLE;
                String extra = m.isExactProperties() ? " [state]" : " [block]";
                tooltip.add((Component)Component.m_237115_((String)st.m_60734_().m_7705_()).m_130946_(extra).m_130940_(c));
                if (!m.isExactProperties() || !Screen.m_96638_()) continue;
                tooltip.add((Component)Component.m_237115_((String)st.toString()).m_130940_(ChatFormatting.DARK_GRAY));
            }
        } else {
            super.m_7373_(held, worldIn, tooltip, flagIn);
        }
    }

    public static List<BlockStateMatcher> getSavedStates(Level worldIn, ItemStack held) {
        ArrayList<BlockStateMatcher> st = new ArrayList<BlockStateMatcher>();
        if (held.m_41783_() != null && held.m_41783_().m_128441_(STATESTAG)) {
            ListTag stateTags = held.m_41783_().m_128437_(STATESTAG, 10);
            for (int i = 0; i < stateTags.size(); ++i) {
                CompoundTag currTag = stateTags.m_128728_(i);
                BlockState stateFound = NbtUtils.m_247651_((HolderGetter)worldIn.m_246945_(Registries.f_256747_), (CompoundTag)currTag);
                if (stateFound == null || stateFound.m_60795_()) continue;
                BlockStateMatcher matcher = new BlockStateMatcher();
                matcher.setState(stateFound);
                if (currTag.m_128441_(EXACT_TAG)) {
                    matcher.setExactProperties(currTag.m_128471_(EXACT_TAG));
                }
                st.add(matcher);
            }
        }
        return st;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        BlockPos pos = context.m_8083_();
        ItemStack held = player.m_21120_(hand);
        BlockState state = context.m_43725_().m_8055_(pos);
        CompoundTag stateTag = NbtUtils.m_129202_((BlockState)state);
        ListTag stateTags = null;
        stateTags = held.m_41784_().m_128441_(STATESTAG) ? held.m_41784_().m_128437_(STATESTAG, 10) : new ListTag();
        if (stateTags.size() >= 18) {
            return InteractionResult.PASS;
        }
        for (int i = 0; i < stateTags.size(); ++i) {
            BlockState stateFound = NbtUtils.m_247651_((HolderGetter)player.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)stateTags.m_128728_(i));
            if (!stateFound.equals(state)) continue;
            return InteractionResult.PASS;
        }
        stateTag.m_128379_(EXACT_TAG, !player.m_6047_());
        stateTags.add((Object)stateTag);
        held.m_41784_().m_128365_(STATESTAG, (Tag)stateTags);
        player.m_6674_(hand);
        return InteractionResult.SUCCESS;
    }
}

