/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.event;

import com.lothrazar.cyclic.config.ClientConfigCyclic;
import com.lothrazar.cyclic.event.PlayerDataEvents;
import com.lothrazar.cyclic.filesystem.CyclicFile;
import com.lothrazar.cyclic.item.LaserItem;
import com.lothrazar.cyclic.item.OreProspector;
import com.lothrazar.cyclic.item.builder.BuilderActionType;
import com.lothrazar.cyclic.item.builder.BuilderItem;
import com.lothrazar.cyclic.item.builder.PacketSwapBlock;
import com.lothrazar.cyclic.item.datacard.LocationGpsCard;
import com.lothrazar.cyclic.item.datacard.ShapeCard;
import com.lothrazar.cyclic.item.random.RandomizerItem;
import com.lothrazar.cyclic.net.PacketEntityLaser;
import com.lothrazar.cyclic.registry.PacketRegistry;
import com.lothrazar.cyclic.registry.SoundRegistry;
import com.lothrazar.library.core.BlockPosDim;
import com.lothrazar.library.data.RelativeShape;
import com.lothrazar.library.render.RenderEntityToBlockLaser;
import com.lothrazar.library.util.LevelWorldUtil;
import com.lothrazar.library.util.PlayerUtil;
import com.lothrazar.library.util.RenderBlockUtils;
import com.lothrazar.library.util.RenderUtil;
import com.lothrazar.library.util.SoundUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventRender {
    @SubscribeEvent
    public static void onCustomizeDebugText(CustomizeGuiOverlayEvent.DebugText event) {
        BlockState targetState;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Level level = player.m_9236_();
        Minecraft mc = Minecraft.m_91087_();
        ItemStack itemStackHeld = BuilderItem.getIfHeld((Player)player);
        if (itemStackHeld.m_41720_() instanceof BuilderItem && (targetState = BuilderActionType.getBlockState(level, itemStackHeld)) != null) {
            RenderUtil.drawStack((GuiGraphics)event.getGuiGraphics(), (ItemStack)new ItemStack((ItemLike)targetState.m_60734_()));
            int slot = PlayerUtil.getFirstSlotWithBlock((Player)player, (BlockState)targetState);
            if (slot < 0) {
                int width = mc.m_91268_().m_85445_();
                int height = mc.m_91268_().m_85446_();
                RenderUtil.drawString((GuiGraphics)event.getGuiGraphics(), (String)"0", (int)(width / 2 + 16), (int)(height / 2 + 12));
            }
        }
        int height = mc.m_91268_().m_85446_();
        CyclicFile datFile = PlayerDataEvents.getOrCreate((Player)player);
        if (datFile.spectatorTicks > 0) {
            int sec = datFile.spectatorTicks / 20;
            RenderUtil.drawString((GuiGraphics)event.getGuiGraphics(), (String)("noClip " + sec), (int)10, (int)(height - 10));
        }
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderLevelStageEvent event) {
        Object shape;
        BlockPosDim loc;
        BlockHitResult lookingAt;
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        Level world = player.m_9236_();
        ItemStack stack = ItemStack.f_41583_;
        ArrayList<BlockPos> putBoxHere = new ArrayList<BlockPos>();
        stack = OreProspector.getIfHeld((Player)player);
        if (stack.m_41720_() instanceof OreProspector) {
            ArrayList<BlockPosDim> coords = OreProspector.getPosition(stack);
            for (BlockPosDim loc2 : coords) {
                if (loc2 == null || loc2.getDimension() != null && !loc2.getDimension().equalsIgnoreCase(LevelWorldUtil.dimensionToString((Level)world))) continue;
                RenderBlockUtils.createBox((PoseStack)event.getPoseStack(), (BlockPos)loc2.getPos());
                putBoxHere.add(loc2.getPos());
            }
        }
        double range = 6.0;
        float alpha = 1.0f;
        HashMap<BlockPos, Color> renderCubes = new HashMap<BlockPos, Color>();
        stack = BuilderItem.getIfHeld((Player)player);
        if (stack.m_41720_() instanceof BuilderItem && !world.m_46859_((lookingAt = (BlockHitResult)player.m_19907_(range, 0.0f, false)).m_82425_())) {
            BlockPos pos = lookingAt.m_82425_();
            Object buildStyle = ((BuilderItem)stack.m_41720_()).style;
            if (buildStyle.isOffset() && lookingAt.m_82434_() != null) {
                pos = pos.m_121945_(lookingAt.m_82434_());
            }
            alpha = 0.01f;
            List<BlockPos> coordinates = PacketSwapBlock.getSelectedBlocks(world, pos, BuilderItem.getActionType(stack), lookingAt.m_82434_(), buildStyle);
            for (BlockPos coordinate : coordinates) {
                putBoxHere.add(coordinate);
            }
        }
        if ((stack = RandomizerItem.getIfHeld((Player)player)).m_41720_() instanceof RandomizerItem) {
            lookingAt = RenderBlockUtils.getLookingAt((Player)player, (int)((int)range));
            if (world.m_8055_(lookingAt.m_82425_()).m_60795_()) {
                return;
            }
            List<BlockPos> coords = RandomizerItem.getPlaces(lookingAt.m_82425_(), lookingAt.m_82434_());
            for (BlockPos e : coords) {
                BlockState stHere = world.m_8055_(e);
                if (!RandomizerItem.canMove(stHere, world, e) && !stHere.m_60795_()) {
                    renderCubes.put(e, Color.RED);
                    continue;
                }
                if (stHere.m_60795_()) continue;
                putBoxHere.add(e);
            }
        }
        if ((stack = player.m_21205_()).m_41720_() instanceof LocationGpsCard && (loc = LocationGpsCard.getPosition(stack)) != null && (loc.getDimension() == null || loc.getDimension().equalsIgnoreCase(LevelWorldUtil.dimensionToString((Level)world)))) {
            renderCubes.put(loc.getPos(), ClientConfigCyclic.getColor(stack));
        }
        if (stack.m_41720_() instanceof ShapeCard && (shape = RelativeShape.read((ItemStack)stack)) != null) {
            BlockPos here = player.m_20183_();
            for (BlockPos s : shape.getShape()) {
                putBoxHere.add(here.m_121955_((Vec3i)s));
            }
        }
        for (BlockPos coordinate : putBoxHere) {
            RenderBlockUtils.createBox((PoseStack)event.getPoseStack(), (BlockPos)coordinate);
        }
        if (renderCubes.keySet().size() > 0) {
            float scale = 1.0f;
            PoseStack matrix = event.getPoseStack();
            Vec3 view = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            RenderBlockUtils.renderColourCubes((PoseStack)matrix, (Vec3)view, renderCubes, (float)scale, (float)alpha);
        }
        if (!(stack = LaserItem.getIfHeld((Player)player)).m_41619_() && player.m_6117_()) {
            IEnergyStorage storage = (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY, null).orElse(null);
            if (storage == null || storage.getEnergyStored() < 50) {
                return;
            }
            if (mc.f_91076_ != null) {
                RenderEntityToBlockLaser.renderLaser((RenderLevelStageEvent)event, (Player)player, (float)mc.m_91296_(), (ItemStack)stack, (InteractionHand)InteractionHand.MAIN_HAND, (int)18, (float)-0.02f);
                if (world.m_46467_() % 4L == 0L) {
                    PacketRegistry.INSTANCE.sendToServer((Object)new PacketEntityLaser(mc.f_91076_.m_19879_(), true));
                    SoundUtil.playSound((Entity)player, (SoundEvent)((SoundEvent)SoundRegistry.LASERBEANPEW.get()), (float)0.2f);
                }
            } else {
                BlockHitResult miss;
                Vec3 entityHitResultLocation;
                double distance;
                AABB aabb;
                Vec3 cameraEyeViewRay;
                double laserGamemodeRange = (double)mc.f_91072_.m_105286_() * 8.0;
                Entity camera = mc.m_91288_();
                Vec3 cameraViewVector = camera.m_20252_(1.0f);
                Vec3 cameraEyePosition = camera.m_20299_(1.0f);
                EntityHitResult ehr = ProjectileUtil.m_37287_((Entity)camera, (Vec3)cameraEyePosition, (Vec3)(cameraEyeViewRay = cameraEyePosition.m_82520_(cameraViewVector.f_82479_ * laserGamemodeRange, cameraViewVector.f_82480_ * laserGamemodeRange, cameraViewVector.f_82481_ * laserGamemodeRange)), (AABB)(aabb = camera.m_20191_().m_82369_(cameraViewVector.m_82490_(laserGamemodeRange)).m_82377_(1.0, 1.0, 1.0)), ent -> ent.m_6097_() && ent.m_6084_(), (double)0.0);
                if (ehr != null && (distance = Math.sqrt(cameraEyePosition.m_82557_(entityHitResultLocation = ehr.m_82450_()))) < 6000.0 && (miss = mc.f_91073_.m_45547_(new ClipContext(cameraEyePosition, entityHitResultLocation, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)mc.f_91074_))).m_6662_() != HitResult.Type.BLOCK) {
                    RenderEntityToBlockLaser.renderLaser((RenderLevelStageEvent)event, (Player)player, (float)mc.m_91296_(), (ItemStack)stack, (InteractionHand)InteractionHand.MAIN_HAND);
                    if (world.m_46467_() % 4L == 0L) {
                        PacketRegistry.INSTANCE.sendToServer((Object)new PacketEntityLaser(ehr.m_82443_().m_19879_(), false));
                        SoundUtil.playSound((Entity)player, (SoundEvent)((SoundEvent)SoundRegistry.LASERBEANPEW.get()), (float)0.2f);
                    }
                }
            }
        }
    }
}

