/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.spikes;

import com.lothrazar.cyclic.block.BlockCyclic;
import com.lothrazar.cyclic.block.spikes.EnumSpikeType;
import com.lothrazar.cyclic.registry.SoundRegistry;
import com.lothrazar.library.util.SoundUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SpikesBlock
extends BlockCyclic
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final double CURSE_CHANCE = 0.2;
    public static final int CURSE_TIME = 160;
    public static final int FIRE_TIME = 20;
    public static final BooleanProperty ACTIVATED = BooleanProperty.m_61465_((String)"lit");
    private static final float LARGE = 0.9375f;
    private static final float SMALL = 0.0625f;
    private static final VoxelShape NORTH_BOX = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)15.0, (double)15.0, (double)16.0);
    private static final VoxelShape SOUTH_BOX = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)15.0, (double)0.9375);
    private static final VoxelShape EAST_BOX = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.9375, (double)15.0, (double)15.0);
    private static final VoxelShape WEST_BOX = Block.m_49796_((double)0.9375, (double)0.0, (double)0.0, (double)15.0, (double)15.0, (double)15.0);
    private static final VoxelShape UP_BOX = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)0.9375, (double)15.0);
    private static final VoxelShape DOWN_BOX = Block.m_49796_((double)0.0, (double)0.9375, (double)0.0, (double)15.0, (double)15.0, (double)15.0);
    private EnumSpikeType type;

    public SpikesBlock(BlockBehaviour.Properties properties, EnumSpikeType type) {
        super(properties.m_60978_(1.1f).m_60955_().m_60910_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.type = type;
    }

    @Deprecated
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)) {
            case NORTH: {
                return NORTH_BOX;
            }
            case EAST: {
                return EAST_BOX;
            }
            case SOUTH: {
                return SOUTH_BOX;
            }
            case WEST: {
                return WEST_BOX;
            }
            case UP: {
                return UP_BOX;
            }
            case DOWN: {
                return DOWN_BOX;
            }
        }
        return Shapes.m_83144_();
    }

    @Deprecated
    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity && ((Boolean)state.m_61143_((Property)ACTIVATED)).booleanValue()) {
            switch (this.type) {
                case CURSE: {
                    this.triggerCurse(worldIn, entity);
                    break;
                }
                case FIRE: {
                    entity.m_20254_(20);
                    break;
                }
                case PLAIN: {
                    entity.m_6469_(worldIn.m_269111_().m_269325_(), 1.0f);
                    break;
                }
            }
        }
    }

    private void triggerCurse(Level worldIn, Entity entity) {
        if (worldIn.f_46441_.m_188500_() < 0.2) {
            LivingEntity living = (LivingEntity)entity;
            switch (worldIn.f_46441_.m_188503_(4)) {
                case 0: {
                    if (living.m_21023_(MobEffects.f_19597_)) break;
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 160, 2));
                    break;
                }
                case 1: {
                    if (living.m_21023_(MobEffects.f_19613_)) break;
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 160, 2));
                    break;
                }
                case 2: {
                    if (living.m_21023_(MobEffects.f_19590_)) break;
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19590_, 160, 1));
                    break;
                }
                case 3: {
                    if (living.m_21023_(MobEffects.f_19599_)) break;
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 160, 2));
                    break;
                }
                case 4: {
                    entity.m_6469_(worldIn.m_269111_().m_269425_(), 1.0f);
                    break;
                }
                case 5: {
                    if (living.m_21023_(MobEffects.f_19610_)) break;
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 160, 1));
                }
            }
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!((Boolean)state.m_61143_((Property)ACTIVATED)).booleanValue() && world.m_276867_(pos)) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)ACTIVATED, (Comparable)Boolean.valueOf(true)));
            if (!world.f_46443_) {
                SoundUtil.playSoundFromServer((ServerLevel)((ServerLevel)world), (BlockPos)pos, (SoundEvent)((SoundEvent)SoundRegistry.SPIKES_ON.get()));
            }
        } else if (((Boolean)state.m_61143_((Property)ACTIVATED)).booleanValue() && !world.m_276867_(pos)) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)));
            if (!world.f_46443_) {
                SoundUtil.playSoundFromServer((ServerLevel)((ServerLevel)world), (BlockPos)pos, (SoundEvent)((SoundEvent)SoundRegistry.SPIKES_OFF.get()));
            }
        }
        super.m_6861_(state, world, pos, blockIn, fromPos, isMoving);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level worldIn = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction facing = context.m_43719_();
        boolean isSolid = worldIn.m_8055_(pos.m_121945_(facing.m_122424_())).m_60815_();
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
        if (isSolid) {
            return (BlockState)((BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)facing)).m_61124_((Property)ACTIVATED, (Comparable)Boolean.valueOf(false));
        }
        return (BlockState)((BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.DOWN)).m_61124_((Property)ACTIVATED, (Comparable)Boolean.valueOf(false));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61372_}).m_61104_(new Property[]{ACTIVATED}).m_61104_(new Property[]{WATERLOGGED});
    }
}

