/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.spawntriggers;

import com.lothrazar.cyclic.block.BlockCyclic;
import com.lothrazar.cyclic.block.spawntriggers.TileAltar;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.library.util.ParticleUtil;
import com.lothrazar.library.util.SoundUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeConfigSpec;

public class BlockAltarNoTraders
extends BlockCyclic
implements SimpleWaterloggedBlock {
    public static ForgeConfigSpec.IntValue HEIGHT;
    public static ForgeConfigSpec.IntValue RADIUS;
    public static final BooleanProperty WATERLOGGED;
    private static final double BOUNDS = 3.0;
    public static final VoxelShape AABB;

    public BlockAltarNoTraders(BlockBehaviour.Properties properties) {
        super(properties.m_60978_(1.2f).m_60955_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return BlockAltarNoTraders.createTickerHelper(type, (BlockEntityType)((BlockEntityType)TileRegistry.NO_SOLICITING.get()), (BlockEntityTicker)(world.f_46443_ ? TileAltar::clientTick : TileAltar::serverTick));
    }

    @Override
    public BlockEntity m_142194_(BlockPos p, BlockState st) {
        return new TileAltar(p, st);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (hand == InteractionHand.MAIN_HAND) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)LIT) == false)));
            SoundUtil.playSound((Level)world, (BlockPos)pos, (SoundEvent)SoundEvents.f_11937_);
            ParticleUtil.spawnParticle((Level)world, (ParticleOptions)ParticleTypes.f_123769_, (BlockPos)pos.m_7494_(), (int)12);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, result);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_214162_(BlockState bs, Level world, BlockPos pos, RandomSource rand) {
        if (((Boolean)bs.m_61143_((Property)LIT)).booleanValue()) {
            if (rand.m_188503_(10) == 0) {
                world.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11784_, SoundSource.BLOCKS, 0.5f + rand.m_188501_(), rand.m_188501_() * 0.7f + 0.6f, false);
            }
            if (rand.m_188503_(5) == 0) {
                for (int i = 0; i < rand.m_188503_(1) + 1; ++i) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123756_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (double)(rand.m_188501_() / 2.0f), 5.0E-5, (double)(rand.m_188501_() / 2.0f));
                }
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LIT}).m_61104_(new Property[]{WATERLOGGED});
    }

    public static boolean isSpawnDenied(LivingEntity mob, MobSpawnType res) {
        return mob.m_6095_() == EntityType.f_20488_ || mob.m_6095_() == EntityType.f_20494_ || mob.m_6095_() == EntityType.f_20549_;
    }

    static {
        WATERLOGGED = BlockStateProperties.f_61362_;
        AABB = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
    }
}

