/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.melter;

import com.google.gson.JsonObject;
import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.melter.TileMelter;
import com.lothrazar.cyclic.registry.CyclicRecipeType;
import com.lothrazar.library.recipe.ingredient.EnergyIngredient;
import com.lothrazar.library.util.RecipeUtil;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;

public class RecipeMelter
implements Recipe<TileMelter> {
    private final ResourceLocation id;
    private NonNullList<Ingredient> ingredients = NonNullList.m_122779_();
    private FluidStack outFluid;
    private final EnergyIngredient energy;

    public RecipeMelter(ResourceLocation id, NonNullList<Ingredient> ingredientsIn, FluidStack out, EnergyIngredient energy) {
        this.id = id;
        this.energy = energy;
        this.ingredients = ingredientsIn;
        if (this.ingredients.size() == 1) {
            this.ingredients.add((Object)Ingredient.f_43901_);
        }
        if (this.ingredients.size() != 2) {
            throw new IllegalArgumentException("Melter recipe must have at most two ingredients");
        }
        this.outFluid = out;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public boolean m_5598_() {
        return true;
    }

    public boolean matches(TileMelter inv, Level worldIn) {
        try {
            TileMelter tile = inv;
            boolean matchLeft = this.matches(tile.getStackInputSlot(0), (Ingredient)this.ingredients.get(0));
            boolean matchRight = this.matches(tile.getStackInputSlot(1), (Ingredient)this.ingredients.get(1));
            return matchLeft && matchRight;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public boolean matches(ItemStack current, Ingredient ing) {
        if (ing == Ingredient.f_43901_) {
            return current.m_41619_();
        }
        if (current.m_41619_()) {
            return ing == Ingredient.f_43901_;
        }
        return ing.test(current);
    }

    public ItemStack[] ingredientAt(int slot) {
        Ingredient ing = this.at(slot);
        return ing.m_43908_();
    }

    public Ingredient at(int slot) {
        return (Ingredient)this.ingredients.get(slot);
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public ItemStack m_8043_(RegistryAccess ra) {
        return ItemStack.f_41583_;
    }

    public FluidStack getRecipeFluid() {
        return this.outFluid.copy();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)CyclicRecipeType.MELTER.get();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CyclicRecipeType.MELTER_S.get();
    }

    public ItemStack assemble(TileMelter t, RegistryAccess ra) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width <= 2 && height <= 1;
    }

    public int getEnergyCost() {
        return this.energy.getEnergyTotal();
    }

    public EnergyIngredient getEnergy() {
        return this.energy;
    }

    public static class SerializeMelter
    implements RecipeSerializer<RecipeMelter> {
        public RecipeMelter fromJson(ResourceLocation recipeId, JsonObject json) {
            RecipeMelter r = null;
            try {
                NonNullList list = RecipeUtil.getIngredientsArray((JsonObject)json);
                JsonObject result = json.get("result").getAsJsonObject();
                FluidStack fluid = RecipeUtil.getFluid((JsonObject)result);
                r = new RecipeMelter(recipeId, (NonNullList<Ingredient>)list, fluid, new EnergyIngredient(json));
            }
            catch (Exception e) {
                ModCyclic.LOGGER.error("Error loading recipe " + recipeId, e);
            }
            return r;
        }

        public RecipeMelter fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buf) {
            NonNullList ins = NonNullList.m_122779_();
            ins.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            ins.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            return new RecipeMelter(recipeId, (NonNullList<Ingredient>)ins, FluidStack.readFromPacket((FriendlyByteBuf)buf), new EnergyIngredient(buf.readInt(), buf.readInt()));
        }

        public void toNetwork(FriendlyByteBuf buf, RecipeMelter recipe) {
            Ingredient zero = (Ingredient)recipe.ingredients.get(0);
            Ingredient one = (Ingredient)recipe.ingredients.get(1);
            zero.m_43923_(buf);
            one.m_43923_(buf);
            recipe.outFluid.writeToPacket(buf);
            buf.writeInt(recipe.energy.getRfPertick());
            buf.writeInt(recipe.energy.getTicks());
        }
    }
}

