/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.generatorfuel;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.generatorfuel.ContainerGeneratorFuel;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.library.cap.CustomEnergyStorage;
import com.lothrazar.library.cap.ItemStackHandlerWrapper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileGeneratorFuel
extends TileBlockEntityCyclic
implements MenuProvider {
    static final int MAX = 640000;
    public static ForgeConfigSpec.IntValue RF_PER_TICK;
    CustomEnergyStorage energy = new CustomEnergyStorage(640000, 640000);
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    ItemStackHandler inputSlots = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) > 0;
        }
    };
    ItemStackHandler outputSlots = new ItemStackHandler(0);
    private ItemStackHandlerWrapper inventory = new ItemStackHandlerWrapper(this.inputSlots, this.outputSlots);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    final int factor = 1;
    private int burnTimeMax = 0;
    private int burnTime = 0;

    public TileGeneratorFuel(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.GENERATOR_FUEL.get(), pos, state);
        this.needsRedstone = 0;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileGeneratorFuel e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileGeneratorFuel e) {
        e.tick();
    }

    public void tick() {
        this.syncEnergy();
        if (this.flowing == 1) {
            this.exportEnergyAllSides();
        }
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        if (this.burnTime == 0) {
            this.setLitProperty(false);
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.burnTime == 0) {
            this.tryConsumeFuel();
        }
        if (this.burnTime > 0 && this.energy.getEnergyStored() + (Integer)RF_PER_TICK.get() <= this.energy.getMaxEnergyStored()) {
            --this.burnTime;
            boolean burnt = this.energy.receiveEnergy(((Integer)RF_PER_TICK.get()).intValue(), false) > 0;
            this.setLitProperty(burnt);
        }
    }

    private void tryConsumeFuel() {
        this.burnTimeMax = 0;
        ItemStack stack = this.inputSlots.getStackInSlot(0);
        boolean factor = true;
        int burnTimeTicks = 1 * ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_);
        if (burnTimeTicks > 0) {
            this.burnTime = this.burnTimeMax = burnTimeTicks;
            if (stack.m_41613_() == 1 && stack.hasCraftingRemainingItem()) {
                this.inputSlots.setStackInSlot(0, stack.getCraftingRemainingItem().m_41777_());
            } else {
                stack.m_41774_(1);
            }
        }
    }

    public Component m_5446_() {
        return ((Block)BlockRegistry.GENERATOR_FUEL.get()).m_49954_();
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerGeneratorFuel(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public void invalidateCaps() {
        this.energyCap.invalidate();
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyCap.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.energy.deserializeNBT((Tag)tag.m_128469_("energy"));
        this.inventory.deserializeNBT(tag.m_128469_("inv"));
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
        tag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        super.m_183515_(tag);
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TIMER: {
                return this.burnTime;
            }
            case BURNMAX: {
                return this.burnTimeMax;
            }
            case FLOWING: {
                return this.flowing;
            }
        }
        return 0;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case TIMER: {
                this.burnTime = value;
                break;
            }
            case BURNMAX: {
                this.burnTimeMax = value;
                break;
            }
            case FLOWING: {
                this.flowing = value;
            }
        }
    }

    public int getEnergyMax() {
        return 640000;
    }

    static enum Fields {
        TIMER,
        REDSTONE,
        BURNMAX,
        FLOWING;

    }
}

