/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.endershelf;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.BlockCyclic;
import com.lothrazar.cyclic.block.enderctrl.EnderShelfHelper;
import com.lothrazar.cyclic.block.enderctrl.TileEnderCtrl;
import com.lothrazar.cyclic.block.endershelf.TileEnderShelf;
import com.lothrazar.cyclic.data.DataTags;
import com.lothrazar.library.util.BlockstatesUtil;
import com.lothrazar.library.util.EnchantUtil;
import com.lothrazar.library.util.ItemStackUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class BlockEnderShelf
extends BlockCyclic {
    public BlockEnderShelf(BlockBehaviour.Properties properties) {
        super(properties.m_60978_(1.2f).m_60955_());
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader world, BlockPos pos) {
        return 3.0f * Blocks.f_50078_.getEnchantPowerBonus(Blocks.f_50078_.m_49966_(), world, pos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_});
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileEnderShelf(pos, state);
    }

    @Override
    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            worldIn.m_46747_(pos);
        }
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (hand != InteractionHand.MAIN_HAND && heldItem.m_41619_()) {
            return InteractionResult.PASS;
        }
        TileEnderShelf shelf = this.getTileEntity(world, pos);
        if (heldItem.m_204117_(DataTags.WRENCH)) {
            shelf.toggleShowText();
            player.m_6674_(hand);
            return InteractionResult.PASS;
        }
        Direction face = hit.m_82434_();
        Vec3 hitVec = hit.m_82450_();
        int slot = BlockEnderShelf.getSlotFromHitVec(pos, face, hitVec);
        if (hit.m_82434_() == state.m_61143_((Property)BlockStateProperties.f_61374_)) {
            if (heldItem.m_41720_() == Items.f_42690_) {
                ItemStack stackInSlot = shelf.inventory.getStackInSlot(slot);
                if ((stackInSlot == ItemStack.f_41583_ || EnchantUtil.doBookEnchantmentsMatch((ItemStack)stackInSlot, (ItemStack)heldItem)) && !world.f_46443_) {
                    ItemStack remaining = shelf.inventory.insertItem(slot, heldItem, false);
                    player.m_21008_(hand, remaining);
                    player.m_6674_(hand);
                    return InteractionResult.SUCCESS;
                }
            } else if (heldItem.m_41619_()) {
                ItemStack retrievedBook = shelf.inventory.extractItem(slot, 1, false);
                player.m_21008_(hand, retrievedBook);
                player.m_6674_(hand);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public static int getSlotFromHitVec(BlockPos pos, Direction face, Vec3 hitVec) {
        double normalizedY = hitVec.m_7098_() - (double)pos.m_123342_();
        return (int)Math.floor(normalizedY / 0.2);
    }

    public TileEnderShelf getTileEntity(Level world, BlockPos pos) {
        return (TileEnderShelf)world.m_7702_(pos);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        return new ArrayList<ItemStack>();
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)BlockstatesUtil.getFacingFromEntityHorizontal((BlockPos)pos, (LivingEntity)entity)), 2);
        }
        BlockEntity tileentity = world.m_7702_(pos);
        TileEnderShelf shelf = (TileEnderShelf)tileentity;
        BlockPos controllerPos = EnderShelfHelper.findConnectedController(world, pos);
        if (controllerPos != null) {
            TileEnderCtrl controller = (TileEnderCtrl)world.m_7702_(controllerPos);
            if (controllerPos != null && controller != null) {
                ModCyclic.LOGGER.info("ctrl add new shelf " + pos);
                controller.getShelves().add(pos);
            }
        }
        if (stack.m_41783_() != null) {
            shelf.inventory.deserializeNBT(stack.m_41783_());
        }
    }

    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, BlockEntity tileentity, ItemStack stackToolUsed) {
        super.m_6240_(world, player, pos, state, tileentity, stackToolUsed);
        ItemStack newStack = new ItemStack((ItemLike)this);
        if (tileentity instanceof TileEnderShelf) {
            TileEnderShelf shelf = (TileEnderShelf)tileentity;
            CompoundTag tileData = shelf.inventory.serializeNBT();
            newStack.m_41751_(tileData);
        }
        ItemStackUtil.dropItemStackMotionless((Level)world, (BlockPos)pos, (ItemStack)newStack);
    }
}

