/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.breaker;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.breaker.ContainerBreaker;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class TileBreaker
extends TileBlockEntityCyclic
implements MenuProvider {
    static final int MAX = 64000;
    public static final int TIMER_FULL = 500;

    public TileBreaker(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.BREAKER.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileBreaker e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileBreaker e) {
        e.tick();
    }

    public void tick() {
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        this.setLitProperty(true);
        if (this.f_58857_.f_46443_) {
            return;
        }
        BlockPos target = this.f_58858_.m_121945_(this.getCurrentFacing());
        if (this.isValid(target)) {
            this.f_58857_.m_46961_(target, true);
        }
    }

    private boolean isValid(BlockPos target) {
        BlockState state = this.f_58857_.m_8055_(target);
        if (this.f_58857_.m_46859_(target) && state.m_60800_((BlockGetter)this.f_58857_, target) >= 0.0f) {
            return false;
        }
        return state.m_60819_() == null || state.m_60819_().m_76178_() || state.m_61138_((Property)BlockStateProperties.f_61362_);
    }

    public Component m_5446_() {
        return ((Block)BlockRegistry.BREAKER.get()).m_49954_();
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerBreaker(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case TIMER: {
                this.timer = value;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TIMER: {
                return this.timer;
            }
        }
        return 0;
    }

    public int getEnergyMax() {
        return 64000;
    }

    static enum Fields {
        REDSTONE,
        TIMER;

    }
}

