/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.batteryclay;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.batteryclay.ContainerClayBattery;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.library.cap.CustomEnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class TileClayBattery
extends TileBlockEntityCyclic
implements MenuProvider {
    public static final int MAX = 16000;
    CustomEnergyStorage energy = new CustomEnergyStorage(16000, 4000);
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);

    public TileClayBattery(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.BATTERY_CLAY.get(), pos, state);
    }

    public Component m_5446_() {
        return ((Block)BlockRegistry.BATTERY_CLAY.get()).m_49954_();
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerClayBattery(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileClayBattery e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileClayBattery e) {
        e.tick();
    }

    public void tick() {
        this.syncEnergy();
        if (this.isPowered()) {
            this.moveEnergy(Direction.DOWN, 100);
        }
    }

    public void invalidateCaps() {
        this.energyCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.energy.deserializeNBT((Tag)tag.m_128469_("energy"));
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
        super.m_183515_(tag);
    }

    @Override
    public void setField(int field, int value) {
    }

    @Override
    public int getField(int field) {
        return 0;
    }
}

