/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.antipotion;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.antipotion.BlockAntiBeacon;
import com.lothrazar.cyclic.block.beaconpotion.BeamStuff;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;

public class TileAntiBeacon
extends TileBlockEntityCyclic {
    public static ForgeConfigSpec.IntValue RADIUS;
    public static ForgeConfigSpec.IntValue TICKS;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> POTIONS;
    public static ForgeConfigSpec.BooleanValue HARMFUL_POTIONS;
    private BeamStuff beamStuff = new BeamStuff();

    public TileAntiBeacon(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.ANTI_BEACON.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileAntiBeacon tile) {
        if (tile.isPowered()) {
            return;
        }
        tile.tick(level, blockPos);
        if (tile.timer <= 0) {
            BlockAntiBeacon.markNearbyEntitiesWithAntiBeaconPosition(level, blockPos);
            BlockAntiBeacon.absorbPotions(level, blockPos);
            tile.timer = (Integer)TICKS.get();
        } else {
            --tile.timer;
        }
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileAntiBeacon e) {
        e.tick(level, blockPos);
    }

    private void tick(Level level, BlockPos blockPos) {
        TileAntiBeacon.updateBeam(level, blockPos, this.beamStuff);
    }

    public void m_142339_(Level p_155091_) {
        super.m_142339_(p_155091_);
        this.beamStuff.lastCheckY = p_155091_.m_141937_() - 1;
    }

    public List<BeaconBlockEntity.BeaconBeamSection> getBeamSections() {
        return this.beamStuff.beamSections;
    }

    @Override
    public void setField(int field, int value) {
    }

    @Override
    public int getField(int field) {
        return 0;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
    }
}

