/*
 * Decompiled with CFR 0.152.
 */
package com.ibarnstormer.gbd.sounds;

import com.ibarnstormer.gbd.capability.ModCapabilityProvider;
import com.ibarnstormer.gbd.entities.BeamReactorLaserEntity;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BeamReactorSoundInstance
extends AbstractTickableSoundInstance {
    private static final float VOLUME_MIN = 0.0f;
    private static final float VOLUME_SCALE = 1.0f;
    private static final float PITCH_MIN = 0.7f;
    private static final float PITCH_SCALE = 0.5f;
    private final Player player;
    private final BeamReactorLaserEntity beam;

    public BeamReactorSoundInstance(Player player, BeamReactorLaserEntity beam) {
        super(SoundEvents.f_12001_, SoundSource.PLAYERS, SoundInstance.m_235150_());
        this.player = player;
        this.beam = beam;
        this.f_119580_ = SoundInstance.Attenuation.NONE;
        this.f_119578_ = false;
        this.f_119579_ = 0;
    }

    public void m_7788_() {
        if (this.player != null && this.beam != null) {
            if (this.player.getCapability(ModCapabilityProvider.BEAM_REACTOR_CAPABILITY).isPresent()) {
                this.player.getCapability(ModCapabilityProvider.BEAM_REACTOR_CAPABILITY).ifPresent(cap -> {
                    if (cap.isActive() && cap.canToggle() && !this.beam.m_213877_() && this.player.m_6084_()) {
                        this.f_119575_ = this.player.m_20185_();
                        this.f_119576_ = this.player.m_20186_();
                        this.f_119577_ = this.player.m_20189_();
                        float f = this.beam.getAttackAnimationScale(0.0f);
                        this.f_119573_ = 0.0f + 1.0f * f * f;
                        this.f_119574_ = 0.7f + 0.5f * f;
                    } else {
                        this.m_119609_();
                    }
                });
            } else {
                this.m_119609_();
            }
        } else {
            this.m_119609_();
        }
    }
}

