/*
 * Decompiled with CFR 0.152.
 */
package com.ibarnstormer.gbd.client.renderer;

import com.ibarnstormer.gbd.config.IConfig;
import com.ibarnstormer.gbd.entities.BeamReactorLaserEntity;
import com.ibarnstormer.gbd.utils.Utils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class BeamReactorLaserEntityRenderer
extends EntityRenderer<BeamReactorLaserEntity> {
    private static final ResourceLocation GUARDIAN_BEAM_LOCATION = new ResourceLocation("textures/entity/guardian_beam.png");
    private static final RenderType BEAM_RENDER_TYPE = RenderType.m_110458_((ResourceLocation)GUARDIAN_BEAM_LOCATION);

    public BeamReactorLaserEntityRenderer(EntityRendererProvider.Context p_174008_) {
        super(p_174008_);
    }

    protected int getBlockLightLevel(BeamReactorLaserEntity p_114496_, BlockPos p_114497_) {
        return 15;
    }

    protected int getSkyLightLevel(BeamReactorLaserEntity p_114509_, BlockPos p_114510_) {
        return 15;
    }

    private Vec3 lerpedOffset(BeamReactorLaserEntity p_114803_, float p_114805_, Vec3 offset) {
        double d0 = p_114803_.offsetOld.f_82479_ + (offset.f_82479_ - p_114803_.offsetOld.f_82479_) * (double)p_114805_;
        double d1 = p_114803_.offsetOld.f_82480_ + (offset.f_82480_ - p_114803_.offsetOld.f_82480_) * (double)p_114805_;
        double d2 = p_114803_.offsetOld.f_82481_ + (offset.f_82481_ - p_114803_.offsetOld.f_82481_) * (double)p_114805_;
        return new Vec3(d0, d1, d2);
    }

    private Vec3 getUnlerpedPos(Entity p_114803_, Vec3 offset) {
        double d0 = p_114803_.m_20185_() + offset.f_82479_;
        double d1 = p_114803_.m_20186_() + offset.f_82480_;
        double d2 = p_114803_.m_20189_() + offset.f_82481_;
        return new Vec3(d0, d1, d2);
    }

    private Vec3 lerpPos(Entity p_114803_, float p_114805_, boolean atEyes) {
        double d0 = Mth.m_14139_((double)p_114805_, (double)p_114803_.f_19790_, (double)p_114803_.m_20182_().f_82479_);
        double d1 = Mth.m_14139_((double)p_114805_, (double)(atEyes ? p_114803_.f_19791_ + (double)p_114803_.m_20192_() + 0.2 : p_114803_.f_19791_), (double)(atEyes ? p_114803_.m_20188_() + 0.2 : p_114803_.m_20182_().f_82480_));
        double d2 = Mth.m_14139_((double)p_114805_, (double)p_114803_.f_19792_, (double)p_114803_.m_20182_().f_82481_);
        return new Vec3(d0, d1, d2);
    }

    public void render(BeamReactorLaserEntity beam, float p_114830_, float p_114831_, PoseStack p_114832_, MultiBufferSource p_114833_, int p_114834_) {
        super.m_7392_((Entity)beam, p_114830_, p_114831_, p_114832_, p_114833_, p_114834_);
        Entity owner = beam.getCachedOwner();
        if (owner != null && beam.getClientSideAttackTime() > 1) {
            Vec3 ownerOffset;
            float f = beam.getAttackAnimationScale(p_114831_);
            float f1 = (float)beam.getBeamTick() + p_114831_;
            float f2 = f1 * 0.5f % 1.0f;
            p_114832_.m_85836_();
            Vec3 lerpPosBeam = this.lerpPos(beam, p_114831_, false).m_82548_();
            Vec3 lerpPosOwner = this.lerpPos(owner, p_114831_, true);
            p_114832_.m_85837_(lerpPosBeam.f_82479_ + lerpPosOwner.f_82479_, lerpPosBeam.f_82480_ + lerpPosOwner.f_82480_, lerpPosBeam.f_82481_ + lerpPosOwner.f_82481_);
            float ownerClampedYHeadRot = owner.m_6080_() % 360.0f;
            float xOffset = (float)(Math.cos((double)(ownerClampedYHeadRot - 90.0f) * (Math.PI / 180)) * (double)0.4f);
            float yOffset = (float)(Math.sin((double)(owner.m_146909_() + 90.0f) * (Math.PI / 180)) - 1.0) * 0.2f;
            float zOffset = (float)(Math.sin((double)(ownerClampedYHeadRot - 90.0f) * (Math.PI / 180)) * (double)0.4f);
            Vec3 newOffset = new Vec3((double)(xOffset * (owner.m_146909_() / 90.0f)), (double)yOffset, (double)(zOffset * (owner.m_146909_() / 90.0f)));
            beam.offsetOld = ownerOffset = this.lerpedOffset(beam, p_114831_, newOffset);
            Vec3 vec3 = Utils.rayCastRaw(owner, p_114831_, ((Integer)IConfig.COMMON.beamReactorHelmetMaxRange.get()).intValue()).m_82450_();
            Vec3 vec31 = this.getUnlerpedPos(owner, new Vec3(ownerOffset.f_82479_, ownerOffset.f_82480_ + (double)owner.m_20192_() + 0.2, ownerOffset.f_82481_));
            Vec3 vec32 = vec3.m_82546_(vec31);
            p_114832_.m_85837_(-ownerOffset.f_82479_, ownerOffset.f_82480_, -ownerOffset.f_82481_);
            float f4 = (float)vec32.m_82553_();
            vec32 = vec32.m_82541_();
            float f5 = (float)Math.acos(vec32.f_82480_);
            float f6 = (float)Math.atan2(vec32.f_82481_, vec32.f_82479_);
            p_114832_.m_252781_(Axis.f_252436_.m_252977_((1.5707964f - f6) * 57.295776f));
            p_114832_.m_252781_(Axis.f_252529_.m_252977_(f5 * 57.295776f));
            float f7 = f1 * 0.05f * -1.5f;
            float f8 = f * f;
            int j = 64 + (int)(f8 * 191.0f);
            int k = 32 + (int)(f8 * 191.0f);
            int l = 128 - (int)(f8 * 64.0f);
            float f11 = Mth.m_14089_((float)(f7 + 2.3561945f)) * 0.282f;
            float f12 = Mth.m_14031_((float)(f7 + 2.3561945f)) * 0.282f;
            float f13 = Mth.m_14089_((float)(f7 + 0.7853982f)) * 0.282f;
            float f14 = Mth.m_14031_((float)(f7 + 0.7853982f)) * 0.282f;
            float f15 = Mth.m_14089_((float)(f7 + 3.926991f)) * 0.282f;
            float f16 = Mth.m_14031_((float)(f7 + 3.926991f)) * 0.282f;
            float f17 = Mth.m_14089_((float)(f7 + 5.4977875f)) * 0.282f;
            float f18 = Mth.m_14031_((float)(f7 + 5.4977875f)) * 0.282f;
            float f19 = Mth.m_14089_((float)(f7 + (float)Math.PI)) * 0.2f;
            float f20 = Mth.m_14031_((float)(f7 + (float)Math.PI)) * 0.2f;
            float f21 = Mth.m_14089_((float)(f7 + 0.0f)) * 0.2f;
            float f22 = Mth.m_14031_((float)(f7 + 0.0f)) * 0.2f;
            float f23 = Mth.m_14089_((float)(f7 + 1.5707964f)) * 0.2f;
            float f24 = Mth.m_14031_((float)(f7 + 1.5707964f)) * 0.2f;
            float f25 = Mth.m_14089_((float)(f7 + 4.712389f)) * 0.2f;
            float f26 = Mth.m_14031_((float)(f7 + 4.712389f)) * 0.2f;
            float f29 = -1.0f + f2;
            float f30 = f4 * 2.5f + f29;
            VertexConsumer vertexconsumer = p_114833_.m_6299_(BEAM_RENDER_TYPE);
            PoseStack.Pose posestack$pose = p_114832_.m_85850_();
            Matrix4f matrix4f = posestack$pose.m_252922_();
            Matrix3f matrix3f = posestack$pose.m_252943_();
            BeamReactorLaserEntityRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f19, f4, f20, j, k, l, 0.4999f, f30);
            BeamReactorLaserEntityRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f19, 0.0f, f20, j, k, l, 0.4999f, f29);
            BeamReactorLaserEntityRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f21, 0.0f, f22, j, k, l, 0.0f, f29);
            BeamReactorLaserEntityRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f21, f4, f22, j, k, l, 0.0f, f30);
            BeamReactorLaserEntityRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f23, f4, f24, j, k, l, 0.4999f, f30);
            BeamReactorLaserEntityRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f23, 0.0f, f24, j, k, l, 0.4999f, f29);
            BeamReactorLaserEntityRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f25, 0.0f, f26, j, k, l, 0.0f, f29);
            BeamReactorLaserEntityRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f25, f4, f26, j, k, l, 0.0f, f30);
            float f31 = 0.0f;
            if (beam.f_19797_ % 2 == 0) {
                f31 = 0.5f;
            }
            BeamReactorLaserEntityRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f11, f4, f12, j, k, l, 0.5f, f31 + 0.5f);
            BeamReactorLaserEntityRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f13, f4, f14, j, k, l, 1.0f, f31 + 0.5f);
            BeamReactorLaserEntityRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f17, f4, f18, j, k, l, 1.0f, f31);
            BeamReactorLaserEntityRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f15, f4, f16, j, k, l, 0.5f, f31);
            p_114832_.m_85849_();
        }
    }

    private static void vertex(VertexConsumer p_114842_, Matrix4f p_114843_, Matrix3f p_114844_, float p_114845_, float p_114846_, float p_114847_, int p_114848_, int p_114849_, int p_114850_, float p_114851_, float p_114852_) {
        p_114842_.m_252986_(p_114843_, p_114845_, p_114846_, p_114847_).m_6122_(p_114848_, p_114849_, p_114850_, 255).m_7421_(p_114851_, p_114852_).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(p_114844_, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(BeamReactorLaserEntity p_114482_) {
        return null;
    }
}

