/*
 * Decompiled with CFR 0.152.
 */
package com.vice.balancedflight.foundation.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.world.level.ItemLike;

public class CustomRecipeBuilder {
    Consumer<FinishedRecipe> consumer;
    ItemLike BlockItem;
    private final HashMap<ItemLike, Character> definitionLookup = new HashMap();
    private final List<List<ItemLike>> Rows = new ArrayList<List<ItemLike>>();
    private ItemLike UnlockedBy;
    private final Random r = new Random();
    private final String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public CustomRecipeBuilder(Consumer<FinishedRecipe> consumer, ItemLike BlockItem2) {
        this.consumer = consumer;
        this.BlockItem = BlockItem2;
    }

    public CustomRecipeBuilder UnlockedBy(ItemLike unlockedBy) {
        this.UnlockedBy = unlockedBy;
        return this;
    }

    public CustomRecipeBuilder Row(@Nullable ItemLike item1, @Nullable ItemLike item2, @Nullable ItemLike item3) {
        ArrayList<ItemLike> row = new ArrayList<ItemLike>(3);
        this.Rows.add(row);
        this.AddItem(row, item1);
        this.AddItem(row, item2);
        this.AddItem(row, item3);
        return this;
    }

    public CustomRecipeBuilder Row(@Nullable ItemLike item1, @Nullable ItemLike item2) {
        ArrayList<ItemLike> row = new ArrayList<ItemLike>(2);
        this.Rows.add(row);
        this.AddItem(row, item1);
        this.AddItem(row, item2);
        return this;
    }

    public CustomRecipeBuilder Row(@Nullable ItemLike item1) {
        ArrayList<ItemLike> row = new ArrayList<ItemLike>(1);
        this.Rows.add(row);
        this.AddItem(row, item1);
        return this;
    }

    private void AddItem(ArrayList<ItemLike> row, ItemLike item) {
        row.add(item);
        if (item != null && !this.definitionLookup.containsKey(item)) {
            boolean flag = true;
            while (flag) {
                char letter = this.RandomLetter();
                if (this.definitionLookup.containsValue(Character.valueOf(letter))) continue;
                flag = false;
                this.definitionLookup.put(item, Character.valueOf(letter));
            }
        }
    }

    public void Save() {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)this.BlockItem);
        for (List<ItemLike> list : this.Rows) {
            String pattern = list.stream().map(i -> i == null ? " " : this.definitionLookup.get(i).toString()).collect(Collectors.joining());
            builder.m_126130_(pattern);
        }
        for (Map.Entry entry : this.definitionLookup.entrySet()) {
            builder.m_126127_((Character)entry.getValue(), (ItemLike)entry.getKey());
        }
        builder.m_126132_(this.UnlockedBy.toString(), (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{this.UnlockedBy}));
        builder.m_176498_(this.consumer);
    }

    private char RandomLetter() {
        return "ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(this.r.nextInt("ABCDEFGHIJKLMNOPQRSTUVWXYZ".length()));
    }
}

