/*
 * Decompiled with CFR 0.152.
 */
package com.vice.balancedflight.foundation.events;

import com.vice.balancedflight.content.flightAnchor.FlightController;
import com.vice.balancedflight.foundation.compat.AscendedRingCurio;
import com.vice.balancedflight.foundation.config.BalancedFlightConfig;
import java.util.Objects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CommonEvents {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        FlightController.tick(player);
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        Player player;
        LivingEntity livingEntity;
        if (Objects.equals(event.getSource().m_19385_(), "flyIntoWall") && ((Boolean)BalancedFlightConfig.disableElytraDamage.get()).booleanValue() && (livingEntity = event.getEntity()) instanceof Player && FlightController.AllowedFlightModes(player = (Player)livingEntity, true) != FlightController.FlightMode.None) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity livingEntity;
        if (Objects.equals(event.getSource().m_19385_(), "fall") && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (AscendedRingCurio.HasAscendedRing(player) && ((Boolean)BalancedFlightConfig.disableFallDamageWhenWearingRing.get()).booleanValue()) {
                event.setCanceled(true);
            }
            if (((Boolean)BalancedFlightConfig.disableFallDamageNearAnchor.get()).booleanValue() && FlightController.AllowedFlightModes(player, false) != FlightController.FlightMode.None) {
                event.setCanceled(true);
            }
        }
    }
}

