/*
 * Decompiled with CFR 0.152.
 */
package com.vice.balancedflight.content.flightAnchor;

import com.vice.balancedflight.content.flightAnchor.entity.FlightAnchorEntity;
import com.vice.balancedflight.foundation.compat.AscendedRingCurio;
import com.vice.balancedflight.foundation.config.BalancedFlightConfig;
import net.minecraft.core.Vec3i;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FlightController {
    public static void tick(Player player) {
        FlightMode allowed = FlightController.AllowedFlightModes(player, false);
        switch (allowed) {
            case None: 
            case Elytra: {
                if (player.m_7500_() || !player.m_150110_().f_35936_) break;
                FlightController.stopFlying(player);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 200));
                break;
            }
            case Creative: 
            case Both: {
                if (player.m_150110_().f_35936_) break;
                FlightController.startFlying(player);
                if (!player.m_21023_(MobEffects.f_19591_)) break;
                player.m_21195_(MobEffects.f_19591_);
            }
        }
    }

    public static void startFlying(Player player) {
        if (!player.m_7500_() && !player.m_5833_()) {
            player.m_150110_().f_35936_ = true;
            player.m_6885_();
        }
    }

    public static void stopFlying(Player player) {
        if (!player.m_7500_() && !player.m_5833_()) {
            player.m_150110_().f_35935_ = false;
            player.m_150110_().f_35936_ = false;
            player.m_6885_();
        }
    }

    public static FlightMode AllowedFlightModes(Player player, boolean onlyCareAboutElytra) {
        boolean hasAscended = AscendedRingCurio.HasAscendedRing(player);
        if (hasAscended) {
            boolean CanCreativeFly;
            boolean CanElytraFly = (Boolean)BalancedFlightConfig.ElytraAscended.get();
            FlightMode allowedModes = FlightMode.fromBools(CanElytraFly, CanCreativeFly = ((Boolean)BalancedFlightConfig.CreativeAscended.get()).booleanValue());
            if (allowedModes != FlightMode.Elytra) {
                return allowedModes;
            }
            if (!CanCreativeFly && ((Boolean)BalancedFlightConfig.CreativeAnchor.get()).booleanValue() && FlightController.IsWithinFlightRange(player)) {
                return FlightMode.fromBools(CanElytraFly, true);
            }
            return allowedModes;
        }
        boolean CanElytraFly = (Boolean)BalancedFlightConfig.ElytraAnchor.get();
        boolean CanCreativeFly = (Boolean)BalancedFlightConfig.CreativeAnchor.get();
        if (onlyCareAboutElytra && !CanElytraFly) {
            return FlightMode.None;
        }
        if (FlightController.IsWithinFlightRange(player)) {
            return FlightMode.fromBools(CanElytraFly, CanCreativeFly);
        }
        return FlightMode.None;
    }

    private static boolean IsWithinFlightRange(Player player) {
        if (player.m_9236_().m_46472_() != Level.f_46428_) {
            return false;
        }
        double anchorDistanceMultiplier = (Double)BalancedFlightConfig.anchorDistanceMultiplier.get();
        return FlightAnchorEntity.ActiveAnchors.entrySet().stream().anyMatch(anchor -> FlightController.distSqr((Vec3i)anchor.getKey(), player.m_20182_()) < anchorDistanceMultiplier * (double)((FlightAnchorEntity)((Object)((Object)anchor.getValue()))).getSpeed() * (anchorDistanceMultiplier * (double)((FlightAnchorEntity)((Object)((Object)anchor.getValue()))).getSpeed()));
    }

    private static double distSqr(Vec3i vec, Vec3 other) {
        double d1 = (double)vec.m_123341_() - other.f_82479_;
        double d3 = (double)vec.m_123343_() - other.f_82481_;
        return d1 * d1 + d3 * d3;
    }

    public static enum FlightMode {
        None,
        Elytra,
        Creative,
        Both;


        public static FlightMode fromBools(boolean ElytraAllowed, boolean CreativeAllowed) {
            if (ElytraAllowed && CreativeAllowed) {
                return Both;
            }
            if (ElytraAllowed) {
                return Elytra;
            }
            if (CreativeAllowed) {
                return Creative;
            }
            return None;
        }

        public boolean canElytraFly() {
            return this == Elytra || this == Both;
        }

        public boolean canCreativeFly() {
            return this == Creative || this == Both;
        }
    }
}

