/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.item;

import com.cyanogen.experienceobelisk.renderer.ExperienceObeliskItemRenderer;
import com.cyanogen.experienceobelisk.utils.ExperienceUtils;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ExperienceObeliskItem
extends BlockItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");

    public ExperienceObeliskItem(Block block, Item.Properties p) {
        super(block, p);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, this::controller)});
    }

    protected <E extends ExperienceObeliskItem> PlayState controller(AnimationState<E> state) {
        AnimationController controller = state.getController();
        controller.setAnimation(IDLE);
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){
            private final BlockEntityWithoutLevelRenderer renderer = new ExperienceObeliskItemRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        int amount = stack.m_41784_().m_128469_("BlockEntityTag").m_128451_("Amount");
        int levels = ExperienceUtils.xpToLevels(amount / 20);
        if (stack.m_41782_()) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.experienceobelisk.experience_obelisk.item_fluid_amount", (Object[])new Object[]{Component.m_237113_((String)(amount + " mB")).m_130940_(ChatFormatting.GOLD)}));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.experienceobelisk.experience_obelisk.item_levels", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(levels)).m_130940_(ChatFormatting.GREEN)}));
        }
        super.m_7373_(stack, level, tooltip, flag);
    }
}

