/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.block_entities;

import com.cyanogen.experienceobelisk.block.LinearAcceleratorBlock;
import com.cyanogen.experienceobelisk.block_entities.AbstractAcceleratorEntity;
import com.cyanogen.experienceobelisk.registries.RegisterBlockEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class LinearAcceleratorEntity
extends AbstractAcceleratorEntity {
    static double orbSpeed = 1.5;
    static double entitySpeed = 0.6;

    public LinearAcceleratorEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RegisterBlockEntities.LINEARACCELERATOR_BE.get(), pos, state);
    }

    public static <T> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (blockEntity instanceof LinearAcceleratorEntity) {
            LinearAcceleratorEntity accelerator = (LinearAcceleratorEntity)((Object)blockEntity);
            if (!accelerator.redstoneEnabled || level.m_276867_(pos)) {
                if (!((Boolean)state.m_61143_((Property)LinearAcceleratorBlock.ACTIVE)).booleanValue()) {
                    state = (BlockState)state.m_61124_((Property)LinearAcceleratorBlock.ACTIVE, (Comparable)Boolean.valueOf(true));
                    level.m_46597_(pos, state);
                }
                Direction facing = (Direction)state.m_61143_((Property)LinearAcceleratorBlock.FACING);
                int x = 0;
                int z = 0;
                switch (facing) {
                    case NORTH: {
                        z = -1;
                        break;
                    }
                    case SOUTH: {
                        z = 1;
                        break;
                    }
                    case EAST: {
                        x = 1;
                        break;
                    }
                    case WEST: {
                        x = -1;
                    }
                }
                AABB area = new AABB((double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 2), (double)(pos.m_123343_() + 1));
                List list = level.m_45933_(null, area);
                if (!list.isEmpty()) {
                    for (Entity entity : list) {
                        Player player;
                        boolean isShiftPlayer;
                        boolean bl = isShiftPlayer = entity instanceof Player && (player = (Player)entity).m_6144_();
                        if (entity instanceof ExperienceOrb) {
                            ExperienceOrb orb = (ExperienceOrb)entity;
                            orb.m_246865_(new Vec3(orbSpeed * (double)x, 0.0, orbSpeed * (double)z));
                            continue;
                        }
                        if (isShiftPlayer) continue;
                        entity.m_246865_(new Vec3(entitySpeed * (double)x, 0.0, entitySpeed * (double)z));
                    }
                }
            } else if (((Boolean)state.m_61143_((Property)LinearAcceleratorBlock.ACTIVE)).booleanValue()) {
                state = (BlockState)state.m_61124_((Property)LinearAcceleratorBlock.ACTIVE, (Comparable)Boolean.valueOf(false));
                level.m_46597_(pos, state);
            }
        }
    }
}

