/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.inventory;

import java.util.stream.IntStream;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.function.CachedSupplier;
import net.darkhax.bookshelf.api.inventory.IInventoryAccess;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;

public class ContainerInventoryAccess<T extends Container>
implements IInventoryAccess {
    protected final T internal;
    private final CachedSupplier<int[]> availableSlots;

    public ContainerInventoryAccess(T internal) {
        this.internal = internal;
        this.availableSlots = CachedSupplier.cache(() -> IntStream.range(0, internal.m_6643_()).toArray());
    }

    @Override
    public int[] getAvailableSlots(Direction side) {
        return this.availableSlots.get();
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return this.internal.m_8020_(slot);
    }

    @Override
    public ItemStack insert(int slot, ItemStack insertStack, Direction side, boolean modify) {
        return this.insert(slot, insertStack, side, modify, false);
    }

    public ItemStack insert(int slot, ItemStack insertStack, Direction side, boolean modify, boolean forceInsert) {
        if (insertStack.m_41619_() || !forceInsert && !this.isValidForSlot(slot, insertStack, side)) {
            return insertStack;
        }
        ItemStack existingStack = this.internal.m_8020_(slot);
        if (!existingStack.m_41619_()) {
            if (existingStack.m_41613_() >= Math.min(existingStack.m_41741_(), this.getSlotSize(slot))) {
                return insertStack;
            }
            if (!Services.INVENTORY_HELPER.canItemsStack(existingStack, insertStack)) {
                return insertStack;
            }
            int availableSpace = Math.min(insertStack.m_41741_(), this.getSlotSize(slot) - existingStack.m_41613_());
            if (availableSpace < 1) {
                return insertStack;
            }
            if (insertStack.m_41613_() <= availableSpace) {
                if (modify) {
                    ItemStack replacement = insertStack.m_41777_();
                    replacement.m_41769_(existingStack.m_41613_());
                    this.updateSlot(slot, replacement);
                }
                return ItemStack.f_41583_;
            }
            ItemStack uninserted = insertStack.m_41777_();
            if (modify) {
                ItemStack replacement = uninserted.m_41620_(availableSpace);
                replacement.m_41769_(existingStack.m_41613_());
                this.updateSlot(slot, replacement);
                return uninserted;
            }
            uninserted.m_41774_(availableSpace);
            return uninserted;
        }
        int availableSpace = Math.min(insertStack.m_41741_(), this.getSlotSize(slot));
        if (availableSpace < insertStack.m_41613_()) {
            ItemStack uninserted = insertStack.m_41777_();
            if (modify) {
                this.updateSlot(slot, uninserted.m_41620_(availableSpace));
                return uninserted;
            }
            uninserted.m_41774_(availableSpace);
            return uninserted;
        }
        if (modify) {
            this.updateSlot(slot, insertStack.m_41777_());
        }
        return ItemStack.f_41583_;
    }

    @Override
    public ItemStack extract(int slot, int amount, Direction side, boolean modify) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack existingStack = this.internal.m_8020_(slot);
        if (existingStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (modify) {
            int amountExtracted = Math.min(existingStack.m_41613_(), amount);
            ItemStack extracted = this.internal.m_7407_(slot, amountExtracted);
            this.internal.m_6596_();
            return extracted;
        }
        ItemStack extracted = existingStack.m_41777_();
        if (amount < extracted.m_41613_()) {
            extracted.m_41764_(amount);
        }
        return extracted;
    }

    @Override
    public int getSlotSize(int slot) {
        return this.internal.m_6893_();
    }

    @Override
    public boolean isValidForSlot(int slot, ItemStack stack, Direction side) {
        return this.internal.m_7013_(slot, stack);
    }

    protected void updateSlot(int slot, ItemStack stack) {
        this.internal.m_6836_(slot, stack);
        this.internal.m_6596_();
    }
}

