/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.betterthanllamas.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Calendar;
import java.util.Random;
import me.ichun.mods.betterthanllamas.client.model.LlamaFancyModel;
import me.ichun.mods.betterthanllamas.common.BetterThanLlamas;
import net.minecraft.client.model.LlamaModel;
import net.minecraft.client.model.RabbitModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.LlamaRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.item.DyeColor;

public class LlamaFancyLayer
extends RenderLayer<Llama, LlamaModel<Llama>> {
    private final LlamaRenderer renderer;
    private Random rand;
    private LlamaFancyModel model;
    private static final ResourceLocation texFancy = new ResourceLocation("betterthanllamas", "textures/model/fancy.png");
    private static final ResourceLocation texFancyColorizer = new ResourceLocation("betterthanllamas", "textures/model/fancycolorizer.png");
    public final boolean isEasterEggDay;
    private RabbitModel modelRabbit;
    private Rabbit rabbitInstance;
    private static final ResourceLocation BROWN = new ResourceLocation("textures/entity/rabbit/brown.png");
    private static final ResourceLocation WHITE = new ResourceLocation("textures/entity/rabbit/white.png");
    private static final ResourceLocation BLACK = new ResourceLocation("textures/entity/rabbit/black.png");
    private static final ResourceLocation GOLD = new ResourceLocation("textures/entity/rabbit/gold.png");
    private static final ResourceLocation SALT = new ResourceLocation("textures/entity/rabbit/salt.png");
    private static final ResourceLocation WHITE_SPLOTCHED = new ResourceLocation("textures/entity/rabbit/white_splotched.png");
    private static final ResourceLocation TOAST = new ResourceLocation("textures/entity/rabbit/toast.png");
    private static final ResourceLocation CAERBANNOG = new ResourceLocation("textures/entity/rabbit/caerbannog.png");

    public LlamaFancyLayer(LlamaRenderer renderer) {
        super((RenderLayerParent)renderer);
        this.renderer = renderer;
        this.rand = new Random();
        this.model = new LlamaFancyModel();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        boolean bl = this.isEasterEggDay = calendar.get(2) == 3 && calendar.get(5) == 1;
        if (this.isEasterEggDay) {
            this.modelRabbit = new RabbitModel(RabbitModel.m_170882_().m_171564_());
            this.modelRabbit.f_102610_ = false;
            LlamaFancyLayer.processLlamaModelForEE((LlamaModel)renderer.m_7200_());
        }
    }

    public static void processLlamaModelForEE(LlamaModel model) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(33, 4).m_171481_(-4.0f, -9.0f, -6.0f, 8.0f, 11.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)7.0f, (float)-6.0f));
        model.f_103031_ = LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)64).m_171564_().m_171324_("head");
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, Llama llama, float limbSwing, float limbSwingAmount, float renderTick, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!llama.m_20145_()) {
            boolean renderMoustache;
            boolean renderFez;
            boolean renderBowtie;
            boolean renderPipe;
            boolean renderMonocle;
            boolean renderHat;
            boolean iChunLlama;
            boolean bl = iChunLlama = llama.m_8077_() && "iChun".equals(llama.m_7755_().getString());
            if (iChunLlama) {
                this.rand.setSeed(Math.abs((long)"iChun".hashCode() + (long)llama.m_19879_() * 63268L * 5642L));
            } else {
                this.rand.setSeed(Math.abs((long)(llama.m_8077_() ? llama.m_7755_().getString().hashCode() : llama.m_20148_().hashCode()) * 5642L));
            }
            if (iChunLlama) {
                renderHat = this.rand.nextBoolean();
                renderMonocle = this.rand.nextBoolean();
                renderPipe = this.rand.nextBoolean();
                renderBowtie = this.rand.nextBoolean();
                renderFez = this.rand.nextBoolean();
                renderMoustache = this.rand.nextBoolean();
            } else {
                renderHat = this.rand.nextFloat() < (float)BetterThanLlamas.config.hatChance.get().intValue() / 100.0f;
                renderMonocle = this.rand.nextFloat() < (float)BetterThanLlamas.config.monocleChance.get().intValue() / 100.0f;
                renderPipe = this.rand.nextFloat() < (float)BetterThanLlamas.config.pipeChance.get().intValue() / 100.0f;
                renderBowtie = this.rand.nextFloat() < (float)BetterThanLlamas.config.bowtieChance.get().intValue() / 100.0f;
                renderFez = this.rand.nextFloat() < (float)BetterThanLlamas.config.fezChance.get().intValue() / 100.0f;
                boolean bl2 = renderMoustache = this.rand.nextFloat() < (float)BetterThanLlamas.config.moustacheChance.get().intValue() / 100.0f;
            }
            if (renderHat && renderFez) {
                renderHat = this.rand.nextBoolean();
                boolean bl3 = renderFez = !renderHat;
            }
            if (this.isEasterEggDay) {
                if (renderHat || renderMonocle || renderPipe || renderBowtie) {
                    ResourceLocation bunnyTex;
                    float[] clr = new float[3];
                    if (iChunLlama) {
                        int i = llama.f_19797_ / 25 + llama.m_19879_();
                        int j = DyeColor.values().length;
                        int k = i % j;
                        int l = (i + 1) % j;
                        float f = ((float)(llama.f_19797_ % 25) + renderTick) / 25.0f;
                        float[] afloat1 = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)k));
                        float[] afloat2 = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)l));
                        clr[0] = afloat1[0] * (1.0f - f) + afloat2[0] * f;
                        clr[1] = afloat1[1] * (1.0f - f) + afloat2[1] * f;
                        clr[2] = afloat1[2] * (1.0f - f) + afloat2[2] * f;
                    } else if (llama.m_30826_() != null) {
                        clr = Sheep.m_29829_((DyeColor)llama.m_30826_());
                    } else {
                        this.rand.setSeed(Math.abs((long)llama.m_19879_() * 1234L));
                        clr = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)this.rand.nextInt(16)));
                    }
                    matrixStackIn.m_85836_();
                    if (llama.m_6162_()) {
                        matrixStackIn.m_85841_(0.71428573f, 0.64935064f, 0.7936508f);
                        matrixStackIn.m_85837_(0.0, 1.3125, (double)0.22f);
                    }
                    matrixStackIn.m_252880_(0.0f, 0.4375f, -0.375f);
                    matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(netHeadYaw));
                    matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(LlamaFancyLayer.interpolateValues(llama.f_19860_, llama.m_146909_(), renderTick)));
                    matrixStackIn.m_252880_(0.0f, -0.4375f, 0.375f);
                    float scale = 0.0625f;
                    matrixStackIn.m_252880_(0.0f, -26.0f * scale, -10.0f * scale);
                    if (llama.m_8077_() && "Toast".equals(llama.m_7755_().getString())) {
                        bunnyTex = TOAST;
                    } else {
                        switch (this.rand.nextInt(7)) {
                            default: {
                                ResourceLocation resourceLocation = BROWN;
                                break;
                            }
                            case 1: {
                                ResourceLocation resourceLocation = WHITE;
                                break;
                            }
                            case 2: {
                                ResourceLocation resourceLocation = BLACK;
                                break;
                            }
                            case 3: {
                                ResourceLocation resourceLocation = WHITE_SPLOTCHED;
                                break;
                            }
                            case 4: {
                                ResourceLocation resourceLocation = GOLD;
                                break;
                            }
                            case 5: {
                                ResourceLocation resourceLocation = SALT;
                                break;
                            }
                            case 6: {
                                ResourceLocation resourceLocation = bunnyTex = CAERBANNOG;
                            }
                        }
                    }
                    if (this.rabbitInstance == null || this.rabbitInstance.m_9236_() != llama.m_9236_()) {
                        this.rabbitInstance = new Rabbit(EntityType.f_20517_, llama.m_9236_());
                    }
                    VertexConsumer ivertexbuilder = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)bunnyTex));
                    int packedOverlay = LivingEntityRenderer.m_115338_((LivingEntity)llama, (float)0.0f);
                    this.modelRabbit.m_6973_(this.rabbitInstance, limbSwing, limbSwingAmount, ageInTicks, 0.0f, 0.0f);
                    this.modelRabbit.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    matrixStackIn.m_85841_(0.6f, 0.6f, 0.6f);
                    matrixStackIn.m_252880_(0.0f, 16.0f * scale, 0.0f);
                    if (renderHat || renderMonocle || renderPipe) {
                        matrixStackIn.m_85836_();
                        ivertexbuilder = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)texFancy));
                        this.model.renderHeadParts(renderHat, renderMonocle, renderPipe, false, matrixStackIn, ivertexbuilder, packedLightIn, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                        if (renderHat) {
                            ivertexbuilder = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)texFancyColorizer));
                            this.model.renderHeadParts(renderHat, renderMonocle, renderPipe, true, matrixStackIn, ivertexbuilder, packedLightIn, packedOverlay, clr[0], clr[1], clr[2], 1.0f);
                        }
                        matrixStackIn.m_85849_();
                    }
                    if (renderBowtie) {
                        ivertexbuilder = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)texFancy));
                        this.model.renderBody(this.rabbitInstance, false, ageInTicks, matrixStackIn, ivertexbuilder, packedLightIn, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                        ivertexbuilder = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)texFancyColorizer));
                        this.model.renderBody(this.rabbitInstance, true, ageInTicks, matrixStackIn, ivertexbuilder, packedLightIn, packedOverlay, clr[0], clr[1], clr[2], 1.0f);
                    }
                    matrixStackIn.m_85849_();
                }
            } else if (this.rand.nextFloat() < (float)BetterThanLlamas.config.fancyChance.get().intValue() / 100.0f && (renderHat || renderMonocle || renderPipe || renderBowtie || renderFez || renderMoustache)) {
                float[] clr = new float[3];
                if (iChunLlama) {
                    int i = llama.f_19797_ / 25 + llama.m_19879_();
                    int j = DyeColor.values().length;
                    int k = i % j;
                    int l = (i + 1) % j;
                    float f = ((float)(llama.f_19797_ % 25) + renderTick) / 25.0f;
                    float[] afloat1 = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)k));
                    float[] afloat2 = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)l));
                    clr[0] = afloat1[0] * (1.0f - f) + afloat2[0] * f;
                    clr[1] = afloat1[1] * (1.0f - f) + afloat2[1] * f;
                    clr[2] = afloat1[2] * (1.0f - f) + afloat2[2] * f;
                } else {
                    this.rand.setSeed(Math.abs((long)llama.m_19879_() * 1234L));
                    clr = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)this.rand.nextInt(16)));
                }
                VertexConsumer ivertexbuilder = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)texFancy));
                int packedOverlay = LivingEntityRenderer.m_115338_((LivingEntity)llama, (float)0.0f);
                matrixStackIn.m_85836_();
                if (llama.m_6162_()) {
                    matrixStackIn.m_85841_(0.71428573f, 0.64935064f, 0.7936508f);
                    matrixStackIn.m_85837_(0.0, 1.3125, (double)0.22f);
                }
                matrixStackIn.m_252880_(0.0f, 0.4375f, -0.375f);
                float pitch = LlamaFancyLayer.interpolateValues(llama.f_19860_, llama.m_146909_(), renderTick);
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(netHeadYaw));
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(pitch));
                matrixStackIn.m_252880_(0.0f, -0.4375f, 0.375f);
                this.model.fez3.f_104203_ = -1.2292354f + (float)Math.toRadians(-Mth.m_14036_((float)pitch, (float)-90.0f, (float)0.0f));
                this.model.renderLlama(false, renderHat, renderMonocle, renderPipe, renderBowtie, renderFez, renderMoustache, matrixStackIn, ivertexbuilder, packedLightIn, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                if (renderHat || renderBowtie) {
                    ivertexbuilder = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)texFancyColorizer));
                    this.model.renderLlama(true, renderHat, renderMonocle, renderPipe, renderBowtie, renderFez, renderMoustache, matrixStackIn, ivertexbuilder, packedLightIn, packedOverlay, clr[0], clr[1], clr[2], 1.0f);
                }
                matrixStackIn.m_85849_();
            }
        }
    }

    public static float interpolateValues(float prevVal, float nextVal, float partialTick) {
        return prevVal + partialTick * (nextVal - prevVal);
    }
}

