/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.beams.registration;

import io.github.davidqf555.minecraft.beams.common.modules.ColorModuleType;
import io.github.davidqf555.minecraft.beams.common.modules.DamageModuleType;
import io.github.davidqf555.minecraft.beams.common.modules.EnderModuleType;
import io.github.davidqf555.minecraft.beams.common.modules.FireModuleType;
import io.github.davidqf555.minecraft.beams.common.modules.ForceModuleType;
import io.github.davidqf555.minecraft.beams.common.modules.FreezeModuleType;
import io.github.davidqf555.minecraft.beams.common.modules.LayersModuleType;
import io.github.davidqf555.minecraft.beams.common.modules.MiningModuleType;
import io.github.davidqf555.minecraft.beams.common.modules.PotionEffectModuleType;
import io.github.davidqf555.minecraft.beams.common.modules.ProjectorModuleType;
import io.github.davidqf555.minecraft.beams.common.modules.SizeModuleType;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.DyeColor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="beams", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ProjectorModuleRegistry {
    public static final DeferredRegister<ProjectorModuleType> TYPES = DeferredRegister.create((ResourceKey)ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("beams", "module_type")), (String)"beams");
    public static final Map<DyeColor, RegistryObject<ColorModuleType>> COLORS = Arrays.stream(DyeColor.values()).collect(Collectors.toMap(color -> color, color -> ProjectorModuleRegistry.register(color.m_7912_(), () -> new ColorModuleType(color.m_41070_()))));
    public static final RegistryObject<PotionEffectModuleType> BRIGHT = ProjectorModuleRegistry.register("bright", () -> new PotionEffectModuleType(MobEffects.f_19610_, amt -> amt * 30, amt -> 0));
    public static final RegistryObject<FireModuleType> HOT = ProjectorModuleRegistry.register("hot", () -> new FireModuleType(amt -> amt * 2));
    public static final RegistryObject<DamageModuleType> DAMAGE = ProjectorModuleRegistry.register("damage", () -> new DamageModuleType(10, amt -> Float.valueOf(amt.intValue())));
    public static final RegistryObject<EnderModuleType> ENDER = ProjectorModuleRegistry.register("ender", () -> new EnderModuleType(16.0));
    public static final RegistryObject<ForceModuleType> FORCE = ProjectorModuleRegistry.register("force", () -> new ForceModuleType(amt -> (double)amt.intValue() * 0.05));
    public static final RegistryObject<MiningModuleType> MINING = ProjectorModuleRegistry.register("mining", () -> new MiningModuleType(20, amt -> Float.valueOf((float)amt.intValue() * 2.0f)));
    public static final RegistryObject<LayersModuleType> LAYERS = ProjectorModuleRegistry.register("layers", () -> new LayersModuleType(amt -> amt));
    public static final RegistryObject<SizeModuleType> GROWTH = ProjectorModuleRegistry.register("growth", () -> new SizeModuleType(amt -> 1.0, amt -> (double)amt.intValue() * 0.025));
    public static final RegistryObject<SizeModuleType> SHRINK = ProjectorModuleRegistry.register("shrink", () -> new SizeModuleType(amt -> Math.pow(0.75, amt.intValue()), amt -> 0.0));
    public static final RegistryObject<ForceModuleType> TRACTOR = ProjectorModuleRegistry.register("tractor", () -> new ForceModuleType(amt -> (double)amt.intValue() * -0.025));
    public static final RegistryObject<FreezeModuleType> FREEZE = ProjectorModuleRegistry.register("freeze", () -> new FreezeModuleType(amt -> amt, amt -> amt * 20, amt -> amt));
    private static Supplier<IForgeRegistry<ProjectorModuleType>> registry = null;

    private ProjectorModuleRegistry() {
    }

    private static <T extends ProjectorModuleType> RegistryObject<T> register(String name, Supplier<T> type) {
        return TYPES.register(name, type);
    }

    public static IForgeRegistry<ProjectorModuleType> getRegistry() {
        return registry.get();
    }

    @SubscribeEvent
    public static void onNewRegistry(NewRegistryEvent event) {
        registry = event.create(new RegistryBuilder().setName(new ResourceLocation("beams", "module_type")));
    }
}

